/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.office.FontDeclaration;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Calc;
import writer2latex.util.ExportNameCollection;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleInfo;
import writer2latex.xhtml.StyleWithPropertiesConverterHelper;
import writer2latex.xhtml.XhtmlConfig;
import writer2latex.xhtml.XhtmlStyleMapItem;

public class TextStyleConverter
extends StyleWithPropertiesConverterHelper {
    private static final String DEFAULT_LINK_STYLE = "Internet link";
    private static final String DEFAULT_VISITED_LINK_STYLE = "Visited Internet Link";
    private ExportNameCollection anchorStyleNames = new ExportNameCollection(true);
    private ExportNameCollection anchorVisitedStyleNames = new ExportNameCollection(true);
    private Hashtable<String, String> anchorCombinedStyleNames = new Hashtable();
    private Hashtable<String, String> orgAnchorStyleNames = new Hashtable();
    private Hashtable<String, String> orgAnchorVisitedStyleNames = new Hashtable();
    private boolean bRelativeFontSize = false;
    private String sFontScaling = "100%";
    private String sBaseFontSize = "12pt";
    private boolean bConvertFont = false;

    public TextStyleConverter(OfficeReader ofr, XhtmlConfig config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        String sFontSize;
        this.styleMap = config.getXTextStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 2;
        this.bConvertHard = config.xhtmlFormatting() == 3 || config.xhtmlFormatting() == 1;
        this.bRelativeFontSize = converter.isOPS() && config.relativeFontSize();
        this.sFontScaling = config.fontScaling();
        StyleWithProperties defaultStyle = ofr.getDefaultParStyle();
        if (defaultStyle != null && (sFontSize = defaultStyle.getProperty("fo:font-size", false)) != null) {
            this.sBaseFontSize = sFontSize;
        }
        this.bConvertFont = !config.useDefaultFont();
    }

    public void applyAnchorStyle(String sStyleName, String sVisitedStyleName, StyleInfo info) {
        if (sStyleName == null || sVisitedStyleName == null) {
            return;
        }
        if (sStyleName.length() == 0 || sVisitedStyleName.length() == 0) {
            return;
        }
        String sDisplayName = this.ofr.getTextStyles().getDisplayName(sStyleName);
        if (this.styleMap.contains(sDisplayName)) {
            XhtmlStyleMapItem map = this.styleMap.get(sDisplayName);
            if (!"(none)".equals(map.sCss)) {
                info.sClass = map.sCss;
            }
            return;
        }
        String sName = sStyleName + sVisitedStyleName;
        if (!this.anchorCombinedStyleNames.containsKey(sName)) {
            String sExportName = this.anchorStyleNames.containsName(sStyleName) ? this.anchorStyleNames.getExportName(sStyleName) + this.anchorVisitedStyleNames.getExportName(sVisitedStyleName) : this.anchorStyleNames.getExportName(sStyleName);
            this.anchorCombinedStyleNames.put(sName, sExportName);
            this.orgAnchorStyleNames.put(sExportName, sStyleName);
            this.orgAnchorVisitedStyleNames.put(sExportName, sVisitedStyleName);
        }
        info.sClass = this.anchorCombinedStyleNames.get(sName);
    }

    @Override
    public String getStyleDeclarations(String sIndent) {
        StringBuilder buf = new StringBuilder();
        buf.append(super.getStyleDeclarations(sIndent));
        if (this.bConvertStyles) {
            CSVList props;
            StyleWithProperties defaultLinkStyle = (StyleWithProperties)this.getStyles().getStyleByDisplayName(DEFAULT_LINK_STYLE);
            if (defaultLinkStyle != null) {
                props = new CSVList(";");
                this.cssText(defaultLinkStyle, props, true);
                this.cssHyperlink(defaultLinkStyle, props);
                buf.append(sIndent).append("a:link {").append(props.toString()).append("}\n");
            }
            if ((defaultLinkStyle = (StyleWithProperties)this.getStyles().getStyleByDisplayName(DEFAULT_VISITED_LINK_STYLE)) != null) {
                props = new CSVList(";");
                this.cssText(defaultLinkStyle, props, true);
                this.cssHyperlink(defaultLinkStyle, props);
                buf.append(sIndent).append("a:visited {").append(props.toString()).append("}\n");
            }
            Enumeration<String> enumer = this.anchorCombinedStyleNames.elements();
            while (enumer.hasMoreElements()) {
                CSVList props2;
                String sExportName = enumer.nextElement();
                String sStyleName = this.orgAnchorStyleNames.get(sExportName);
                String sVisitedStyleName = this.orgAnchorVisitedStyleNames.get(sExportName);
                StyleWithProperties style = this.ofr.getTextStyle(sStyleName);
                if (style != null) {
                    props2 = new CSVList(";");
                    this.cssText(style, props2, true);
                    this.cssHyperlink(style, props2);
                    buf.append(sIndent).append("a.").append(sExportName).append(":link {").append(props2.toString()).append("}\n");
                }
                if ((style = this.ofr.getTextStyle(sVisitedStyleName)) == null) continue;
                props2 = new CSVList(";");
                this.cssText(style, props2, true);
                this.cssHyperlink(style, props2);
                buf.append(sIndent).append("a.").append(sExportName).append(":visited {").append(props2.toString()).append("}\n");
            }
        }
        return buf.toString();
    }

    @Override
    public OfficeStyleFamily getStyles() {
        return this.ofr.getTextStyles();
    }

    @Override
    public String getDefaultTagName(StyleWithProperties style) {
        return "span";
    }

    @Override
    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssText(style, props, bInherit);
    }

    public void cssText(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssTextCommon(style, props, bInherit);
        this.cssTextBackground(style, props, bInherit);
    }

    public void cssTextCommon(StyleWithProperties style, CSVList props, boolean bInherit) {
        CSVList val;
        String s = null;
        String s2 = null;
        String s3 = null;
        String s4 = null;
        if (this.bConvertFont && (bInherit || style.getProperty("style:font-name", false) != null)) {
            val = new CSVList(",");
            s = style.getProperty("style:font-name");
            if (s != null) {
                FontDeclaration fd = (FontDeclaration)this.ofr.getFontDeclarations().getStyle(s);
                if (fd != null) {
                    s = fd.getFontFamily();
                    s2 = fd.getFontFamilyGeneric();
                    s3 = fd.getFontPitch();
                }
            } else {
                s = style.getProperty("fo:font-family");
                s2 = style.getProperty("style:font-family-generic");
                s3 = style.getProperty("style:font-pitch");
            }
            if (s != null) {
                val.addValue(s);
            }
            if ("fixed".equals(s3)) {
                val.addValue("monospace");
            } else if ("roman".equals(s2)) {
                val.addValue("serif");
            } else if ("swiss".equals(s2)) {
                val.addValue("sans-serif");
            } else if ("modern".equals(s2)) {
                val.addValue("monospace");
            } else if ("decorative".equals(s2)) {
                val.addValue("fantasy");
            } else if ("script".equals(s2)) {
                val.addValue("cursive");
            } else if ("system".equals(s2)) {
                val.addValue("serif");
            }
            if (!val.isEmpty()) {
                props.addValue("font-family", val.toString());
            }
        }
        if ((s = style.getProperty("fo:font-style", bInherit)) != null) {
            props.addValue("font-style", s);
        }
        if ((s = style.getProperty("fo:font-variant", bInherit)) != null) {
            props.addValue("font-variant", s);
        }
        if ((s = style.getProperty("fo:font-weight", bInherit)) != null) {
            props.addValue("font-weight", s);
        }
        if (bInherit || style.getProperty("fo:font-size", false) != null || style.getProperty("style:text-position", false) != null) {
            s = style.getAbsoluteProperty("fo:font-size");
            s2 = style.getProperty("style:text-position");
            if (s2 != null) {
                int i = (s2 = s2.trim()).indexOf(" ");
                if (i > 0) {
                    s3 = s2.substring(0, i);
                    s4 = s2.substring(i + 1);
                } else {
                    s3 = s2;
                    s4 = "100%";
                }
                if (s != null) {
                    if (this.bRelativeFontSize) {
                        String sFontSize = Calc.divide(Calc.multiply(this.sFontScaling, Calc.multiply(s4, s)), this.sBaseFontSize);
                        if (!"100%".equals(sFontSize)) {
                            props.addValue("font-size", sFontSize);
                        }
                    } else {
                        props.addValue("font-size", Calc.multiply(s4, this.scale(s)));
                    }
                } else {
                    props.addValue("font-size", s4);
                }
                if (!"0%".equals(s3)) {
                    props.addValue("vertical-align", s3);
                }
            } else if (s != null) {
                if (this.bRelativeFontSize) {
                    String sFontSize = Calc.divide(Calc.multiply(this.sFontScaling, s), this.sBaseFontSize);
                    if (!"100%".equals(sFontSize)) {
                        props.addValue("font-size", sFontSize);
                    }
                } else {
                    props.addValue("font-size", this.scale(s));
                }
            }
        }
        if ((s = style.getProperty("fo:color", bInherit)) != null) {
            props.addValue("color", s);
        }
        if ((s = style.getProperty("fo:text-shadow", bInherit)) != null) {
            props.addValue("text-shadow", s);
        }
        if (this.ofr.isOpenDocument()) {
            s = style.getProperty("style:text-line-through-style", bInherit);
            s2 = style.getProperty("style:text-underline-style", bInherit);
        } else {
            s = style.getProperty("style:text-crossing-out", bInherit);
            s2 = style.getProperty("style:text-underline", bInherit);
        }
        s3 = style.getProperty("style:text-blinking", bInherit);
        if ("none".equals(s) || "none".equals(s2) || "false".equals(s3)) {
            props.addValue("text-decoration", "none");
        } else {
            val = new CSVList(" ");
            if (s != null && !"none".equals(s)) {
                val.addValue("line-through");
            }
            if (s2 != null && !"none".equals(s2)) {
                val.addValue("underline");
            }
            if (s3 != null && "true".equals(s3)) {
                val.addValue("blink");
            }
            if (!val.isEmpty()) {
                props.addValue("text-decoration", val.toString());
            }
        }
        s = style.getProperty("fo:letter-spacing", bInherit);
        if (s != null) {
            props.addValue("letter-spacing", this.scale(s));
        }
        if ((s = style.getProperty("fo:text-transform", bInherit)) != null) {
            props.addValue("text-transform", s);
        }
    }

    public void cssTextBackground(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s;
        String string = s = this.ofr.isOpenDocument() ? style.getTextProperty("fo:background-color", bInherit) : style.getTextProperty("style:text-background-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
    }

    private void cssHyperlink(StyleWithProperties style, CSVList props) {
        String s2;
        String s1;
        if (this.ofr.isOpenDocument()) {
            s1 = style.getProperty("style:text-line-through-style", true);
            s2 = style.getProperty("style:text-underline-style", true);
        } else {
            s1 = style.getProperty("style:text-crossing-out", true);
            s2 = style.getProperty("style:text-underline", true);
        }
        String s3 = style.getProperty("style:text-blinking", true);
        if (s1 == null && s2 == null && s3 == null) {
            props.addValue("text-decoration", "none");
        }
    }
}

