/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.servicemanager;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XContentEnumerationAccess;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XSet;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;

public class ServiceManager
implements XMultiServiceFactory,
XMultiComponentFactory,
XSet,
XContentEnumerationAccess,
XComponent,
XServiceInfo {
    private static final boolean DEBUG = false;
    private static Type UNO_TYPE = null;
    static String[] supportedServiceNames = new String[]{"com.sun.star.lang.MultiServiceFactory", "com.sun.star.lang.ServiceManager"};
    ArrayList<XEventListener> eventListener = new ArrayList();
    HashMap<String, Object> factoriesByImplNames = new HashMap();
    HashMap<String, ArrayList<Object>> factoriesByServiceNames = new HashMap();
    private XComponentContext m_xDefaultContext = null;

    private static final void DEBUG(String string) {
    }

    public void setDefaultContext(XComponentContext xComponentContext) {
        this.m_xDefaultContext = xComponentContext;
    }

    @Override
    public Object createInstance(String string) throws com.sun.star.uno.Exception, RuntimeException {
        return this.createInstanceWithContext(string, this.m_xDefaultContext);
    }

    @Override
    public Object createInstanceWithArguments(String string, Object[] objectArray) throws com.sun.star.uno.Exception, RuntimeException {
        return this.createInstanceWithArgumentsAndContext(string, objectArray, this.m_xDefaultContext);
    }

    private Object queryServiceFactory(String string) throws com.sun.star.uno.Exception, RuntimeException {
        ServiceManager.DEBUG("queryServiceFactory for name " + string);
        Object object = null;
        if (this.factoriesByServiceNames.containsKey(string)) {
            ArrayList<Object> arrayList = this.factoriesByServiceNames.get(string);
            ServiceManager.DEBUG("");
            ServiceManager.DEBUG("available factories for " + string + " " + arrayList);
            ServiceManager.DEBUG("");
            if (!arrayList.isEmpty()) {
                object = arrayList.get(arrayList.size() - 1);
            }
        } else {
            object = this.factoriesByImplNames.get(string);
        }
        if (object == null) {
            throw new com.sun.star.uno.Exception("Query for service factory for " + string + " failed.");
        }
        return object;
    }

    @Override
    public String[] getAvailableServiceNames() throws RuntimeException {
        try {
            return this.factoriesByServiceNames.keySet().toArray(new String[this.factoriesByServiceNames.size()]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object createInstanceWithContext(String string, XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        Object object = this.queryServiceFactory(string);
        if (object != null) {
            XSingleComponentFactory xSingleComponentFactory = UnoRuntime.queryInterface(XSingleComponentFactory.class, object);
            if (xSingleComponentFactory != null) {
                return xSingleComponentFactory.createInstanceWithContext(xComponentContext);
            }
            XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
            if (xSingleServiceFactory != null) {
                return xSingleServiceFactory.createInstance();
            }
            throw new com.sun.star.uno.Exception("retrieved service factory object for \"" + string + "\" does not export XSingleComponentFactory nor XSingleServiceFactory!");
        }
        return null;
    }

    @Override
    public Object createInstanceWithArgumentsAndContext(String string, Object[] objectArray, XComponentContext xComponentContext) throws com.sun.star.uno.Exception {
        Object object = this.queryServiceFactory(string);
        if (object != null) {
            XSingleComponentFactory xSingleComponentFactory = UnoRuntime.queryInterface(XSingleComponentFactory.class, object);
            if (xSingleComponentFactory != null) {
                return xSingleComponentFactory.createInstanceWithArgumentsAndContext(objectArray, xComponentContext);
            }
            XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
            if (xSingleServiceFactory != null) {
                return xSingleServiceFactory.createInstanceWithArguments(objectArray);
            }
            throw new com.sun.star.uno.Exception("retrieved service factory object for \"" + string + "\" does not export XSingleComponentFactory nor XSingleServiceFactory!");
        }
        return null;
    }

    @Override
    public void dispose() throws RuntimeException {
        if (this.eventListener != null) {
            for (XEventListener xEventListener : this.eventListener) {
                xEventListener.disposing(new EventObject(this));
            }
            this.eventListener.clear();
        }
        this.factoriesByServiceNames.clear();
        this.factoriesByImplNames.clear();
    }

    @Override
    public void addEventListener(XEventListener xEventListener) throws RuntimeException {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener already registered.");
        }
        this.eventListener.add(xEventListener);
    }

    @Override
    public void removeEventListener(XEventListener xEventListener) throws RuntimeException {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.eventListener.remove(xEventListener);
    }

    @Override
    public boolean has(Object object) throws RuntimeException {
        if (object == null) {
            throw new RuntimeException("The parameter must not been null");
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        return xServiceInfo != null && UnoRuntime.areSame(this.factoriesByImplNames.get(xServiceInfo.getImplementationName()), object);
    }

    @Override
    public void insert(Object object) throws IllegalArgumentException, ElementExistException, RuntimeException {
        String[] stringArray;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        if (xServiceInfo == null) {
            throw new IllegalArgumentException("The given object does not implement the XServiceInfo interface.");
        }
        if (this.factoriesByImplNames.containsKey(xServiceInfo.getImplementationName())) {
            throw new ElementExistException(xServiceInfo.getImplementationName() + " already registered");
        }
        ServiceManager.DEBUG("add factory " + object.toString() + " for " + xServiceInfo.getImplementationName());
        this.factoriesByImplNames.put(xServiceInfo.getImplementationName(), object);
        for (String string : stringArray = xServiceInfo.getSupportedServiceNames()) {
            ArrayList<Object> arrayList;
            if (!this.factoriesByServiceNames.containsKey(string)) {
                ServiceManager.DEBUG("> no registered services found under " + string + ": adding...");
                this.factoriesByServiceNames.put(string, new ArrayList());
            }
            if ((arrayList = this.factoriesByServiceNames.get(string)).contains(object)) {
                System.err.println("The implementation " + xServiceInfo.getImplementationName() + " already registered for the service " + string + " - ignoring!");
                continue;
            }
            arrayList.add(object);
        }
    }

    @Override
    public void remove(Object object) throws IllegalArgumentException, NoSuchElementException, RuntimeException {
        String[] stringArray;
        if (object == null) {
            throw new IllegalArgumentException("The given object must not be null.");
        }
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, object);
        if (xServiceInfo == null) {
            throw new IllegalArgumentException("The given object does not implement the XServiceInfo interface.");
        }
        XSingleServiceFactory xSingleServiceFactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, object);
        if (xSingleServiceFactory == null) {
            throw new IllegalArgumentException("The given object does not implement the XSingleServiceFactory interface.");
        }
        if (this.factoriesByImplNames.remove(xServiceInfo.getImplementationName()) == null) {
            throw new NoSuchElementException(xServiceInfo.getImplementationName() + " is not registered as an implementation.");
        }
        for (String string : stringArray = xServiceInfo.getSupportedServiceNames()) {
            if (!this.factoriesByServiceNames.containsKey(string)) continue;
            ArrayList<Object> arrayList = this.factoriesByServiceNames.get(string);
            if (!arrayList.remove(object)) {
                System.err.println("The implementation " + xServiceInfo.getImplementationName() + " is not registered for the service " + string + " - ignoring!");
            }
            if (!arrayList.isEmpty()) continue;
            this.factoriesByServiceNames.remove(string);
        }
    }

    @Override
    public XEnumeration createEnumeration() throws RuntimeException {
        return new ServiceEnumerationImpl(this.factoriesByImplNames.values().iterator());
    }

    @Override
    public Type getElementType() throws RuntimeException {
        if (UNO_TYPE == null) {
            UNO_TYPE = new Type(ServiceManager.class);
        }
        return UNO_TYPE;
    }

    @Override
    public boolean hasElements() {
        return !this.factoriesByImplNames.isEmpty();
    }

    @Override
    public XEnumeration createContentEnumeration(String string) throws RuntimeException {
        ArrayList<Object> arrayList = this.factoriesByServiceNames.get(string);
        ServiceEnumerationImpl serviceEnumerationImpl = arrayList != null ? new ServiceEnumerationImpl(arrayList.iterator()) : new ServiceEnumerationImpl();
        return serviceEnumerationImpl;
    }

    @Override
    public String getImplementationName() throws RuntimeException {
        return this.getClass().getName();
    }

    @Override
    public boolean supportsService(String string) throws RuntimeException {
        for (String string2 : supportedServiceNames) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return this.getImplementationName().equals(string);
    }

    @Override
    public String[] getSupportedServiceNames() throws RuntimeException {
        return supportedServiceNames;
    }

    static class ServiceEnumerationImpl
    implements XEnumeration {
        Iterator<Object> enumeration = null;

        public ServiceEnumerationImpl() {
        }

        public ServiceEnumerationImpl(Enumeration<Object> enumeration) {
            this.enumeration = Collections.list(enumeration).iterator();
        }

        public ServiceEnumerationImpl(Iterator<Object> iterator) {
            this.enumeration = iterator;
        }

        @Override
        public boolean hasMoreElements() throws RuntimeException {
            return this.enumeration != null && this.enumeration.hasNext();
        }

        @Override
        public Object nextElement() throws NoSuchElementException, WrappedTargetException, RuntimeException {
            if (this.enumeration == null) {
                throw new NoSuchElementException();
            }
            try {
                return this.enumeration.next();
            }
            catch (java.util.NoSuchElementException noSuchElementException) {
                throw new NoSuchElementException(noSuchElementException, noSuchElementException.toString());
            }
        }
    }
}

