# Cloud

| Ollama's cloud is currently in preview. For full documentation, see [Ollama's documentation](https://docs.ollama.com/cloud).

## Cloud Models

[Cloud models](https://ollama.com/cloud) are a new kind of model in Ollama that can run without a powerful GPU. Instead, cloud models are automatically offloaded to Ollama's cloud while offering the same capabilities as local models, making it possible to keep using your local tools while running larger models that wouldn’t fit on a personal computer.

Ollama currently supports the following cloud models, with more coming soon:

- `gpt-oss:20b-cloud`
- `gpt-oss:120b-cloud`
- `deepseek-v3.1:671b-cloud`
- `qwen3-coder:480b-cloud`

### Get started

To run a cloud model, open the terminal and run:

```
ollama run gpt-oss:120b-cloud
```

To run cloud models with integrations that work with Ollama, first download the cloud model:

```
ollama pull qwen3-coder:480b-cloud
```

Then sign in to Ollama:

```
ollama signin
```

Finally, access the model using the model name `qwen3-coder:480b-cloud` via Ollama's local API or tooling.

## Cloud API access

Cloud models can also be accessed directly on ollama.com's API. For more information, see the [docs](https://docs.ollama.com/cloud).
