/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.internal.Monitor;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSFile;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface,
Monitor {
    private final String tnsDir;
    private long nextPollTime;
    private ArrayList<TNSFile> tnsFiles;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;
    private static final int MAX_DEPTH = 5;
    private static final Pattern regexp = Pattern.compile("^(IFILE\\s*=\\s*)(.*)", 2);
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    public TNSNamesNamingAdapter(String tnsAdmin) {
        this.tnsDir = tnsAdmin;
        this.resetAttr();
    }

    private void resetAttr() {
        this.tnsFiles = new ArrayList(3);
        this.nextPollTime = 0L;
    }

    @Override
    public String resolve(String connId) throws NetException {
        NVPair nvp = null;
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkAndReload();
            for (TNSFile tnsFile : this.tnsFiles) {
                nvp = tnsFile.getEntries().getNLPListElement(connId);
                if (nvp == null) continue;
                break;
            }
        }
        if (nvp != null) {
            return nvp.valueToString();
        }
        if (this.tnsFiles.isEmpty()) {
            throw new NetException(12263, null, false, this.tnsDir);
        }
        throw new NetException(12154, null, false, connId, this.tnsFiles.toString());
    }

    private void loadFiles() throws NetException {
        File f = new File(this.tnsDir, TNSFILE);
        String filename = f.getAbsolutePath();
        this.loadFiles(filename, 0);
    }

    private void loadFiles(String filename, int depth) throws NetException {
        if (depth >= 5) {
            return;
        }
        File f = new File(filename);
        if (!f.isFile() || !f.canRead()) {
            return;
        }
        try {
            NLParamParser tnsEntriesHdl = new NLParamParser(filename, 1);
            this.tnsFiles.add(new TNSFile(filename, f.lastModified(), tnsEntriesHdl));
            NVPair nvpIFile = tnsEntriesHdl.getNLPListElement("ifile");
            if (nvpIFile != null) {
                ArrayList<String> iFiles = this.getIFile(filename);
                for (String iFile : iFiles) {
                    this.loadFiles(iFile, depth + 1);
                }
            }
        }
        catch (IOException ioex) {
            return;
        }
        catch (NLException nLException) {
            // empty catch block
        }
    }

    private ArrayList<String> getIFile(String filename) throws IOException {
        FileReader fr = new FileReader(filename);
        BufferedReader br = new BufferedReader(fr);
        Matcher pmatch = regexp.matcher("");
        ArrayList<String> iFiles = new ArrayList<String>(2);
        String currentLine = null;
        while ((currentLine = br.readLine()) != null) {
            pmatch.reset(currentLine);
            if (!pmatch.find()) continue;
            String iFile = pmatch.group(2);
            File f = new File(iFile = iFile.trim());
            if (!f.isAbsolute()) {
                f = new File(this.tnsDir, iFile);
                iFile = f.getAbsolutePath();
            }
            iFiles.add(iFile);
        }
        return iFiles;
    }

    private void checkAndReload() throws NetException {
        long currTime = System.currentTimeMillis();
        if (currTime > this.nextPollTime) {
            this.nextPollTime = 0L;
            this.reloadFiles();
        }
    }

    private void reloadFiles() throws NetException {
        if (this.tnsFiles.isEmpty()) {
            this.loadFiles();
        } else {
            for (TNSFile tnsFile : this.tnsFiles) {
                long modifiedTime = tnsFile.getLastModifiedTime();
                String fileName = tnsFile.getFileName();
                File f = new File(fileName);
                boolean isFileChanged = !f.isFile() || !f.canRead() || f.lastModified() != modifiedTime;
                if (!isFileChanged) continue;
                this.resetAttr();
                this.loadFiles();
                break;
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

