/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.DeleteWorkflowRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/opensearch/alerting/resthandler/RestDeleteWorkflowAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestDeleteWorkflowAction
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());

    @NotNull
    public String getName() {
        return "delete_workflow_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.DELETE, AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}"));
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.log.debug(request.method() + " " + AlertingPlugin.WORKFLOW_BASE_URI + "/{workflowID}");
        String workflowId = request.param("workflowID");
        boolean deleteDelegateMonitors = request.paramAsBoolean("deleteDelegateMonitors", false);
        this.log.debug(request.method() + " " + request.uri());
        WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.parse((String)request.param("refresh", WriteRequest.RefreshPolicy.IMMEDIATE.getValue()));
        Intrinsics.checkNotNull((Object)workflowId);
        DeleteWorkflowRequest deleteWorkflowRequest = new DeleteWorkflowRequest(workflowId, Boolean.valueOf(deleteDelegateMonitors));
        return arg_0 -> RestDeleteWorkflowAction.prepareRequest$lambda$0(client, deleteWorkflowRequest, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, DeleteWorkflowRequest $deleteWorkflowRequest, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$deleteWorkflowRequest, (String)"$deleteWorkflowRequest");
        $client.execute(AlertingActions.DELETE_WORKFLOW_ACTION_TYPE, (ActionRequest)$deleteWorkflowRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

