/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ppl.domain;

import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.json.JSONObject;
import org.opensearch.sql.ast.statement.ExplainMode;
import org.opensearch.sql.protocol.response.format.Format;
import org.opensearch.sql.protocol.response.format.JsonResponseFormatter;

public class PPLQueryRequest {
    private static final String DEFAULT_PPL_PATH = "/_plugins/_ppl";
    public static final PPLQueryRequest NULL = new PPLQueryRequest("", null, "/_plugins/_ppl", "");
    private final String pplQuery;
    private final JSONObject jsonContent;
    private final String path;
    private String format = "";
    private String explainMode;
    private boolean sanitize = true;
    private JsonResponseFormatter.Style style = JsonResponseFormatter.Style.COMPACT;
    private boolean profile = false;

    public PPLQueryRequest(String pplQuery, JSONObject jsonContent, String path) {
        this(pplQuery, jsonContent, path, "");
    }

    public PPLQueryRequest(String pplQuery, JSONObject jsonContent, String path, String format) {
        this(pplQuery, jsonContent, path, format, ExplainMode.STANDARD.getModeName(), false);
    }

    public PPLQueryRequest(String pplQuery, JSONObject jsonContent, String path, String format, String explainMode, boolean profile) {
        this.pplQuery = pplQuery;
        this.jsonContent = jsonContent;
        this.path = Optional.ofNullable(path).orElse(DEFAULT_PPL_PATH);
        this.format = format;
        this.explainMode = explainMode;
        this.profile = profile;
    }

    public String getRequest() {
        return this.pplQuery;
    }

    public boolean isExplainRequest() {
        return this.path.endsWith("/_explain");
    }

    public Format format() {
        Optional optionalFormat = Format.of((String)this.format);
        if (optionalFormat.isPresent()) {
            return (Format)optionalFormat.get();
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "response in %s format is not supported.", this.format));
    }

    public ExplainMode mode() {
        return ExplainMode.of((String)this.explainMode);
    }

    @Generated
    public JSONObject getJsonContent() {
        return this.jsonContent;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public String getExplainMode() {
        return this.explainMode;
    }

    @Generated
    public PPLQueryRequest sanitize(boolean sanitize) {
        this.sanitize = sanitize;
        return this;
    }

    @Generated
    public boolean sanitize() {
        return this.sanitize;
    }

    @Generated
    public PPLQueryRequest style(JsonResponseFormatter.Style style) {
        this.style = style;
        return this;
    }

    @Generated
    public JsonResponseFormatter.Style style() {
        return this.style;
    }

    @Generated
    public PPLQueryRequest profile(boolean profile) {
        this.profile = profile;
        return this;
    }

    @Generated
    public boolean profile() {
        return this.profile;
    }
}

