/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertService;
import org.opensearch.alerting.InputService;
import org.opensearch.alerting.MonitorMetadataService;
import org.opensearch.alerting.MonitorRunnerService;
import org.opensearch.alerting.TriggerService;
import org.opensearch.alerting.WorkflowMetadataService;
import org.opensearch.alerting.WorkflowService;
import org.opensearch.alerting.action.ExecuteMonitorAction;
import org.opensearch.alerting.action.ExecuteWorkflowAction;
import org.opensearch.alerting.action.GetDestinationsAction;
import org.opensearch.alerting.action.GetEmailAccountAction;
import org.opensearch.alerting.action.GetEmailGroupAction;
import org.opensearch.alerting.action.GetRemoteIndexesAction;
import org.opensearch.alerting.action.SearchEmailAccountAction;
import org.opensearch.alerting.action.SearchEmailGroupAction;
import org.opensearch.alerting.actionv2.DeleteMonitorV2Action;
import org.opensearch.alerting.actionv2.ExecuteMonitorV2Action;
import org.opensearch.alerting.actionv2.GetAlertsV2Action;
import org.opensearch.alerting.actionv2.GetMonitorV2Action;
import org.opensearch.alerting.actionv2.IndexMonitorV2Action;
import org.opensearch.alerting.actionv2.SearchMonitorV2Action;
import org.opensearch.alerting.alerts.AlertIndices;
import org.opensearch.alerting.alertsv2.AlertV2Indices;
import org.opensearch.alerting.alertsv2.AlertV2Mover;
import org.opensearch.alerting.comments.CommentsIndices;
import org.opensearch.alerting.core.JobRunner;
import org.opensearch.alerting.core.JobSweeper;
import org.opensearch.alerting.core.ScheduledJobIndices;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsAction;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsTransportAction;
import org.opensearch.alerting.core.lock.LockService;
import org.opensearch.alerting.core.resthandler.RestScheduledJobStatsHandler;
import org.opensearch.alerting.core.schedule.JobScheduler;
import org.opensearch.alerting.core.settings.AlertingV2Settings;
import org.opensearch.alerting.core.settings.LegacyOpenDistroScheduledJobSettings;
import org.opensearch.alerting.core.settings.ScheduledJobSettings;
import org.opensearch.alerting.modelv2.MonitorV2;
import org.opensearch.alerting.remote.monitors.RemoteMonitorRegistry;
import org.opensearch.alerting.resthandler.RestAcknowledgeAlertAction;
import org.opensearch.alerting.resthandler.RestAcknowledgeChainedAlertAction;
import org.opensearch.alerting.resthandler.RestDeleteAlertingCommentAction;
import org.opensearch.alerting.resthandler.RestDeleteMonitorAction;
import org.opensearch.alerting.resthandler.RestDeleteWorkflowAction;
import org.opensearch.alerting.resthandler.RestExecuteMonitorAction;
import org.opensearch.alerting.resthandler.RestExecuteWorkflowAction;
import org.opensearch.alerting.resthandler.RestGetAlertsAction;
import org.opensearch.alerting.resthandler.RestGetDestinationsAction;
import org.opensearch.alerting.resthandler.RestGetEmailAccountAction;
import org.opensearch.alerting.resthandler.RestGetEmailGroupAction;
import org.opensearch.alerting.resthandler.RestGetFindingsAction;
import org.opensearch.alerting.resthandler.RestGetMonitorAction;
import org.opensearch.alerting.resthandler.RestGetRemoteIndexesAction;
import org.opensearch.alerting.resthandler.RestGetWorkflowAction;
import org.opensearch.alerting.resthandler.RestGetWorkflowAlertsAction;
import org.opensearch.alerting.resthandler.RestIndexAlertingCommentAction;
import org.opensearch.alerting.resthandler.RestIndexMonitorAction;
import org.opensearch.alerting.resthandler.RestIndexWorkflowAction;
import org.opensearch.alerting.resthandler.RestSearchAlertingCommentAction;
import org.opensearch.alerting.resthandler.RestSearchEmailAccountAction;
import org.opensearch.alerting.resthandler.RestSearchEmailGroupAction;
import org.opensearch.alerting.resthandler.RestSearchMonitorAction;
import org.opensearch.alerting.resthandlerv2.RestDeleteMonitorV2Action;
import org.opensearch.alerting.resthandlerv2.RestExecuteMonitorV2Action;
import org.opensearch.alerting.resthandlerv2.RestGetAlertsV2Action;
import org.opensearch.alerting.resthandlerv2.RestGetMonitorV2Action;
import org.opensearch.alerting.resthandlerv2.RestIndexMonitorV2Action;
import org.opensearch.alerting.resthandlerv2.RestSearchMonitorV2Action;
import org.opensearch.alerting.script.TriggerScript;
import org.opensearch.alerting.service.DeleteMonitorService;
import org.opensearch.alerting.settings.AlertingSettings;
import org.opensearch.alerting.settings.DestinationSettings;
import org.opensearch.alerting.settings.LegacyOpenDistroAlertingSettings;
import org.opensearch.alerting.settings.LegacyOpenDistroDestinationSettings;
import org.opensearch.alerting.spi.RemoteMonitorRunner;
import org.opensearch.alerting.spi.RemoteMonitorRunnerExtension;
import org.opensearch.alerting.transport.TransportAcknowledgeAlertAction;
import org.opensearch.alerting.transport.TransportAcknowledgeChainedAlertAction;
import org.opensearch.alerting.transport.TransportDeleteAlertingCommentAction;
import org.opensearch.alerting.transport.TransportDeleteMonitorAction;
import org.opensearch.alerting.transport.TransportDeleteWorkflowAction;
import org.opensearch.alerting.transport.TransportDocLevelMonitorFanOutAction;
import org.opensearch.alerting.transport.TransportExecuteMonitorAction;
import org.opensearch.alerting.transport.TransportExecuteWorkflowAction;
import org.opensearch.alerting.transport.TransportGetAlertsAction;
import org.opensearch.alerting.transport.TransportGetDestinationsAction;
import org.opensearch.alerting.transport.TransportGetEmailAccountAction;
import org.opensearch.alerting.transport.TransportGetEmailGroupAction;
import org.opensearch.alerting.transport.TransportGetFindingsSearchAction;
import org.opensearch.alerting.transport.TransportGetMonitorAction;
import org.opensearch.alerting.transport.TransportGetRemoteIndexesAction;
import org.opensearch.alerting.transport.TransportGetWorkflowAction;
import org.opensearch.alerting.transport.TransportGetWorkflowAlertsAction;
import org.opensearch.alerting.transport.TransportIndexAlertingCommentAction;
import org.opensearch.alerting.transport.TransportIndexMonitorAction;
import org.opensearch.alerting.transport.TransportIndexWorkflowAction;
import org.opensearch.alerting.transport.TransportSearchAlertingCommentAction;
import org.opensearch.alerting.transport.TransportSearchEmailAccountAction;
import org.opensearch.alerting.transport.TransportSearchEmailGroupAction;
import org.opensearch.alerting.transport.TransportSearchMonitorAction;
import org.opensearch.alerting.transportv2.TransportDeleteMonitorV2Action;
import org.opensearch.alerting.transportv2.TransportExecuteMonitorV2Action;
import org.opensearch.alerting.transportv2.TransportGetAlertsV2Action;
import org.opensearch.alerting.transportv2.TransportGetMonitorV2Action;
import org.opensearch.alerting.transportv2.TransportIndexMonitorV2Action;
import org.opensearch.alerting.transportv2.TransportSearchMonitorV2Action;
import org.opensearch.alerting.util.DocLevelMonitorQueries;
import org.opensearch.alerting.util.destinationmigration.DestinationMigrationCoordinator;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.DocLevelMonitorFanOutAction;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorExtAggregationBuilder;
import org.opensearch.commons.alerting.aggregation.bucketselectorext.BucketSelectorIndices;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.ChainedAlertTrigger;
import org.opensearch.commons.alerting.model.ClusterMetricsInput;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Workflow;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteMonitorTrigger;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.monitor.jvm.JvmStats;
import org.opensearch.painless.spi.Allowlist;
import org.opensearch.painless.spi.AllowlistLoader;
import org.opensearch.painless.spi.PainlessExtension;
import org.opensearch.percolator.PercolatorPluginExt;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptService;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.AdminClient;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0098\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u00062\u00020\u0007:\u0002\u0098\u0001B\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bH\u0016JN\u0010_\u001a\b\u0012\u0004\u0012\u00020`0\r2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020j2\b\u0010k\u001a\u0004\u0018\u00010l2\f\u0010m\u001a\b\u0012\u0004\u0012\u00020o0nH\u0016J\u001e\u0010p\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020r\u0012\u0006\b\u0001\u0012\u00020s0q0\rH\u0016J\u000e\u0010t\u001a\b\u0012\u0004\u0012\u00020u0\rH\u0016Ju\u0010v\u001a\b\u0012\u0004\u0012\u00020x0w2\u0006\u0010y\u001a\u00020z2\u0006\u0010E\u001a\u00020F2\u0006\u00103\u001a\u0002042\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020~2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\b\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010k\u001a\u00020l2\u000e\u0010\u0087\u0001\u001a\t\u0012\u0005\u0012\u00030\u0088\u00010nH\u0016J\u0014\u0010\u0089\u0001\u001a\r\u0012\t\u0012\u0007\u0012\u0002\b\u00030\u008a\u00010\rH\u0016J\u0014\u0010\u008b\u0001\u001a\u00030\u008c\u00012\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0016J\u0013\u0010\u008f\u0001\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\rH\u0016J\u0018\u0010\u0090\u0001\u001a\t\u0012\u0005\u0012\u00030\u0091\u00010w2\u0006\u0010a\u001a\u00020bH\u0016J\u0012\u0010\u0092\u0001\u001a\u00030\u008c\u00012\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010\u0093\u0001\u001a\t\u0012\u0005\u0012\u00030\u0094\u00010\rH\u0016J\u0014\u0010\u0095\u0001\u001a\u00030\u008c\u00012\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0016R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020:X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001a\u0010?\u001a\u00020@X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020FX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020LX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020RX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR&\u0010W\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020Z0XX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\\\"\u0004\b]\u0010^\u00a8\u0006\u0099\u0001"}, d2={"Lorg/opensearch/alerting/AlertingPlugin;", "Lorg/opensearch/painless/spi/PainlessExtension;", "Lorg/opensearch/plugins/ActionPlugin;", "Lorg/opensearch/plugins/ScriptPlugin;", "Lorg/opensearch/plugins/ReloadablePlugin;", "Lorg/opensearch/plugins/SearchPlugin;", "Lorg/opensearch/plugins/SystemIndexPlugin;", "Lorg/opensearch/percolator/PercolatorPluginExt;", "<init>", "()V", "getContextAllowlists", "", "Lorg/opensearch/script/ScriptContext;", "", "Lorg/opensearch/painless/spi/Allowlist;", "runner", "Lorg/opensearch/alerting/MonitorRunnerService;", "getRunner", "()Lorg/opensearch/alerting/MonitorRunnerService;", "setRunner", "(Lorg/opensearch/alerting/MonitorRunnerService;)V", "scheduler", "Lorg/opensearch/alerting/core/schedule/JobScheduler;", "getScheduler", "()Lorg/opensearch/alerting/core/schedule/JobScheduler;", "setScheduler", "(Lorg/opensearch/alerting/core/schedule/JobScheduler;)V", "sweeper", "Lorg/opensearch/alerting/core/JobSweeper;", "getSweeper", "()Lorg/opensearch/alerting/core/JobSweeper;", "setSweeper", "(Lorg/opensearch/alerting/core/JobSweeper;)V", "scheduledJobIndices", "Lorg/opensearch/alerting/core/ScheduledJobIndices;", "getScheduledJobIndices", "()Lorg/opensearch/alerting/core/ScheduledJobIndices;", "setScheduledJobIndices", "(Lorg/opensearch/alerting/core/ScheduledJobIndices;)V", "commentsIndices", "Lorg/opensearch/alerting/comments/CommentsIndices;", "getCommentsIndices", "()Lorg/opensearch/alerting/comments/CommentsIndices;", "setCommentsIndices", "(Lorg/opensearch/alerting/comments/CommentsIndices;)V", "docLevelMonitorQueries", "Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "getDocLevelMonitorQueries", "()Lorg/opensearch/alerting/util/DocLevelMonitorQueries;", "setDocLevelMonitorQueries", "(Lorg/opensearch/alerting/util/DocLevelMonitorQueries;)V", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "getThreadPool", "()Lorg/opensearch/threadpool/ThreadPool;", "setThreadPool", "(Lorg/opensearch/threadpool/ThreadPool;)V", "alertIndices", "Lorg/opensearch/alerting/alerts/AlertIndices;", "getAlertIndices", "()Lorg/opensearch/alerting/alerts/AlertIndices;", "setAlertIndices", "(Lorg/opensearch/alerting/alerts/AlertIndices;)V", "alertV2Indices", "Lorg/opensearch/alerting/alertsv2/AlertV2Indices;", "getAlertV2Indices", "()Lorg/opensearch/alerting/alertsv2/AlertV2Indices;", "setAlertV2Indices", "(Lorg/opensearch/alerting/alertsv2/AlertV2Indices;)V", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "setClusterService", "(Lorg/opensearch/cluster/service/ClusterService;)V", "destinationMigrationCoordinator", "Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;", "getDestinationMigrationCoordinator", "()Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;", "setDestinationMigrationCoordinator", "(Lorg/opensearch/alerting/util/destinationmigration/DestinationMigrationCoordinator;)V", "alertV2Mover", "Lorg/opensearch/alerting/alertsv2/AlertV2Mover;", "getAlertV2Mover", "()Lorg/opensearch/alerting/alertsv2/AlertV2Mover;", "setAlertV2Mover", "(Lorg/opensearch/alerting/alertsv2/AlertV2Mover;)V", "monitorTypeToMonitorRunners", "", "", "Lorg/opensearch/alerting/remote/monitors/RemoteMonitorRegistry;", "getMonitorTypeToMonitorRunners", "()Ljava/util/Map;", "setMonitorTypeToMonitorRunners", "(Ljava/util/Map;)V", "getRestHandlers", "Lorg/opensearch/rest/RestHandler;", "settings", "Lorg/opensearch/common/settings/Settings;", "restController", "Lorg/opensearch/rest/RestController;", "clusterSettings", "Lorg/opensearch/common/settings/ClusterSettings;", "indexScopedSettings", "Lorg/opensearch/common/settings/IndexScopedSettings;", "settingsFilter", "Lorg/opensearch/common/settings/SettingsFilter;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "nodesInCluster", "Ljava/util/function/Supplier;", "Lorg/opensearch/cluster/node/DiscoveryNodes;", "getActions", "Lorg/opensearch/plugins/ActionPlugin$ActionHandler;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/action/ActionResponse;", "getNamedXContent", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "createComponents", "", "", "client", "Lorg/opensearch/transport/client/Client;", "resourceWatcherService", "Lorg/opensearch/watcher/ResourceWatcherService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "environment", "Lorg/opensearch/env/Environment;", "nodeEnvironment", "Lorg/opensearch/env/NodeEnvironment;", "namedWriteableRegistry", "Lorg/opensearch/core/common/io/stream/NamedWriteableRegistry;", "repositoriesServiceSupplier", "Lorg/opensearch/repositories/RepositoriesService;", "getSettings", "Lorg/opensearch/common/settings/Setting;", "onIndexModule", "", "indexModule", "Lorg/opensearch/index/IndexModule;", "getContexts", "getSystemIndexDescriptors", "Lorg/opensearch/indices/SystemIndexDescriptor;", "reload", "getPipelineAggregations", "Lorg/opensearch/plugins/SearchPlugin$PipelineAggregationSpec;", "loadExtensions", "loader", "Lorg/opensearch/plugins/ExtensiblePlugin$ExtensionLoader;", "Companion", "opensearch-alerting"})
public final class AlertingPlugin
extends PercolatorPluginExt
implements PainlessExtension,
ActionPlugin,
ScriptPlugin,
ReloadablePlugin,
SearchPlugin,
SystemIndexPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public MonitorRunnerService runner;
    public JobScheduler scheduler;
    public JobSweeper sweeper;
    public ScheduledJobIndices scheduledJobIndices;
    public CommentsIndices commentsIndices;
    public DocLevelMonitorQueries docLevelMonitorQueries;
    public ThreadPool threadPool;
    public AlertIndices alertIndices;
    public AlertV2Indices alertV2Indices;
    public ClusterService clusterService;
    public DestinationMigrationCoordinator destinationMigrationCoordinator;
    public AlertV2Mover alertV2Mover;
    @NotNull
    private Map<String, RemoteMonitorRegistry> monitorTypeToMonitorRunners = new LinkedHashMap();
    @JvmField
    @NotNull
    public static final String OPEN_SEARCH_DASHBOARDS_USER_AGENT = "OpenSearch-Dashboards";
    @JvmField
    @NotNull
    public static final String[] UI_METADATA_EXCLUDE;
    @JvmField
    @NotNull
    public static final String MONITOR_BASE_URI;
    @JvmField
    @NotNull
    public static final String MONITOR_V2_BASE_URI;
    @JvmField
    @NotNull
    public static final String WORKFLOW_BASE_URI;
    @JvmField
    @NotNull
    public static final String REMOTE_BASE_URI;
    @JvmField
    @NotNull
    public static final String DESTINATION_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_MONITOR_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_DESTINATION_BASE_URI;
    @JvmField
    @NotNull
    public static final String EMAIL_ACCOUNT_BASE_URI;
    @JvmField
    @NotNull
    public static final String EMAIL_GROUP_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_EMAIL_ACCOUNT_BASE_URI;
    @JvmField
    @NotNull
    public static final String LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI;
    @JvmField
    @NotNull
    public static final String FINDING_BASE_URI;
    @JvmField
    @NotNull
    public static final String COMMENTS_BASE_URI;
    @JvmField
    @NotNull
    public static final List<String> ALERTING_JOB_TYPES;

    @NotNull
    public Map<ScriptContext<?>, List<Allowlist>> getContextAllowlists() {
        String[] stringArray = new String[]{"org.opensearch.alerting.txt"};
        Allowlist whitelist = AllowlistLoader.loadFromResourceFiles(((Object)((Object)this)).getClass(), (String[])stringArray);
        return MapsKt.mapOf((Pair)TuplesKt.to(TriggerScript.Companion.getCONTEXT(), (Object)CollectionsKt.listOf((Object)whitelist)));
    }

    @NotNull
    public final MonitorRunnerService getRunner() {
        MonitorRunnerService monitorRunnerService = this.runner;
        if (monitorRunnerService != null) {
            return monitorRunnerService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"runner");
        return null;
    }

    public final void setRunner(@NotNull MonitorRunnerService monitorRunnerService) {
        Intrinsics.checkNotNullParameter((Object)((Object)monitorRunnerService), (String)"<set-?>");
        this.runner = monitorRunnerService;
    }

    @NotNull
    public final JobScheduler getScheduler() {
        JobScheduler jobScheduler = this.scheduler;
        if (jobScheduler != null) {
            return jobScheduler;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scheduler");
        return null;
    }

    public final void setScheduler(@NotNull JobScheduler jobScheduler) {
        Intrinsics.checkNotNullParameter((Object)jobScheduler, (String)"<set-?>");
        this.scheduler = jobScheduler;
    }

    @NotNull
    public final JobSweeper getSweeper() {
        JobSweeper jobSweeper = this.sweeper;
        if (jobSweeper != null) {
            return jobSweeper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sweeper");
        return null;
    }

    public final void setSweeper(@NotNull JobSweeper jobSweeper) {
        Intrinsics.checkNotNullParameter((Object)jobSweeper, (String)"<set-?>");
        this.sweeper = jobSweeper;
    }

    @NotNull
    public final ScheduledJobIndices getScheduledJobIndices() {
        ScheduledJobIndices scheduledJobIndices = this.scheduledJobIndices;
        if (scheduledJobIndices != null) {
            return scheduledJobIndices;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"scheduledJobIndices");
        return null;
    }

    public final void setScheduledJobIndices(@NotNull ScheduledJobIndices scheduledJobIndices) {
        Intrinsics.checkNotNullParameter((Object)scheduledJobIndices, (String)"<set-?>");
        this.scheduledJobIndices = scheduledJobIndices;
    }

    @NotNull
    public final CommentsIndices getCommentsIndices() {
        CommentsIndices commentsIndices = this.commentsIndices;
        if (commentsIndices != null) {
            return commentsIndices;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commentsIndices");
        return null;
    }

    public final void setCommentsIndices(@NotNull CommentsIndices commentsIndices) {
        Intrinsics.checkNotNullParameter((Object)commentsIndices, (String)"<set-?>");
        this.commentsIndices = commentsIndices;
    }

    @NotNull
    public final DocLevelMonitorQueries getDocLevelMonitorQueries() {
        DocLevelMonitorQueries docLevelMonitorQueries = this.docLevelMonitorQueries;
        if (docLevelMonitorQueries != null) {
            return docLevelMonitorQueries;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"docLevelMonitorQueries");
        return null;
    }

    public final void setDocLevelMonitorQueries(@NotNull DocLevelMonitorQueries docLevelMonitorQueries) {
        Intrinsics.checkNotNullParameter((Object)docLevelMonitorQueries, (String)"<set-?>");
        this.docLevelMonitorQueries = docLevelMonitorQueries;
    }

    @NotNull
    public final ThreadPool getThreadPool() {
        ThreadPool threadPool = this.threadPool;
        if (threadPool != null) {
            return threadPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
        return null;
    }

    public final void setThreadPool(@NotNull ThreadPool threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"<set-?>");
        this.threadPool = threadPool;
    }

    @NotNull
    public final AlertIndices getAlertIndices() {
        AlertIndices alertIndices = this.alertIndices;
        if (alertIndices != null) {
            return alertIndices;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"alertIndices");
        return null;
    }

    public final void setAlertIndices(@NotNull AlertIndices alertIndices) {
        Intrinsics.checkNotNullParameter((Object)alertIndices, (String)"<set-?>");
        this.alertIndices = alertIndices;
    }

    @NotNull
    public final AlertV2Indices getAlertV2Indices() {
        AlertV2Indices alertV2Indices = this.alertV2Indices;
        if (alertV2Indices != null) {
            return alertV2Indices;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"alertV2Indices");
        return null;
    }

    public final void setAlertV2Indices(@NotNull AlertV2Indices alertV2Indices) {
        Intrinsics.checkNotNullParameter((Object)alertV2Indices, (String)"<set-?>");
        this.alertV2Indices = alertV2Indices;
    }

    @NotNull
    public final ClusterService getClusterService() {
        ClusterService clusterService = this.clusterService;
        if (clusterService != null) {
            return clusterService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
        return null;
    }

    public final void setClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"<set-?>");
        this.clusterService = clusterService;
    }

    @NotNull
    public final DestinationMigrationCoordinator getDestinationMigrationCoordinator() {
        DestinationMigrationCoordinator destinationMigrationCoordinator = this.destinationMigrationCoordinator;
        if (destinationMigrationCoordinator != null) {
            return destinationMigrationCoordinator;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"destinationMigrationCoordinator");
        return null;
    }

    public final void setDestinationMigrationCoordinator(@NotNull DestinationMigrationCoordinator destinationMigrationCoordinator) {
        Intrinsics.checkNotNullParameter((Object)((Object)destinationMigrationCoordinator), (String)"<set-?>");
        this.destinationMigrationCoordinator = destinationMigrationCoordinator;
    }

    @NotNull
    public final AlertV2Mover getAlertV2Mover() {
        AlertV2Mover alertV2Mover = this.alertV2Mover;
        if (alertV2Mover != null) {
            return alertV2Mover;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"alertV2Mover");
        return null;
    }

    public final void setAlertV2Mover(@NotNull AlertV2Mover alertV2Mover) {
        Intrinsics.checkNotNullParameter((Object)alertV2Mover, (String)"<set-?>");
        this.alertV2Mover = alertV2Mover;
    }

    @NotNull
    public final Map<String, RemoteMonitorRegistry> getMonitorTypeToMonitorRunners() {
        return this.monitorTypeToMonitorRunners;
    }

    public final void setMonitorTypeToMonitorRunners(@NotNull Map<String, RemoteMonitorRegistry> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.monitorTypeToMonitorRunners = map;
    }

    @NotNull
    public List<RestHandler> getRestHandlers(@NotNull Settings settings, @NotNull RestController restController, @NotNull ClusterSettings clusterSettings, @NotNull IndexScopedSettings indexScopedSettings, @NotNull SettingsFilter settingsFilter, @Nullable IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<DiscoveryNodes> nodesInCluster) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)restController, (String)"restController");
        Intrinsics.checkNotNullParameter((Object)clusterSettings, (String)"clusterSettings");
        Intrinsics.checkNotNullParameter((Object)indexScopedSettings, (String)"indexScopedSettings");
        Intrinsics.checkNotNullParameter((Object)settingsFilter, (String)"settingsFilter");
        Intrinsics.checkNotNullParameter(nodesInCluster, (String)"nodesInCluster");
        Object[] objectArray = new BaseRestHandler[]{new RestGetMonitorAction(), new RestDeleteMonitorAction(), new RestIndexMonitorAction(), new RestIndexWorkflowAction(), new RestSearchMonitorAction(settings, this.getClusterService()), new RestExecuteMonitorAction(), new RestExecuteWorkflowAction(), new RestAcknowledgeAlertAction(), new RestAcknowledgeChainedAlertAction(), new RestScheduledJobStatsHandler("_alerting"), new RestSearchEmailAccountAction(), new RestGetEmailAccountAction(), new RestSearchEmailGroupAction(), new RestGetEmailGroupAction(), new RestGetDestinationsAction(), new RestGetAlertsAction(), new RestGetWorkflowAlertsAction(), new RestGetFindingsAction(), new RestGetWorkflowAction(), new RestDeleteWorkflowAction(), new RestGetRemoteIndexesAction(), new RestIndexAlertingCommentAction(), new RestSearchAlertingCommentAction(), new RestDeleteAlertingCommentAction(), new RestIndexMonitorV2Action(), new RestExecuteMonitorV2Action(), new RestDeleteMonitorV2Action(), new RestGetMonitorV2Action(), new RestSearchMonitorV2Action(settings, this.getClusterService()), new RestGetAlertsV2Action()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        Object[] objectArray = new ActionPlugin.ActionHandler[]{new ActionPlugin.ActionHandler((ActionType)ScheduledJobsStatsAction.Companion.getINSTANCE(), ScheduledJobsStatsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.INDEX_MONITOR_ACTION_TYPE, TransportIndexMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_MONITOR_ACTION_TYPE, TransportGetMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteMonitorAction.Companion.getINSTANCE(), TransportExecuteMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.SEARCH_MONITORS_ACTION_TYPE, TransportSearchMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.DELETE_MONITOR_ACTION_TYPE, TransportDeleteMonitorAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.ACKNOWLEDGE_ALERTS_ACTION_TYPE, TransportAcknowledgeAlertAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.ACKNOWLEDGE_CHAINED_ALERTS_ACTION_TYPE, TransportAcknowledgeChainedAlertAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetEmailAccountAction.Companion.getINSTANCE(), TransportGetEmailAccountAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchEmailAccountAction.Companion.getINSTANCE(), TransportSearchEmailAccountAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetEmailGroupAction.Companion.getINSTANCE(), TransportGetEmailGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchEmailGroupAction.Companion.getINSTANCE(), TransportSearchEmailGroupAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetDestinationsAction.Companion.getINSTANCE(), TransportGetDestinationsAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_ALERTS_ACTION_TYPE, TransportGetAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_WORKFLOW_ALERTS_ACTION_TYPE, TransportGetWorkflowAlertsAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_FINDINGS_ACTION_TYPE, TransportGetFindingsSearchAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.INDEX_WORKFLOW_ACTION_TYPE, TransportIndexWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.GET_WORKFLOW_ACTION_TYPE, TransportGetWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.DELETE_WORKFLOW_ACTION_TYPE, TransportDeleteWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.INDEX_COMMENT_ACTION_TYPE, TransportIndexAlertingCommentAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.SEARCH_COMMENTS_ACTION_TYPE, TransportSearchAlertingCommentAction.class, new Class[0]), new ActionPlugin.ActionHandler(AlertingActions.DELETE_COMMENT_ACTION_TYPE, TransportDeleteAlertingCommentAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteWorkflowAction.Companion.getINSTANCE(), TransportExecuteWorkflowAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetRemoteIndexesAction.Companion.getINSTANCE(), TransportGetRemoteIndexesAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DocLevelMonitorFanOutAction.Companion.getINSTANCE(), TransportDocLevelMonitorFanOutAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexMonitorV2Action.Companion.getINSTANCE(), TransportIndexMonitorV2Action.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetMonitorV2Action.Companion.getINSTANCE(), TransportGetMonitorV2Action.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchMonitorV2Action.Companion.getINSTANCE(), TransportSearchMonitorV2Action.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteMonitorV2Action.Companion.getINSTANCE(), TransportDeleteMonitorV2Action.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ExecuteMonitorV2Action.Companion.getINSTANCE(), TransportExecuteMonitorV2Action.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAlertsV2Action.Companion.getINSTANCE(), TransportGetAlertsV2Action.class, new Class[0])};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        Object[] objectArray = new NamedXContentRegistry.Entry[]{Monitor.Companion.getXCONTENT_REGISTRY(), MonitorV2.Companion.getXCONTENT_REGISTRY(), SearchInput.Companion.getXCONTENT_REGISTRY(), DocLevelMonitorInput.Companion.getXCONTENT_REGISTRY(), QueryLevelTrigger.Companion.getXCONTENT_REGISTRY(), BucketLevelTrigger.Companion.getXCONTENT_REGISTRY(), ClusterMetricsInput.Companion.getXCONTENT_REGISTRY(), DocumentLevelTrigger.Companion.getXCONTENT_REGISTRY(), ChainedAlertTrigger.Companion.getXCONTENT_REGISTRY(), RemoteMonitorTrigger.Companion.getXCONTENT_REGISTRY(), Workflow.Companion.getXCONTENT_REGISTRY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Collection<Object> createComponents(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull ResourceWatcherService resourceWatcherService, @NotNull ScriptService scriptService, @NotNull NamedXContentRegistry xContentRegistry, @NotNull Environment environment, @NotNull NodeEnvironment nodeEnvironment, @NotNull NamedWriteableRegistry namedWriteableRegistry, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull Supplier<RepositoriesService> repositoriesServiceSupplier) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)resourceWatcherService, (String)"resourceWatcherService");
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)nodeEnvironment, (String)"nodeEnvironment");
        Intrinsics.checkNotNullParameter((Object)namedWriteableRegistry, (String)"namedWriteableRegistry");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter(repositoriesServiceSupplier, (String)"repositoriesServiceSupplier");
        Settings settings = environment.settings();
        LockService lockService = new LockService(client, clusterService);
        Intrinsics.checkNotNull((Object)settings);
        this.setAlertIndices(new AlertIndices(settings, client, threadPool, clusterService));
        this.setAlertV2Indices(new AlertV2Indices(settings, client, threadPool, clusterService));
        AlertService alertService = new AlertService(client, xContentRegistry, this.getAlertIndices());
        TriggerService triggerService = new TriggerService(scriptService);
        MonitorRunnerService monitorRunnerService = MonitorRunnerService.INSTANCE.registerClusterService(clusterService).registerClient(client).registerNamedXContentRegistry(xContentRegistry).registerindexNameExpressionResolver(indexNameExpressionResolver).registerScriptService(scriptService).registerSettings(settings).registerThreadPool(threadPool).registerAlertIndices(this.getAlertIndices()).registerAlertV2Indices(this.getAlertV2Indices()).registerInputService(new InputService(client, scriptService, namedWriteableRegistry, xContentRegistry, clusterService, settings, indexNameExpressionResolver)).registerTriggerService(triggerService).registerAlertService(alertService).registerDocLevelMonitorQueries(new DocLevelMonitorQueries(client, clusterService));
        JvmStats jvmStats = JvmStats.jvmStats();
        Intrinsics.checkNotNullExpressionValue((Object)jvmStats, (String)"jvmStats(...)");
        this.setRunner(monitorRunnerService.registerJvmStats(jvmStats).registerWorkflowService(new WorkflowService(client, xContentRegistry)).registerLockService(lockService).registerConsumers().registerDestinationSettings().registerRemoteMonitors(this.monitorTypeToMonitorRunners));
        AdminClient adminClient = client.admin();
        Intrinsics.checkNotNullExpressionValue((Object)adminClient, (String)"admin(...)");
        this.setScheduledJobIndices(new ScheduledJobIndices(adminClient, clusterService));
        Settings settings2 = environment.settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings2, (String)"settings(...)");
        this.setCommentsIndices(new CommentsIndices(settings2, client, threadPool, clusterService));
        this.setDocLevelMonitorQueries(new DocLevelMonitorQueries(client, clusterService));
        this.setScheduler(new JobScheduler(threadPool, (JobRunner)this.getRunner()));
        Settings settings3 = environment.settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings3, (String)"settings(...)");
        this.setSweeper(new JobSweeper(settings3, client, clusterService, threadPool, xContentRegistry, this.getScheduler(), ALERTING_JOB_TYPES));
        this.setDestinationMigrationCoordinator(new DestinationMigrationCoordinator(client, clusterService, threadPool, this.getScheduledJobIndices()));
        Settings settings4 = environment.settings();
        Intrinsics.checkNotNullExpressionValue((Object)settings4, (String)"settings(...)");
        this.setAlertV2Mover(new AlertV2Mover(settings4, client, threadPool, clusterService, xContentRegistry));
        this.setThreadPool(threadPool);
        this.setClusterService(clusterService);
        MonitorMetadataService.INSTANCE.initialize(client, clusterService, xContentRegistry, settings);
        WorkflowMetadataService.INSTANCE.initialize(client, clusterService, xContentRegistry, settings);
        DeleteMonitorService.INSTANCE.initialize(client, lockService);
        Object[] objectArray = new Object[]{this.getSweeper(), this.getScheduler(), this.getRunner(), this.getScheduledJobIndices(), this.getCommentsIndices(), this.getDocLevelMonitorQueries(), this.getDestinationMigrationCoordinator(), this.getAlertV2Mover(), lockService, alertService, triggerService};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<Setting<?>> getSettings() {
        Object[] objectArray = new Setting[]{ScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), ScheduledJobSettings.Companion.getSWEEP_PERIOD(), ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), ScheduledJobSettings.Companion.getSWEEPER_ENABLED(), LegacyOpenDistroScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_PERIOD(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), LegacyOpenDistroScheduledJobSettings.Companion.getSWEEPER_ENABLED(), AlertingSettings.Companion.getINPUT_TIMEOUT(), AlertingSettings.Companion.getINDEX_TIMEOUT(), AlertingSettings.Companion.getBULK_TIMEOUT(), AlertingSettings.Companion.getALERT_BACKOFF_MILLIS(), AlertingSettings.Companion.getALERT_BACKOFF_COUNT(), AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS(), AlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT(), AlertingSettings.Companion.getALERT_HISTORY_ENABLED(), AlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), AlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), AlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), AlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), AlertingSettings.Companion.getALERTING_MAX_MONITORS(), AlertingSettings.Companion.getPERCOLATE_QUERY_DOCS_SIZE_MEMORY_PERCENTAGE_LIMIT(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_FAN_OUT_NODES(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_SHARD_FETCH_SIZE(), AlertingSettings.Companion.getPERCOLATE_QUERY_MAX_NUM_DOCS_IN_MEMORY(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_FANOUT_MAX_DURATION(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_EXECUTION_MAX_DURATION(), AlertingSettings.Companion.getREQUEST_TIMEOUT(), AlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), AlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), AlertingSettings.Companion.getMAX_ACTIONABLE_ALERT_COUNT(), LegacyOpenDistroAlertingSettings.Companion.getINPUT_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getINDEX_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getBULK_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getALERT_BACKOFF_MILLIS(), LegacyOpenDistroAlertingSettings.Companion.getALERT_BACKOFF_COUNT(), LegacyOpenDistroAlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_MILLIS(), LegacyOpenDistroAlertingSettings.Companion.getMOVE_ALERTS_BACKOFF_COUNT(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_ENABLED(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_ROLLOVER_PERIOD(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_INDEX_MAX_AGE(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_MAX_DOCS(), LegacyOpenDistroAlertingSettings.Companion.getALERT_HISTORY_RETENTION_PERIOD(), LegacyOpenDistroAlertingSettings.Companion.getALERTING_MAX_MONITORS(), LegacyOpenDistroAlertingSettings.Companion.getREQUEST_TIMEOUT(), LegacyOpenDistroAlertingSettings.Companion.getMAX_ACTION_THROTTLE_VALUE(), LegacyOpenDistroAlertingSettings.Companion.getFILTER_BY_BACKEND_ROLES(), AlertingSettings.Companion.getDOC_LEVEL_MONITOR_FETCH_ONLY_QUERY_FIELDS_ENABLED(), DestinationSettings.Companion.getEMAIL_USERNAME(), DestinationSettings.Companion.getEMAIL_PASSWORD(), DestinationSettings.Companion.getALLOW_LIST(), DestinationSettings.Companion.getHOST_DENY_LIST(), LegacyOpenDistroDestinationSettings.Companion.getEMAIL_USERNAME(), LegacyOpenDistroDestinationSettings.Companion.getEMAIL_PASSWORD(), LegacyOpenDistroDestinationSettings.Companion.getALLOW_LIST(), LegacyOpenDistroDestinationSettings.Companion.getHOST_DENY_LIST(), AlertingSettings.Companion.getFINDING_HISTORY_ENABLED(), AlertingSettings.Companion.getFINDING_HISTORY_MAX_DOCS(), AlertingSettings.Companion.getFINDING_HISTORY_INDEX_MAX_AGE(), AlertingSettings.Companion.getFINDING_HISTORY_ROLLOVER_PERIOD(), AlertingSettings.Companion.getFINDING_HISTORY_RETENTION_PERIOD(), AlertingSettings.Companion.getFINDINGS_INDEXING_BATCH_SIZE(), AlertingSettings.Companion.getCROSS_CLUSTER_MONITORING_ENABLED(), AlertingSettings.Companion.getALERTING_COMMENTS_ENABLED(), AlertingSettings.Companion.getCOMMENTS_HISTORY_MAX_DOCS(), AlertingSettings.Companion.getCOMMENTS_HISTORY_INDEX_MAX_AGE(), AlertingSettings.Companion.getCOMMENTS_HISTORY_ROLLOVER_PERIOD(), AlertingSettings.Companion.getCOMMENTS_HISTORY_RETENTION_PERIOD(), AlertingSettings.Companion.getCOMMENTS_MAX_CONTENT_SIZE(), AlertingSettings.Companion.getMAX_COMMENTS_PER_ALERT(), AlertingSettings.Companion.getMAX_COMMENTS_PER_NOTIFICATION(), AlertingSettings.Companion.getALERT_V2_HISTORY_ENABLED(), AlertingSettings.Companion.getALERT_V2_HISTORY_ROLLOVER_PERIOD(), AlertingSettings.Companion.getALERT_V2_HISTORY_INDEX_MAX_AGE(), AlertingSettings.Companion.getALERT_V2_HISTORY_MAX_DOCS(), AlertingSettings.Companion.getALERT_V2_HISTORY_RETENTION_PERIOD(), AlertingSettings.Companion.getALERT_V2_MONITOR_EXECUTION_MAX_DURATION(), AlertingSettings.Companion.getALERTING_V2_MAX_MONITORS(), AlertingSettings.Companion.getALERTING_V2_MAX_THROTTLE_DURATION(), AlertingSettings.Companion.getALERTING_V2_MAX_EXPIRE_DURATION(), AlertingSettings.Companion.getALERTING_V2_MAX_LOOK_BACK_WINDOW(), AlertingSettings.Companion.getALERTING_V2_MAX_QUERY_LENGTH(), AlertingSettings.Companion.getALERTING_V2_QUERY_RESULTS_MAX_DATAROWS(), AlertingSettings.Companion.getALERT_V2_QUERY_RESULTS_MAX_SIZE(), AlertingSettings.Companion.getALERT_V2_PER_RESULT_TRIGGER_MAX_ALERTS(), AlertingSettings.Companion.getNOTIFICATION_SUBJECT_SOURCE_MAX_LENGTH(), AlertingSettings.Companion.getNOTIFICATION_MESSAGE_SOURCE_MAX_LENGTH(), AlertingV2Settings.Companion.getALERTING_V2_ENABLED(), AlertingSettings.Companion.getNOTIFICATION_CONTEXT_RESULTS_ALLOWED_ROLES()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void onIndexModule(@NotNull IndexModule indexModule) {
        Intrinsics.checkNotNullParameter((Object)indexModule, (String)"indexModule");
        if (Intrinsics.areEqual((Object)indexModule.getIndex().getName(), (Object)".opendistro-alerting-config")) {
            indexModule.addIndexOperationListener((IndexingOperationListener)this.getSweeper());
        }
    }

    @NotNull
    public List<ScriptContext<?>> getContexts() {
        return CollectionsKt.listOf(TriggerScript.Companion.getCONTEXT());
    }

    @NotNull
    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Object[] objectArray = new SystemIndexDescriptor[]{new SystemIndexDescriptor(".opendistro-alerting-alert*", "Alerting Plugin system index pattern"), new SystemIndexDescriptor(".opendistro-alerting-config", "Alerting Plugin Configuration index"), new SystemIndexDescriptor(".opensearch-alerting-comments*", "Alerting Comments system index pattern"), new SystemIndexDescriptor(".opensearch-alerting-v2-alert*", "Alerting V2 Alerts index pattern")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public void reload(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.getRunner().reloadDestinationSettings(settings);
    }

    @NotNull
    public List<SearchPlugin.PipelineAggregationSpec> getPipelineAggregations() {
        return CollectionsKt.listOf((Object)new SearchPlugin.PipelineAggregationSpec(BucketSelectorExtAggregationBuilder.Companion.getNAME(), AlertingPlugin::getPipelineAggregations$lambda$0, AlertingPlugin::getPipelineAggregations$lambda$1).addResultReader(AlertingPlugin::getPipelineAggregations$lambda$2));
    }

    @Override
    public void loadExtensions(@NotNull ExtensiblePlugin.ExtensionLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        for (RemoteMonitorRunnerExtension monitorExtension : loader.loadExtensions(RemoteMonitorRunnerExtension.class)) {
            Map monitorTypesToMonitorRunners = monitorExtension.getMonitorTypesToMonitorRunners();
            for (Map.Entry monitorTypeToMonitorRunner : monitorTypesToMonitorRunners.entrySet()) {
                String monitorType = (String)monitorTypeToMonitorRunner.getKey();
                RemoteMonitorRunner monitorRunner = (RemoteMonitorRunner)monitorTypeToMonitorRunner.getValue();
                if (this.monitorTypeToMonitorRunners.containsKey(monitorType)) continue;
                RemoteMonitorRegistry monitorRegistry = new RemoteMonitorRegistry(monitorType, monitorRunner);
                this.monitorTypeToMonitorRunners.put(monitorType, monitorRegistry);
            }
        }
    }

    private static final PipelineAggregationBuilder getPipelineAggregations$lambda$0(StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        return (PipelineAggregationBuilder)new BucketSelectorExtAggregationBuilder(sin);
    }

    private static final PipelineAggregationBuilder getPipelineAggregations$lambda$1(XContentParser parser, String agg_name) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)agg_name, (String)"agg_name");
        return (PipelineAggregationBuilder)BucketSelectorExtAggregationBuilder.Companion.parse(agg_name, parser);
    }

    private static final InternalAggregation getPipelineAggregations$lambda$2(StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        return (InternalAggregation)new BucketSelectorIndices(sin);
    }

    static {
        Object[] objectArray = new String[]{"monitor.ui_metadata"};
        UI_METADATA_EXCLUDE = objectArray;
        MONITOR_BASE_URI = "/_plugins/_alerting/monitors";
        MONITOR_V2_BASE_URI = "/_plugins/_alerting/v2/monitors";
        WORKFLOW_BASE_URI = "/_plugins/_alerting/workflows";
        REMOTE_BASE_URI = "/_plugins/_alerting/remote";
        DESTINATION_BASE_URI = "/_plugins/_alerting/destinations";
        LEGACY_OPENDISTRO_MONITOR_BASE_URI = "/_opendistro/_alerting/monitors";
        LEGACY_OPENDISTRO_DESTINATION_BASE_URI = "/_opendistro/_alerting/destinations";
        EMAIL_ACCOUNT_BASE_URI = DESTINATION_BASE_URI + "/email_accounts";
        EMAIL_GROUP_BASE_URI = DESTINATION_BASE_URI + "/email_groups";
        LEGACY_OPENDISTRO_EMAIL_ACCOUNT_BASE_URI = LEGACY_OPENDISTRO_DESTINATION_BASE_URI + "/email_accounts";
        LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI = LEGACY_OPENDISTRO_DESTINATION_BASE_URI + "/email_groups";
        FINDING_BASE_URI = "/_plugins/_alerting/findings";
        COMMENTS_BASE_URI = "/_plugins/_alerting/comments";
        objectArray = new String[]{"monitor", "workflow", "monitor_v2"};
        ALERTING_JOB_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00178\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/opensearch/alerting/AlertingPlugin$Companion;", "", "<init>", "()V", "OPEN_SEARCH_DASHBOARDS_USER_AGENT", "", "UI_METADATA_EXCLUDE", "", "[Ljava/lang/String;", "MONITOR_BASE_URI", "MONITOR_V2_BASE_URI", "WORKFLOW_BASE_URI", "REMOTE_BASE_URI", "DESTINATION_BASE_URI", "LEGACY_OPENDISTRO_MONITOR_BASE_URI", "LEGACY_OPENDISTRO_DESTINATION_BASE_URI", "EMAIL_ACCOUNT_BASE_URI", "EMAIL_GROUP_BASE_URI", "LEGACY_OPENDISTRO_EMAIL_ACCOUNT_BASE_URI", "LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI", "FINDING_BASE_URI", "COMMENTS_BASE_URI", "ALERTING_JOB_TYPES", "", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

