"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.needs = void 0;
/* Preconditions, postconditions, and loop invariants are very
 * useful for safe programing.  They also document the specifications.
 * This function is to help simplify the semantic burden of parsing
 * these constructions.
 *
 * Instead of constructions like
 * if (!goodCondition) throw new Error('condition not true')
 *
 * needs(goodCondition, 'condition not true')
 */
function needs(condition, errorMessage, Err = Error) {
    if (!condition) {
        throw new Err(errorMessage);
    }
}
exports.needs = needs;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmVlZHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbmVlZHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7OztBQUV0Qzs7Ozs7Ozs7O0dBU0c7QUFFSCxTQUFnQixLQUFLLENBQ25CLFNBQWMsRUFDZCxZQUFvQixFQUNwQixNQUF3QixLQUFLO0lBRTdCLElBQUksQ0FBQyxTQUFTLEVBQUU7UUFDZCxNQUFNLElBQUksR0FBRyxDQUFDLFlBQVksQ0FBQyxDQUFBO0tBQzVCO0FBQ0gsQ0FBQztBQVJELHNCQVFDIn0=