/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.search.aggregations.bucket.geogrid;

import java.util.Locale;
import lombok.NonNull;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.geospatial.h3.H3;
import org.opensearch.geospatial.h3.LatLng;

public class GeoHexHelper {
    public static void checkPrecisionRange(int precision) {
        if (precision < H3.MIN_H3_RES || precision > H3.MAX_H3_RES) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid precision of %d . Must be between %d and %d.", precision, H3.MIN_H3_RES, H3.MAX_H3_RES));
        }
    }

    public static GeoPoint h3ToGeoPoint(long h3CellID) {
        if (!H3.h3IsValid((long)h3CellID)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid H3 Cell address: %d", h3CellID));
        }
        LatLng position = H3.h3ToLatLng((long)h3CellID);
        return new GeoPoint(position.getLatDeg(), position.getLonDeg());
    }

    public static GeoPoint h3ToGeoPoint(@NonNull String h3CellID) {
        if (h3CellID == null) {
            throw new NullPointerException("h3CellID is marked non-null but is null");
        }
        return GeoHexHelper.h3ToGeoPoint(H3.stringToH3((String)h3CellID));
    }

    public static long longEncode(double longitude, double latitude, int precision) {
        return H3.geoToH3((double)latitude, (double)longitude, (int)precision);
    }
}

