/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.indexmanagement.IndexManagementIndices;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.RollupMapperService;
import org.opensearch.indexmanagement.rollup.action.mapping.UpdateRollupMappingAction;
import org.opensearch.indexmanagement.rollup.action.mapping.UpdateRollupMappingRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupJobValidationResult;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.indexmanagement.rollup.settings.LegacyOpenDistroRollupSettings;
import org.opensearch.indexmanagement.rollup.settings.RollupSettings;
import org.opensearch.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 =2\u00020\u0001:\u0002=>B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u001bJ.\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00142\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010 H\u0086@\u00a2\u0006\u0002\u0010!J\u001e\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010&J&\u0010'\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J(\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0017\u001a\u00020\u0018H\u0082@\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010/J\u001e\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u00102J \u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u00162\u000e\u00105\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u000306H\u0002J\u001e\u00107\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u00108\u001a\u0002092\u0006\u00101\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010:J\u0010\u0010;\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0016H\u0002J\u001e\u0010<\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupMapperService;", "", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "<init>", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;)V", "getClient", "()Lorg/opensearch/transport/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "validateAndAttemptToUpdateTargetIndex", "Lorg/opensearch/indexmanagement/rollup/model/RollupJobValidationResult;", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "targetIndexResolvedName", "", "hasLegacyPlugin", "", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateTargetIndexAlias", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateNonWriteBackingIndex", "backingIndex", "currentRollupJob", "rollupJobs", "", "(Ljava/lang/String;Lorg/opensearch/indexmanagement/rollup/model/Rollup;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attemptCreateRollupTargetIndex", "job", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addRollupSettingToIndex", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareTargetIndex", "createTargetIndex", "Lorg/opensearch/action/admin/indices/create/CreateIndexResponse;", "targetIndexName", "targetIndexSettings", "Lorg/opensearch/common/settings/Settings;", "(Ljava/lang/String;Lorg/opensearch/common/settings/Settings;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSourceIndexValid", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSourceIndexMappingsValid", "index", "(Ljava/lang/String;Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isFieldInMappings", "fieldName", "mappings", "", "jobExistsInRollupIndex", "getMappings", "Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "indexExists", "updateRollupIndexMappings", "Companion", "GetMappingsResult", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollupMapperService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollupMapperService.kt\norg/opensearch/indexmanagement/rollup/RollupMapperService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,438:1\n1869#2,2:439\n1869#2,2:444\n1869#2,2:446\n1#3:441\n13472#4,2:442\n*S KotlinDebug\n*F\n+ 1 RollupMapperService.kt\norg/opensearch/indexmanagement/rollup/RollupMapperService\n*L\n115#1:439,2\n298#1:444,2\n317#1:446,2\n268#1:442,2\n*E\n"})
public final class RollupMapperService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Logger logger;
    @NotNull
    public static final String ROLLUPS = "rollups";

    public RollupMapperService(@NotNull Client client, @NotNull ClusterService clusterService, @NotNull IndexNameExpressionResolver indexNameExpressionResolver) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        this.client = client;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    /*
     * Unable to fully structure code
     */
    private final Object validateAndAttemptToUpdateTargetIndex(Rollup rollup, String targetIndexResolvedName, boolean hasLegacyPlugin, Continuation<? super RollupJobValidationResult> $completion) {
        block18: {
            block17: {
                if (!($completion instanceof validateAndAttemptToUpdateTargetIndex.1)) ** GOTO lbl-1000
                var7_5 = $completion;
                if ((var7_5.label & -2147483648) != 0) {
                    var7_5.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(this, $completion){
                        Object L$0;
                        Object L$1;
                        Object L$2;
                        boolean Z$0;
                        /* synthetic */ Object result;
                        final /* synthetic */ RollupMapperService this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return RollupMapperService.access$validateAndAttemptToUpdateTargetIndex(this.this$0, null, null, false, (Continuation)this);
                        }
                    };
                }
                $result = $continuation.result;
                var8_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!RollupUtilsKt.isTargetIndexAlias(rollup)) break;
                        $continuation.L$0 = rollup;
                        $continuation.L$1 = targetIndexResolvedName;
                        $continuation.Z$0 = hasLegacyPlugin;
                        $continuation.label = 1;
                        v0 = this.validateTargetIndexAlias(rollup, targetIndexResolvedName, (Continuation<? super RollupJobValidationResult>)$continuation);
                        if (v0 == var8_7) {
                            return var8_7;
                        }
                        ** GOTO lbl27
                    }
                    case 1: {
                        hasLegacyPlugin = $continuation.Z$0;
                        targetIndexResolvedName = (String)$continuation.L$1;
                        rollup = (Rollup)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl27:
                        // 2 sources

                        if (!((aliasValidationResult = (RollupJobValidationResult)v0) instanceof RollupJobValidationResult.Valid)) {
                            return aliasValidationResult;
                        }
                        v1 = this.clusterService.state();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"state(...)");
                        if (RollupUtilsKt.isRollupIndex(targetIndexResolvedName, v1)) break block17;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                        $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetIndexResolvedName);
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)aliasValidationResult);
                        $continuation.Z$0 = hasLegacyPlugin;
                        $continuation.label = 2;
                        v2 = this.prepareTargetIndex(rollup, targetIndexResolvedName, hasLegacyPlugin != false, (Continuation<? super RollupJobValidationResult>)$continuation);
                        if (v2 == var8_7) {
                            return var8_7;
                        }
                        ** GOTO lbl48
                    }
                    case 2: {
                        hasLegacyPlugin = $continuation.Z$0;
                        aliasValidationResult = (RollupJobValidationResult)$continuation.L$2;
                        targetIndexResolvedName = (String)$continuation.L$1;
                        rollup = (Rollup)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl48:
                        // 2 sources

                        return v2;
                    }
                }
                v3 = this.clusterService.state();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"state(...)");
                if (!RollupUtilsKt.isRollupIndex(targetIndexResolvedName, v3)) {
                    return new RollupJobValidationResult.Invalid("Target index [" + targetIndexResolvedName + "] is a non rollup index");
                }
            }
            $continuation.L$0 = rollup;
            $continuation.L$1 = targetIndexResolvedName;
            $continuation.Z$0 = hasLegacyPlugin;
            $continuation.label = 3;
            v4 = this.jobExistsInRollupIndex(rollup, targetIndexResolvedName, (Continuation<? super RollupJobValidationResult>)$continuation);
            if (v4 == var8_7) {
                return var8_7;
            }
            ** GOTO lbl68
            {
                case 3: {
                    hasLegacyPlugin = $continuation.Z$0;
                    targetIndexResolvedName = (String)$continuation.L$1;
                    rollup = (Rollup)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl68:
                    // 2 sources

                    if (!((jobExistsResult = (RollupJobValidationResult)v4) instanceof RollupJobValidationResult.Valid)) ** GOTO lbl71
                    v5 = jobExistsResult;
                    break block18;
lbl71:
                    // 1 sources

                    if (!(jobExistsResult instanceof RollupJobValidationResult.Invalid)) break;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetIndexResolvedName);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)jobExistsResult);
                    $continuation.Z$0 = hasLegacyPlugin;
                    $continuation.label = 4;
                    v6 = this.updateRollupIndexMappings(rollup, targetIndexResolvedName, (Continuation<? super RollupJobValidationResult>)$continuation);
                    if (v6 == var8_7) {
                        return var8_7;
                    }
                    ** GOTO lbl88
                }
                case 4: {
                    hasLegacyPlugin = $continuation.Z$0;
                    jobExistsResult = (RollupJobValidationResult)$continuation.L$2;
                    targetIndexResolvedName = (String)$continuation.L$1;
                    rollup = (Rollup)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl88:
                    // 2 sources

                    return v6;
                }
            }
            if (jobExistsResult instanceof RollupJobValidationResult.Failure) {
                v5 = jobExistsResult;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v5;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object validateTargetIndexAlias(@NotNull Rollup rollup, @NotNull String targetIndexResolvedName, @NotNull Continuation<? super RollupJobValidationResult> $completion) {
        if (!($completion instanceof validateTargetIndexAlias.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.validateTargetIndexAlias(null, null, (Continuation<? super RollupJobValidationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = null;
                if (!RollupFieldValueExpressionResolver.INSTANCE.getIndexAliasUtils().hasAlias(targetIndexResolvedName)) {
                    this.logger.error("[" + rollup.getTargetIndex() + "] is not an alias!");
                    return new RollupJobValidationResult.Failure("[" + rollup.getTargetIndex() + "] is not an alias!", null, 2, null);
                }
                v0 = this.clusterService.state().getMetadata().index(targetIndexResolvedName);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"index(...)");
                rollupJobs = RollupUtilsKt.getRollupJobs(v0);
                if (!(rollupJobs == null || rollupJobs.size() <= 1 && Intrinsics.areEqual((Object)rollupJobs.get(0).getId(), (Object)rollup.getId()))) {
                    errorMessage = "More than one rollup jobs present on the backing index of the target alias, cannot perform rollup to this target alias [" + rollup.getTargetIndex() + "].";
                    this.logger.error(errorMessage);
                    return new RollupJobValidationResult.Failure(errorMessage, null, 2, null);
                }
                v1 = backingIndices = RollupFieldValueExpressionResolver.INSTANCE.getIndexAliasUtils().getBackingIndicesForAlias(rollup.getTargetIndex());
                if (v1 == null) break;
                $this$forEach$iv = v1;
                $i$f$forEach = 0;
                var9_12 = $this$forEach$iv.iterator();
lbl28:
                // 3 sources

                while (var9_12.hasNext()) {
                    element$iv = var9_12.next();
                    it = (IndexMetadata)element$iv;
                    $i$a$-forEach-RollupMapperService$validateTargetIndexAlias$2 = 0;
                    if (Intrinsics.areEqual((Object)it.getIndex().getName(), (Object)targetIndexResolvedName)) continue;
                    v2 = this.clusterService.state().getMetadata().index(it.getIndex().getName());
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"index(...)");
                    allRollupJobs = RollupUtilsKt.getRollupJobs(v2);
                    v3 = it.getIndex().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                    $continuation.L$0 = rollup;
                    $continuation.L$1 = targetIndexResolvedName;
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)rollupJobs);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)backingIndices);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv);
                    $continuation.L$5 = var9_12;
                    $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable(allRollupJobs);
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = $i$a$-forEach-RollupMapperService$validateTargetIndexAlias$2;
                    $continuation.label = 1;
                    v4 = this.validateNonWriteBackingIndex(v3, rollup, allRollupJobs, (Continuation<? super RollupJobValidationResult>)$continuation);
                    if (v4 == var17_6) {
                        return var17_6;
                    }
                    ** GOTO lbl70
                }
                break;
            }
            case 1: {
                $i$a$-forEach-RollupMapperService$validateTargetIndexAlias$2 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                allRollupJobs = (List<Rollup>)$continuation.L$8;
                it = (IndexMetadata)$continuation.L$7;
                element$iv = $continuation.L$6;
                var9_12 = (Iterator<T>)$continuation.L$5;
                $this$forEach$iv = (Iterable)$continuation.L$4;
                backingIndices = (List)$continuation.L$3;
                rollupJobs = (List)$continuation.L$2;
                errorMessage = null;
                targetIndexResolvedName = (String)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl70:
                // 2 sources

                if ((validationResult = (RollupJobValidationResult)v4) instanceof RollupJobValidationResult.Valid) ** GOTO lbl28
                return validationResult;
            }
        }
        return RollupJobValidationResult.Valid.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object validateNonWriteBackingIndex(@NotNull String backingIndex, @NotNull Rollup currentRollupJob, @Nullable List<Rollup> rollupJobs, @NotNull Continuation<? super RollupJobValidationResult> $completion) {
        Object errorMessage = "";
        if (rollupJobs == null) {
            errorMessage = "Backing index [" + backingIndex + "] has to have owner rollup job with id:[" + currentRollupJob.getId() + "]";
        } else if (rollupJobs.size() == 1 && !Intrinsics.areEqual((Object)rollupJobs.get(0).getId(), (Object)currentRollupJob.getId())) {
            errorMessage = "Backing index [" + backingIndex + "] has to have owner rollup job with id:[" + currentRollupJob.getId() + "]";
        } else if (rollupJobs.size() > 1) {
            errorMessage = "Backing index [" + backingIndex + "] has multiple rollup job owners";
        }
        if (((CharSequence)errorMessage).length() > 0) {
            this.logger.error((String)errorMessage);
            return new RollupJobValidationResult.Failure((String)errorMessage, null, 2, null);
        }
        return RollupJobValidationResult.Valid.INSTANCE;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final Object attemptCreateRollupTargetIndex(@NotNull Rollup job, boolean hasLegacyPlugin, @NotNull Continuation<? super RollupJobValidationResult> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 7[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object addRollupSettingToIndex(@NotNull String targetIndexResolvedName, boolean hasLegacyPlugin, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof addRollupSettingToIndex.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.addRollupSettingToIndex(null, false, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                settings = hasLegacyPlugin != false ? Settings.builder().put(LegacyOpenDistroRollupSettings.Companion.getROLLUP_INDEX().getKey(), true).build() : Settings.builder().put(RollupSettings.Companion.getROLLUP_INDEX().getKey(), true).build();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)targetIndexResolvedName);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)settings);
                $continuation.Z$0 = hasLegacyPlugin;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client.admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, addRollupSettingToIndex$lambda$1(org.opensearch.common.settings.Settings java.lang.String org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((Settings)settings, (String)targetIndexResolvedName), $continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl27
            }
            case 1: {
                hasLegacyPlugin = $continuation.Z$0;
                settings = (Settings)$continuation.L$1;
                targetIndexResolvedName = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                resp = (AcknowledgedResponse)v0;
                return Boxing.boxBoolean((boolean)resp.isAcknowledged());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object prepareTargetIndex(@NotNull Rollup rollup, @NotNull String targetIndexResolvedName, boolean hasLegacyPlugin, @NotNull Continuation<? super RollupJobValidationResult> $completion) {
        if (!($completion instanceof prepareTargetIndex.1)) ** GOTO lbl-1000
        var10_5 = $completion;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.prepareTargetIndex(null, null, false, (Continuation<? super RollupJobValidationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = "";
                $continuation.L$0 = rollup;
                $continuation.L$1 = targetIndexResolvedName;
                $continuation.L$2 = errorMessage;
                $continuation.Z$0 = hasLegacyPlugin;
                $continuation.label = 1;
                v0 = this.addRollupSettingToIndex(targetIndexResolvedName, hasLegacyPlugin != false, (Continuation<? super Boolean>)$continuation);
                ** if (v0 != var11_7) goto lbl23
lbl22:
                // 1 sources

                return var11_7;
lbl23:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                hasLegacyPlugin = $continuation.Z$0;
                errorMessage = (String)$continuation.L$2;
                targetIndexResolvedName = (String)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) {
                    this.logger.error("Failed to update rollup settings for target index: [" + targetIndexResolvedName + "]");
                    return new RollupJobValidationResult.Invalid("Failed to update rollup settings for target index: [" + targetIndexResolvedName + "]");
                }
                var8_9 = new String[]{targetIndexResolvedName};
                v1 = new PutMappingRequest(var8_9).source(IndexManagementIndices.Companion.getRollupTargetMappings(), (MediaType)XContentType.JSON);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"source(...)");
                putMappingRequest = v1;
                $continuation.L$0 = rollup;
                $continuation.L$1 = targetIndexResolvedName;
                $continuation.L$2 = errorMessage;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)putMappingRequest);
                $continuation.Z$0 = hasLegacyPlugin;
                $continuation.label = 2;
                v2 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client.admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, prepareTargetIndex$lambda$2(org.opensearch.action.admin.indices.mapping.put.PutMappingRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((PutMappingRequest)putMappingRequest), $continuation);
                ** if (v2 != var11_7) goto lbl49
lbl48:
                // 1 sources

                return var11_7;
lbl49:
                // 1 sources

                ** GOTO lbl60
            }
            case 2: {
                hasLegacyPlugin = $continuation.Z$0;
                putMappingRequest = (PutMappingRequest)$continuation.L$3;
                errorMessage = (String)$continuation.L$2;
                targetIndexResolvedName = (String)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl60:
                // 2 sources

                if (!(respMappings = (AcknowledgedResponse)v2).isAcknowledged()) {
                    return new RollupJobValidationResult.Invalid("Failed to put initial rollup mappings for target index [" + targetIndexResolvedName + "]");
                }
                errorMessage = "Failed to update mappings for target index [" + targetIndexResolvedName + "]";
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetIndexResolvedName);
                $continuation.L$2 = errorMessage;
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)putMappingRequest);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)respMappings);
                $continuation.Z$0 = hasLegacyPlugin;
                $continuation.label = 3;
                v3 = this.updateRollupIndexMappings(rollup, targetIndexResolvedName, (Continuation<? super RollupJobValidationResult>)$continuation);
                ** if (v3 != var11_7) goto lbl73
lbl72:
                // 1 sources

                return var11_7;
lbl73:
                // 1 sources

                ** GOTO lbl85
            }
            case 3: {
                hasLegacyPlugin = $continuation.Z$0;
                respMappings = (AcknowledgedResponse)$continuation.L$4;
                putMappingRequest = (PutMappingRequest)$continuation.L$3;
                errorMessage = (String)$continuation.L$2;
                targetIndexResolvedName = (String)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl85:
                    // 2 sources

                    (RollupJobValidationResult)v3;
                }
                catch (RemoteTransportException e) {
                    v4 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v4, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v4;
                    this.logger.error((String)errorMessage, (Throwable)unwrappedException);
                    (RollupJobValidationResult)new RollupJobValidationResult.Failure((String)errorMessage, unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    this.logger.error((String)errorMessage + " because ", (Throwable)e);
                    (RollupJobValidationResult)new RollupJobValidationResult.Failure((String)errorMessage + " - missing required cluster permissions: " + e.getLocalizedMessage(), (Exception)e);
                }
                catch (Exception e) {
                    this.logger.error((String)errorMessage + " because ", (Throwable)e);
                    (RollupJobValidationResult)new RollupJobValidationResult.Failure((String)errorMessage, e);
                }
                return RollupJobValidationResult.Valid.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object createTargetIndex(String targetIndexName, Settings targetIndexSettings, boolean hasLegacyPlugin, Continuation<? super CreateIndexResponse> $completion) {
        Settings.Builder builder;
        Settings.Builder $this$createTargetIndex_u24lambda_u244 = builder = Settings.builder();
        boolean bl = false;
        Settings settings = targetIndexSettings;
        if (settings != null) {
            Settings it = settings;
            boolean bl2 = false;
            $this$createTargetIndex_u24lambda_u244.put(it);
        }
        Setting<Boolean> rollupIndexSetting = hasLegacyPlugin ? LegacyOpenDistroRollupSettings.Companion.getROLLUP_INDEX() : RollupSettings.Companion.getROLLUP_INDEX();
        $this$createTargetIndex_u24lambda_u244.put(rollupIndexSetting.getKey(), true);
        Settings settings2 = builder.build();
        CreateIndexRequest request = new CreateIndexRequest(targetIndexName).settings(settings2).mapping(IndexManagementIndices.Companion.getRollupTargetMappings());
        return OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client.admin().indices(), (arg_0, arg_1) -> RollupMapperService.createTargetIndex$lambda$5(request, arg_0, arg_1), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object isSourceIndexValid(@NotNull Rollup rollup, @NotNull Continuation<? super RollupJobValidationResult> $completion) {
        if (!($completion instanceof isSourceIndexValid.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isSourceIndexValid(null, (Continuation<? super RollupJobValidationResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = new String[]{rollup.getSourceIndex()};
                concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpand(), true, var4_6);
                Intrinsics.checkNotNull((Object)concreteIndices);
                if (concreteIndices.length == 0) {
                    return new RollupJobValidationResult.Invalid("No indices found for [" + rollup.getSourceIndex() + "]");
                }
                $this$forEach$iv = concreteIndices;
                $i$f$forEach = 0;
                var6_9 = 0;
                var7_10 = $this$forEach$iv.length;
lbl21:
                // 2 sources

                while (var6_9 < var7_10) {
                    index = element$iv = $this$forEach$iv[var6_9];
                    $i$a$-forEach-RollupMapperService$isSourceIndexValid$2 = 0;
                    Intrinsics.checkNotNull((Object)index);
                    $continuation.L$0 = rollup;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)concreteIndices);
                    $continuation.L$2 = $this$forEach$iv;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)index);
                    $continuation.I$0 = $i$f$forEach;
                    $continuation.I$1 = var6_9;
                    $continuation.I$2 = var7_10;
                    $continuation.I$3 = $i$a$-forEach-RollupMapperService$isSourceIndexValid$2;
                    $continuation.label = 1;
                    v0 = this.isSourceIndexMappingsValid(index, rollup, (Continuation<? super RollupJobValidationResult>)$continuation);
                    if (v0 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl52
                }
                break;
            }
            case 1: {
                $i$a$-forEach-RollupMapperService$isSourceIndexValid$2 = $continuation.I$3;
                var7_10 = $continuation.I$2;
                var6_9 = $continuation.I$1;
                $i$f$forEach = $continuation.I$0;
                index = (String)$continuation.L$4;
                element$iv = (String)$continuation.L$3;
                $this$forEach$iv = (String[])$continuation.L$2;
                concreteIndices = (String[])$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl52:
                // 2 sources

                if (!((sourceIndexMappingResult = (RollupJobValidationResult)v0) instanceof RollupJobValidationResult.Valid)) {
                    if (sourceIndexMappingResult instanceof RollupJobValidationResult.Invalid) {
                        return sourceIndexMappingResult;
                    }
                    if (sourceIndexMappingResult instanceof RollupJobValidationResult.Failure) {
                        return sourceIndexMappingResult;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                ++var6_9;
                ** GOTO lbl21
            }
        }
        return RollupJobValidationResult.Valid.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isSourceIndexMappingsValid(String index, Rollup rollup, Continuation<? super RollupJobValidationResult> $completion) {
        if (!($completion instanceof isSourceIndexMappingsValid.1)) ** GOTO lbl-1000
        var16_4 = $completion;
        if ((var16_4.label & -2147483648) != 0) {
            var16_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMapperService.access$isSourceIndexMappingsValid(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = index;
                $continuation.L$1 = rollup;
                $continuation.label = 1;
                v0 = this.getMappings(index, (Continuation<? super GetMappingsResult>)$continuation);
                ** if (v0 != var17_6) goto lbl20
lbl19:
                // 1 sources

                return var17_6;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                rollup = (Rollup)$continuation.L$1;
                index = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    if (!((getMappingsResult = (GetMappingsResult)v0) instanceof GetMappingsResult.Success)) {
                        if (getMappingsResult instanceof GetMappingsResult.Failure) {
                            return new RollupJobValidationResult.Failure(((GetMappingsResult.Failure)getMappingsResult).getMessage(), ((GetMappingsResult.Failure)getMappingsResult).getCause());
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    res = ((GetMappingsResult.Success)getMappingsResult).getResponse();
                    indexTypeMappings = (MappingMetadata)res.getMappings().get(index);
                    if (indexTypeMappings == null) {
                        return new RollupJobValidationResult.Invalid("Source index [" + index + "] mappings are empty, cannot validate the job.");
                    }
                    indexMappingSource = indexTypeMappings.getSourceAsMap();
                    issues = new LinkedHashSet<E>();
                    $this$forEach$iv = rollup.getDimensions();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        dimension = (Dimension)element$iv;
                        $i$a$-forEach-RollupMapperService$isSourceIndexMappingsValid$2 = false;
                        v1 = dimension.getSourceField();
                        Intrinsics.checkNotNull((Object)indexMappingSource);
                        if (!this.isFieldInMappings(v1, indexMappingSource)) {
                            issues.add("missing field " + dimension.getSourceField());
                        }
                        if (!((var14_19 = dimension) instanceof DateHistogram) && !(var14_19 instanceof Histogram) && !(var14_19 instanceof Terms)) continue;
                    }
                    $this$forEach$iv = rollup.getMetrics();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        metric = (RollupMetrics)element$iv;
                        $i$a$-forEach-RollupMapperService$isSourceIndexMappingsValid$3 = false;
                        v2 = metric.getSourceField();
                        Intrinsics.checkNotNull((Object)indexMappingSource);
                        if (this.isFieldInMappings(v2, indexMappingSource)) continue;
                        issues.add("missing field " + metric.getSourceField());
                    }
                    return issues.isEmpty() != false ? (RollupJobValidationResult)RollupJobValidationResult.Valid.INSTANCE : (RollupJobValidationResult)new RollupJobValidationResult.Invalid("Invalid mappings for index [" + index + "] because " + issues);
                }
                catch (Exception e) {
                    errorMessage = "Failed to validate the source index mappings";
                    this.logger.error(errorMessage, (Throwable)e);
                    return new RollupJobValidationResult.Failure(errorMessage, e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean isFieldInMappings(String fieldName, Map<?, ?> mappings) {
        Map<?, ?> field = IndexUtils.Companion.getFieldFromMappings(fieldName, mappings);
        return field != null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object jobExistsInRollupIndex(Rollup rollup, String targetIndexResolvedName, Continuation<? super RollupJobValidationResult> $completion) {
        if (!($completion instanceof jobExistsInRollupIndex.1)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMapperService.access$jobExistsInRollupIndex(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = rollup;
                $continuation.L$1 = targetIndexResolvedName;
                $continuation.label = 1;
                v0 = this.getMappings(targetIndexResolvedName, (Continuation<? super GetMappingsResult>)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                targetIndexResolvedName = (String)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!((getMappingsResult = (GetMappingsResult)v0) instanceof GetMappingsResult.Success)) {
                    if (getMappingsResult instanceof GetMappingsResult.Failure) {
                        return new RollupJobValidationResult.Failure(((GetMappingsResult.Failure)getMappingsResult).getMessage(), ((GetMappingsResult.Failure)getMappingsResult).getCause());
                    }
                    throw new NoWhenBranchMatchedException();
                }
                res = ((GetMappingsResult.Success)getMappingsResult).getResponse();
                indexMapping = (MappingMetadata)res.getMappings().get(targetIndexResolvedName);
                v1 = indexMapping;
                v2 = v1 != null && (v1 = v1.getSourceAsMap()) != null ? v1.get("_meta") : null;
                v3 = (Map)(v2 != null ? v2.get("rollups") : null);
                return (v3 != null ? v3.containsKey(rollup.getId()) : false) != false ? (RollupJobValidationResult)RollupJobValidationResult.Valid.INSTANCE : (RollupJobValidationResult)new RollupJobValidationResult.Invalid("Rollup job [" + rollup.getId() + "] does not exist in rollup index [" + targetIndexResolvedName + "]");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object getMappings(String index, Continuation<? super GetMappingsResult> $completion) {
        if (!($completion instanceof getMappings.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMapperService.access$getMappings(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = "Failed to get mappings for index [" + index + "]";
                var5_7 = new String[]{index};
                req = (GetMappingsRequest)new GetMappingsRequest().indices(var5_7);
                $continuation.L$0 = index;
                $continuation.L$1 = errorMessage;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)req);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.client.admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getMappings$lambda$9(org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((GetMappingsRequest)req), $continuation);
                ** if (v0 != var9_5) goto lbl24
lbl23:
                // 1 sources

                return var9_5;
lbl24:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                req = (GetMappingsRequest)$continuation.L$2;
                errorMessage = (String)$continuation.L$1;
                index = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    return (res = (GetMappingsResponse)v0) == null ? (GetMappingsResult)new GetMappingsResult.Failure(null, new IllegalStateException("GetMappingsResponse for index [" + index + "] was null"), 1, null) : (GetMappingsResult)new GetMappingsResult.Success(res);
                }
                catch (RemoteTransportException e) {
                    v1 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type java.lang.Exception");
                    unwrappedException = (Exception)v1;
                    this.logger.error((String)errorMessage, (Throwable)unwrappedException);
                    return new GetMappingsResult.Failure((String)errorMessage, unwrappedException);
                }
                catch (OpenSearchSecurityException e) {
                    this.logger.error((String)errorMessage, (Throwable)e);
                    return new GetMappingsResult.Failure((String)errorMessage + " - missing required index permissions: " + e.getLocalizedMessage(), (Exception)e);
                }
                catch (Exception e) {
                    this.logger.error((String)errorMessage, (Throwable)e);
                    return new GetMappingsResult.Failure((String)errorMessage, e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean indexExists(String index2) {
        return this.clusterService.state().getRoutingTable().hasIndex(index2);
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateRollupIndexMappings(Rollup rollup, String targetIndexResolvedName, Continuation<? super RollupJobValidationResult> $completion) {
        if (!($completion instanceof updateRollupIndexMappings.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RollupMapperService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupMapperService.access$updateRollupIndexMappings(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                errorMessage = "Failed to update mappings of target index [" + targetIndexResolvedName + "] with rollup job";
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)rollup);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)targetIndexResolvedName);
                $continuation.L$2 = errorMessage;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, rollup, null){
                    int label;
                    final /* synthetic */ RollupMapperService this$0;
                    final /* synthetic */ Rollup $rollup;
                    {
                        this.this$0 = $receiver;
                        this.$rollup = $rollup;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)this.this$0.getClient(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(org.opensearch.indexmanagement.rollup.model.Rollup org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((Rollup)this.$rollup), (Continuation)this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                resp = (AcknowledgedResponse)v0;
                                return Boxing.boxBoolean((boolean)resp.isAcknowledged());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(Rollup $rollup, Client $this$suspendUntil, ActionListener it) {
                        $this$suspendUntil.execute((ActionType)UpdateRollupMappingAction.Companion.getINSTANCE(), (ActionRequest)new UpdateRollupMappingRequest($rollup), it);
                        return Unit.INSTANCE;
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var9_6) goto lbl22
lbl21:
                // 1 sources

                return var9_6;
lbl22:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                errorMessage = (String)$continuation.L$2;
                targetIndexResolvedName = (String)$continuation.L$1;
                rollup = (Rollup)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    if (!(response = ((Boolean)v0).booleanValue())) {
                        this.logger.error((String)errorMessage + " with no exception");
                        return new RollupJobValidationResult.Failure((String)errorMessage, null, 2, null);
                    }
                    return RollupJobValidationResult.Valid.INSTANCE;
                }
                catch (OpenSearchSecurityException e) {
                    this.logger.error((String)errorMessage + " because ", (Throwable)e);
                    return new RollupJobValidationResult.Failure((String)errorMessage + " - missing required index permissions: " + e.getLocalizedMessage(), (Exception)e);
                }
                catch (Exception e) {
                    this.logger.error((String)errorMessage + " because ", (Throwable)e);
                    return new RollupJobValidationResult.Failure((String)errorMessage, e);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit addRollupSettingToIndex$lambda$1(Settings $settings, String $targetIndexResolvedName, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$targetIndexResolvedName};
        $this$suspendUntil.updateSettings(new UpdateSettingsRequest($settings, stringArray), it);
        return Unit.INSTANCE;
    }

    private static final Unit prepareTargetIndex$lambda$2(PutMappingRequest $putMappingRequest, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.putMapping($putMappingRequest, it);
        return Unit.INSTANCE;
    }

    private static final Unit createTargetIndex$lambda$5(CreateIndexRequest $request, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.create($request, it);
        return Unit.INSTANCE;
    }

    private static final Unit getMappings$lambda$9(GetMappingsRequest $req, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.getMappings($req, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$validateAndAttemptToUpdateTargetIndex(RollupMapperService $this, Rollup rollup2, String targetIndexResolvedName, boolean hasLegacyPlugin, Continuation $completion) {
        return $this.validateAndAttemptToUpdateTargetIndex(rollup2, targetIndexResolvedName, hasLegacyPlugin, (Continuation<? super RollupJobValidationResult>)$completion);
    }

    public static final /* synthetic */ Object access$createTargetIndex(RollupMapperService $this, String targetIndexName, Settings targetIndexSettings, boolean hasLegacyPlugin, Continuation $completion) {
        return $this.createTargetIndex(targetIndexName, targetIndexSettings, hasLegacyPlugin, (Continuation<? super CreateIndexResponse>)$completion);
    }

    public static final /* synthetic */ Object access$isSourceIndexMappingsValid(RollupMapperService $this, String index2, Rollup rollup2, Continuation $completion) {
        return $this.isSourceIndexMappingsValid(index2, rollup2, (Continuation<? super RollupJobValidationResult>)$completion);
    }

    public static final /* synthetic */ Object access$jobExistsInRollupIndex(RollupMapperService $this, Rollup rollup2, String targetIndexResolvedName, Continuation $completion) {
        return $this.jobExistsInRollupIndex(rollup2, targetIndexResolvedName, (Continuation<? super RollupJobValidationResult>)$completion);
    }

    public static final /* synthetic */ Object access$getMappings(RollupMapperService $this, String index2, Continuation $completion) {
        return $this.getMappings(index2, (Continuation<? super GetMappingsResult>)$completion);
    }

    public static final /* synthetic */ Object access$updateRollupIndexMappings(RollupMapperService $this, Rollup rollup2, String targetIndexResolvedName, Continuation $completion) {
        return $this.updateRollupIndexMappings(rollup2, targetIndexResolvedName, (Continuation<? super RollupJobValidationResult>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupMapperService$Companion;", "", "<init>", "()V", "ROLLUPS", "", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult;", "", "<init>", "()V", "Success", "Failure", "Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult$Failure;", "Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult$Success;", "opensearch-index-management"})
    public static abstract sealed class GetMappingsResult {
        private GetMappingsResult() {
        }

        public /* synthetic */ GetMappingsResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u000e\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J!\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult$Failure;", "Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult;", "message", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getMessage", "()Ljava/lang/String;", "getCause", "()Ljava/lang/Exception;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "opensearch-index-management"})
        public static final class Failure
        extends GetMappingsResult {
            @NotNull
            private final String message;
            @NotNull
            private final Exception cause;

            public Failure(@NotNull String message, @NotNull Exception cause) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                super(null);
                this.message = message;
                this.cause = cause;
            }

            public /* synthetic */ Failure(String string, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = "An error occurred when getting mappings";
                }
                this(string, exception);
            }

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            @NotNull
            public final Exception getCause() {
                return this.cause;
            }

            @NotNull
            public final String component1() {
                return this.message;
            }

            @NotNull
            public final Exception component2() {
                return this.cause;
            }

            @NotNull
            public final Failure copy(@NotNull String message, @NotNull Exception cause) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                return new Failure(message, cause);
            }

            public static /* synthetic */ Failure copy$default(Failure failure, String string, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    string = failure.message;
                }
                if ((n & 2) != 0) {
                    exception = failure.cause;
                }
                return failure.copy(string, exception);
            }

            @NotNull
            public String toString() {
                return "Failure(message=" + this.message + ", cause=" + this.cause + ")";
            }

            public int hashCode() {
                int result2 = this.message.hashCode();
                result2 = result2 * 31 + this.cause.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failure)) {
                    return false;
                }
                Failure failure = (Failure)other;
                if (!Intrinsics.areEqual((Object)this.message, (Object)failure.message)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.cause, (Object)failure.cause);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult$Success;", "Lorg/opensearch/indexmanagement/rollup/RollupMapperService$GetMappingsResult;", "response", "Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;", "<init>", "(Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;)V", "getResponse", "()Lorg/opensearch/action/admin/indices/mapping/get/GetMappingsResponse;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "opensearch-index-management"})
        public static final class Success
        extends GetMappingsResult {
            @NotNull
            private final GetMappingsResponse response;

            public Success(@NotNull GetMappingsResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                super(null);
                this.response = response2;
            }

            @NotNull
            public final GetMappingsResponse getResponse() {
                return this.response;
            }

            @NotNull
            public final GetMappingsResponse component1() {
                return this.response;
            }

            @NotNull
            public final Success copy(@NotNull GetMappingsResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                return new Success(response2);
            }

            public static /* synthetic */ Success copy$default(Success success, GetMappingsResponse getMappingsResponse, int n, Object object) {
                if ((n & 1) != 0) {
                    getMappingsResponse = success.response;
                }
                return success.copy(getMappingsResponse);
            }

            @NotNull
            public String toString() {
                return "Success(response=" + this.response + ")";
            }

            public int hashCode() {
                return this.response.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.response, (Object)success.response);
            }
        }
    }
}

