/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.snapshotmanagement.SMUtilsKt;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.SMActions;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesRequest;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyRequest;
import org.opensearch.indexmanagement.util.RestHandlerUtilsKt;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/resthandler/RestGetSMPolicyHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "getSMPolicyByName", "policyName", "getAllPolicies", "opensearch-index-management"})
public final class RestGetSMPolicyHandler
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "snapshot_management_get_policy_rest_handler";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        Object[] objectArray = new RestHandler.Route[]{new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/{policyName}"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String policyName = request.param("policyName", "");
        Intrinsics.checkNotNull((Object)policyName);
        return ((CharSequence)policyName).length() == 0 ? this.getAllPolicies(request, client) : this.getSMPolicyByName(client, policyName);
    }

    private final BaseRestHandler.RestChannelConsumer getSMPolicyByName(NodeClient client, String policyName) {
        return arg_0 -> RestGetSMPolicyHandler.getSMPolicyByName$lambda$0(client, policyName, arg_0);
    }

    private final BaseRestHandler.RestChannelConsumer getAllPolicies(RestRequest request, NodeClient client) {
        SearchParams searchParams = RestHandlerUtilsKt.getSearchParams(request, "sm_policy.name");
        return arg_0 -> RestGetSMPolicyHandler.getAllPolicies$lambda$1(client, searchParams, arg_0);
    }

    private static final void getSMPolicyByName$lambda$0(NodeClient $client, String $policyName, RestChannel it) {
        $client.execute(SMActions.INSTANCE.getGET_SM_POLICY_ACTION_TYPE(), (ActionRequest)new GetSMPolicyRequest(SMUtilsKt.smPolicyNameToDocId($policyName)), (ActionListener)new RestToXContentListener(it));
    }

    private static final void getAllPolicies$lambda$1(NodeClient $client, SearchParams $searchParams, RestChannel it) {
        $client.execute(SMActions.INSTANCE.getGET_SM_POLICIES_ACTION_TYPE(), (ActionRequest)new GetSMPoliciesRequest($searchParams), (ActionListener)new RestToXContentListener(it));
    }
}

