/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.transform.model;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.indices.stats.IndicesStatsAction;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.transform.TransformSearchService;
import org.opensearch.indexmanagement.transform.model.ContinuousTransformStats;
import org.opensearch.indexmanagement.transform.model.Transform;
import org.opensearch.indexmanagement.transform.model.TransformMetadata;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0086\b\u0018\u0000 ~2\u00020\u00012\u00020\u0002:\u0001~B\u00c1\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u0011\u001a\u00020\u0004\u0012\u0006\u0010\u0012\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0004\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017\u0012\b\b\u0002\u0010\u001c\u001a\u00020\u001d\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0004\b!\u0010\"B\u0011\b\u0016\u0012\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0004\b!\u0010%J\b\u0010E\u001a\u00020\u0004H\u0016J\b\u0010F\u001a\u00020\nH\u0016J\b\u0010G\u001a\u00020\rH\u0016J\n\u0010H\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010I\u001a\u00020\u000fH\u0016J\r\u0010J\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010KJ\u0018\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020PH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TH\u0016J&\u0010U\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010W0V2\u0006\u0010X\u001a\u00020\u00062\b\b\u0002\u0010Y\u001a\u00020\u000fJ \u0010Z\u001a\u0004\u0018\u00010[2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0086@\u00a2\u0006\u0002\u0010`J@\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060V2\u0014\u0010b\u001a\u0010\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\u0006\u0018\u00010c2\u0014\u0010e\u001a\u0010\u0012\u0004\u0012\u00020d\u0012\u0004\u0012\u00020\u0006\u0018\u00010cH\u0002J\t\u0010f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010g\u001a\u00020\u0006H\u00c6\u0003J\t\u0010h\u001a\u00020\u0006H\u00c6\u0003J\t\u0010i\u001a\u00020\u0006H\u00c6\u0003J\t\u0010j\u001a\u00020\nH\u00c6\u0003J\u000b\u0010k\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010l\u001a\u00020\rH\u00c6\u0003J\t\u0010m\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010n\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010o\u001a\u00020\u0004H\u00c6\u0003J\t\u0010p\u001a\u00020\u0004H\u00c6\u0003J\t\u0010q\u001a\u00020\u0014H\u00c6\u0003J\t\u0010r\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u00c6\u0003J\t\u0010t\u001a\u00020\u0019H\u00c6\u0003J\u000f\u0010u\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017H\u00c6\u0003J\t\u0010v\u001a\u00020\u001dH\u00c6\u0003J\t\u0010w\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010x\u001a\u0004\u0018\u00010 H\u00c6\u0003J\u00d9\u0001\u0010y\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00042\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u00c6\u0001J\u0013\u0010z\u001a\u00020\u000f2\b\u0010{\u001a\u0004\u0018\u00010WH\u00d6\u0003J\t\u0010|\u001a\u00020\u0019H\u00d6\u0001J\t\u0010}\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010)R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010'R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00100R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010'R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010'R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010'R\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010<R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00102R\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006\u007f"}, d2={"Lorg/opensearch/indexmanagement/transform/model/Transform;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "Lorg/opensearch/core/common/io/stream/Writeable;", "id", "", "seqNo", "", "primaryTerm", "schemaVersion", "jobSchedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "metadataId", "updatedAt", "Ljava/time/Instant;", "enabled", "", "enabledAt", "description", "sourceIndex", "dataSelectionQuery", "Lorg/opensearch/index/query/QueryBuilder;", "targetIndex", "roles", "", "pageSize", "", "groups", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "aggregations", "Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;", "continuous", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Ljava/lang/String;JJJLorg/opensearch/jobscheduler/spi/schedule/Schedule;Ljava/lang/String;Ljava/time/Instant;ZLjava/time/Instant;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/index/query/QueryBuilder;Ljava/lang/String;Ljava/util/List;ILjava/util/List;Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;ZLorg/opensearch/commons/authuser/User;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getSeqNo", "()J", "getPrimaryTerm", "getSchemaVersion", "getJobSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "getMetadataId", "getUpdatedAt", "()Ljava/time/Instant;", "getEnabled", "()Z", "getEnabledAt", "getDescription", "getSourceIndex", "getDataSelectionQuery", "()Lorg/opensearch/index/query/QueryBuilder;", "getTargetIndex", "getRoles$annotations", "()V", "getRoles", "()Ljava/util/List;", "getPageSize", "()I", "getGroups", "getAggregations", "()Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;", "getContinuous", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getName", "getSchedule", "getLastUpdateTime", "getEnabledTime", "isEnabled", "getLockDurationSeconds", "()Ljava/lang/Long;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "convertToDoc", "", "", "docCount", "includeId", "getContinuousStats", "Lorg/opensearch/indexmanagement/transform/model/ContinuousTransformStats;", "client", "Lorg/opensearch/transport/client/Client;", "metadata", "Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDocumentsBehind", "oldShardIDsToGlobalCheckpoint", "", "Lorg/opensearch/core/index/shard/ShardId;", "newShardIDsToGlobalCheckpoint", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "copy", "equals", "other", "hashCode", "toString", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transform.kt\norg/opensearch/indexmanagement/transform/model/Transform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,447:1\n1869#2:448\n1870#2:450\n1869#2,2:451\n1#3:449\n37#4:453\n36#4,3:454\n37#4:457\n36#4,3:458\n216#5,2:461\n*S KotlinDebug\n*F\n+ 1 Transform.kt\norg/opensearch/indexmanagement/transform/model/Transform\n*L\n77#1:448\n77#1:450\n80#1:451,2\n128#1:453\n128#1:454,3\n156#1:457\n156#1:458,3\n212#1:461,2\n*E\n"})
public final class Transform
implements ScheduledJobParameter,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final long schemaVersion;
    @NotNull
    private final Schedule jobSchedule;
    @Nullable
    private final String metadataId;
    @NotNull
    private final Instant updatedAt;
    private final boolean enabled;
    @Nullable
    private final Instant enabledAt;
    @NotNull
    private final String description;
    @NotNull
    private final String sourceIndex;
    @NotNull
    private final QueryBuilder dataSelectionQuery;
    @NotNull
    private final String targetIndex;
    @NotNull
    private final List<String> roles;
    private final int pageSize;
    @NotNull
    private final List<Dimension> groups;
    @NotNull
    private final AggregatorFactories.Builder aggregations;
    private final boolean continuous;
    @Nullable
    private final User user;
    @NotNull
    private static final List<String> supportedAggregations;
    public static final long LOCK_DURATION_SECONDS = 1800L;
    @NotNull
    public static final String TRANSFORM_TYPE = "transform";
    @NotNull
    public static final String TRANSFORM_ID_FIELD = "transform_id";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String UPDATED_AT_FIELD = "updated_at";
    @NotNull
    public static final String ENABLED_AT_FIELD = "enabled_at";
    @NotNull
    public static final String SOURCE_INDEX_FIELD = "source_index";
    @NotNull
    public static final String TARGET_INDEX_FIELD = "target_index";
    @NotNull
    public static final String DESCRIPTION_FIELD = "description";
    @NotNull
    public static final String DATA_SELECTION_QUERY_FIELD = "data_selection_query";
    @NotNull
    public static final String METADATA_ID_FIELD = "metadata_id";
    @NotNull
    public static final String PAGE_SIZE_FIELD = "page_size";
    @NotNull
    public static final String ROLES_FIELD = "roles";
    @NotNull
    public static final String JOB_SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String GROUPS_FIELD = "groups";
    @NotNull
    public static final String AGGREGATIONS_FIELD = "aggregations";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int MAXIMUM_PAGE_SIZE = 10000;
    public static final int MAXIMUM_PAGE_SIZE_CONTINUOUS = 1000;
    public static final int MINIMUM_JOB_INTERVAL = 1;
    @NotNull
    public static final String TRANSFORM_DOC_ID_FIELD = "transform._id";
    @NotNull
    public static final String DOC_COUNT = "_doc_count";
    @NotNull
    public static final String TRANSFORM_DOC_COUNT_FIELD = "transform._doc_count";
    @NotNull
    public static final String CONTINUOUS_FIELD = "continuous";
    @NotNull
    public static final String USER_FIELD = "user";

    public Transform(@NotNull String id, long seqNo, long primaryTerm, long schemaVersion, @NotNull Schedule jobSchedule, @Nullable String metadataId, @NotNull Instant updatedAt, boolean enabled, @Nullable Instant enabledAt, @NotNull String description, @NotNull String sourceIndex, @NotNull QueryBuilder dataSelectionQuery, @NotNull String targetIndex, @NotNull List<String> roles, int pageSize, @NotNull List<? extends Dimension> groups, @NotNull AggregatorFactories.Builder aggregations, boolean continuous, @Nullable User user) {
        AggregationBuilder it;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)dataSelectionQuery, (String)"dataSelectionQuery");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(roles, (String)ROLES_FIELD);
        Intrinsics.checkNotNullParameter(groups, (String)GROUPS_FIELD);
        Intrinsics.checkNotNullParameter((Object)aggregations, (String)AGGREGATIONS_FIELD);
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.metadataId = metadataId;
        this.updatedAt = updatedAt;
        this.enabled = enabled;
        this.enabledAt = enabledAt;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.dataSelectionQuery = dataSelectionQuery;
        this.targetIndex = targetIndex;
        this.roles = roles;
        this.pageSize = pageSize;
        this.groups = groups;
        this.aggregations = aggregations;
        this.continuous = continuous;
        this.user = user;
        Collection collection = this.aggregations.getAggregatorFactories();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAggregatorFactories(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AggregationBuilder)element$iv;
            boolean bl = false;
            if (supportedAggregations.contains(it.getType())) continue;
            boolean $i$a$-require-Transform$1$22 = false;
            String $i$a$-require-Transform$1$22 = "Unsupported aggregation [" + it.getType() + "]";
            throw new IllegalArgumentException($i$a$-require-Transform$1$22.toString());
        }
        Collection collection2 = this.aggregations.getPipelineAggregatorFactories();
        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getPipelineAggregatorFactories(...)");
        $this$forEach$iv = collection2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PipelineAggregationBuilder)element$iv;
            boolean bl = false;
            if (supportedAggregations.contains(it.getType())) continue;
            boolean bl2 = false;
            String string = "Unsupported aggregation [" + it.getType() + "]";
            throw new IllegalArgumentException(string.toString());
        }
        Schedule schedule = this.jobSchedule;
        if (!(schedule instanceof CronSchedule) && schedule instanceof IntervalSchedule && !(((IntervalSchedule)this.jobSchedule).getInterval() >= 1)) {
            boolean bl = false;
            String string = "Transform job schedule interval must be greater than 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(!((Collection)this.groups).isEmpty())) {
            boolean $i$a$-require-Transform$82 = false;
            String $i$a$-require-Transform$82 = "Groupings are Empty";
            throw new IllegalArgumentException($i$a$-require-Transform$82.toString());
        }
        if (!(!Intrinsics.areEqual((Object)this.sourceIndex, (Object)this.targetIndex))) {
            boolean $i$a$-require-Transform$92 = false;
            String $i$a$-require-Transform$92 = "Source and target indices cannot be the same";
            throw new IllegalArgumentException($i$a$-require-Transform$92.toString());
        }
        if (this.continuous) {
            int n = this.pageSize;
            if (!(1 <= n ? n < 1001 : false)) {
                boolean $i$a$-require-Transform$102 = false;
                String $i$a$-require-Transform$102 = "Page size must be between 1 and 1,000";
                throw new IllegalArgumentException($i$a$-require-Transform$102.toString());
            }
        } else {
            int n = this.pageSize;
            if (!(1 <= n ? n < 10001 : false)) {
                boolean bl = false;
                String string = "Page size must be between 1 and 10,000";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Transform(String string, long l, long l2, long l3, Schedule schedule, String string2, Instant instant, boolean bl, Instant instant2, String string3, String string4, QueryBuilder queryBuilder, String string5, List list, int n, List list2, AggregatorFactories.Builder builder, boolean bl2, User user, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            l = -2L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 0x800) != 0) {
            queryBuilder = (QueryBuilder)new MatchAllQueryBuilder();
        }
        if ((n2 & 0x2000) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x10000) != 0) {
            AggregatorFactories.Builder builder2 = AggregatorFactories.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder(...)");
            builder = builder2;
        }
        if ((n2 & 0x20000) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40000) != 0) {
            user = null;
        }
        this(string, l, l2, l3, schedule, string2, instant, bl, instant2, string3, string4, queryBuilder, string5, list, n, list2, builder, bl2, user);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public final long getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    @Nullable
    public final String getMetadataId() {
        return this.metadataId;
    }

    @NotNull
    public final Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @Nullable
    public final Instant getEnabledAt() {
        return this.enabledAt;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getSourceIndex() {
        return this.sourceIndex;
    }

    @NotNull
    public final QueryBuilder getDataSelectionQuery() {
        return this.dataSelectionQuery;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    @NotNull
    public final List<String> getRoles() {
        return this.roles;
    }

    @Deprecated(message="Will be ignored, to check the roles use user field")
    public static /* synthetic */ void getRoles$annotations() {
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> getGroups() {
        return this.groups;
    }

    @NotNull
    public final AggregatorFactories.Builder getAggregations() {
        return this.aggregations;
    }

    public final boolean getContinuous() {
        return this.continuous;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    @NotNull
    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.updatedAt;
    }

    @Nullable
    public Instant getEnabledTime() {
        return this.enabledAt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public Long getLockDurationSeconds() {
        return 1800L;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(TRANSFORM_TYPE);
        }
        XContentBuilder xContentBuilder = builder.field(TRANSFORM_ID_FIELD, this.id).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(JOB_SCHEDULE_FIELD, (ToXContent)this.getSchedule()).field(METADATA_ID_FIELD, this.metadataId);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, UPDATED_AT_FIELD, this.updatedAt).field(ENABLED_FIELD, this.enabled);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"field(...)");
        Collection $this$toTypedArray$iv = this.groups;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        OpenSearchExtensionsKt.optionalTimeField(xContentBuilder2, ENABLED_AT_FIELD, this.enabledAt).field(DESCRIPTION_FIELD, this.description).field(SOURCE_INDEX_FIELD, this.sourceIndex).field(DATA_SELECTION_QUERY_FIELD, (ToXContent)this.dataSelectionQuery).field(TARGET_INDEX_FIELD, this.targetIndex).field(PAGE_SIZE_FIELD, this.pageSize).field(GROUPS_FIELD, (Object)thisCollection$iv.toArray(new Dimension[0])).field(AGGREGATIONS_FIELD, (ToXContent)this.aggregations).field(CONTINUOUS_FIELD, this.continuous);
        if (params.paramAsBoolean("with_user", true)) {
            OpenSearchExtensionsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeLong(this.schemaVersion);
            if (this.getSchedule() instanceof CronSchedule) {
                out.writeEnum((Enum)Companion.ScheduleType.CRON);
            } else {
                out.writeEnum((Enum)Companion.ScheduleType.INTERVAL);
            }
            this.getSchedule().writeTo(out);
            out.writeOptionalString(this.metadataId);
            out.writeInstant(this.updatedAt);
            out.writeBoolean(this.enabled);
            out.writeOptionalInstant(this.enabledAt);
            out.writeString(this.description);
            out.writeString(this.sourceIndex);
            out.writeOptionalNamedWriteable((NamedWriteable)this.dataSelectionQuery);
            out.writeString(this.targetIndex);
            Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            out.writeStringArray(thisCollection$iv.toArray(new String[0]));
            out.writeInt(this.pageSize);
            out.writeVInt(this.groups.size());
            for (Dimension group : this.groups) {
                out.writeEnum((Enum)group.getType());
                Dimension dimension = group;
                if (dimension instanceof DateHistogram) {
                    ((DateHistogram)group).writeTo(out);
                    continue;
                }
                if (dimension instanceof Terms) {
                    ((Terms)group).writeTo(out);
                    continue;
                }
                if (!(dimension instanceof Histogram)) continue;
                ((Histogram)group).writeTo(out);
            }
            out.writeOptionalWriteable((Writeable)this.aggregations);
            out.writeBoolean(this.continuous);
            out.writeBoolean(this.user != null);
            User user = this.user;
            if (user == null) break block5;
            user.writeTo(out);
        }
    }

    @NotNull
    public final Map<String, Object> convertToDoc(long docCount, boolean includeId) {
        Map map;
        if (includeId) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TRANSFORM_DOC_ID_FIELD, (Object)this.id), TuplesKt.to((Object)DOC_COUNT, (Object)docCount), TuplesKt.to((Object)TRANSFORM_DOC_COUNT_FIELD, (Object)docCount)};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        } else {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)DOC_COUNT, (Object)docCount), TuplesKt.to((Object)TRANSFORM_DOC_COUNT_FIELD, (Object)docCount)};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        }
        return map;
    }

    public static /* synthetic */ Map convertToDoc$default(Transform transform2, long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return transform2.convertToDoc(l, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getContinuousStats(@NotNull Client client, @NotNull TransformMetadata metadata, @NotNull Continuation<? super ContinuousTransformStats> $completion) {
        if (!($completion instanceof getContinuousStats.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ Transform this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getContinuousStats(null, null, (Continuation<? super ContinuousTransformStats>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_7 = new String[]{this.sourceIndex};
                indicesStatsRequest = ((IndicesStatsRequest)new IndicesStatsRequest().indices(var5_7)).clear();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)client);
                $continuation.L$1 = metadata;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)indicesStatsRequest);
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)client, (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getContinuousStats$lambda$9(org.opensearch.action.admin.indices.stats.IndicesStatsRequest org.opensearch.transport.client.Client org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/Client;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndicesStatsRequest)indicesStatsRequest), $continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                indicesStatsRequest = (IndicesStatsRequest)$continuation.L$2;
                metadata = (TransformMetadata)$continuation.L$1;
                client = (Client)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                if ((response = (IndicesStatsResponse)v0).getStatus() != RestStatus.OK) {
                    return null;
                }
                shardIDsToGlobalCheckpoint = TransformSearchService.Companion.convertIndicesStatsResponse(response);
                v1 = metadata.getContinuousStats();
                return new ContinuousTransformStats(v1 != null ? v1.getLastTimestamp() : null, this.getDocumentsBehind(metadata.getShardIDToGlobalCheckpoint(), shardIDsToGlobalCheckpoint));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Map<String, Long> getDocumentsBehind(Map<ShardId, Long> oldShardIDsToGlobalCheckpoint, Map<ShardId, Long> newShardIDsToGlobalCheckpoint) {
        Map documentsBehind = new HashMap();
        if (newShardIDsToGlobalCheckpoint == null) {
            return documentsBehind;
        }
        Map<ShardId, Long> $this$forEach$iv = newShardIDsToGlobalCheckpoint;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ShardId, Long>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ShardId, Long> element$iv;
            Map.Entry<ShardId, Long> entry = element$iv = iterator.next();
            boolean bl = false;
            ShardId shardID = entry.getKey();
            long globalCheckpoint = ((Number)entry.getValue()).longValue();
            String indexName = shardID.getIndexName();
            long newGlobalCheckpoint = Long.max(0L, globalCheckpoint);
            Map<ShardId, Long> map = oldShardIDsToGlobalCheckpoint;
            long oldGlobalCheckpoint = Long.max(0L, map != null && (map = map.get(shardID)) != null ? (Long)((Object)map) : 0L);
            long localDocsBehind = newGlobalCheckpoint - oldGlobalCheckpoint;
            Map map2 = documentsBehind;
            Long l = (Long)documentsBehind.get(indexName);
            Long l2 = (l != null ? l : 0L) + localDocsBehind;
            map2.put(indexName, l2);
        }
        return documentsBehind;
    }

    /*
     * WARNING - void declaration
     */
    public Transform(@NotNull StreamInput sin) throws IOException {
        void it;
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        StreamInput streamInput = sin;
        long l = sin.readLong();
        long l2 = sin.readLong();
        long l3 = sin.readLong();
        String string2 = string;
        Transform transform2 = this;
        boolean bl = false;
        Enum enum_ = sin.readEnum(Companion.ScheduleType.class);
        if (enum_ == null) {
            boolean $i$a$-requireNotNull-Transform$8$22 = false;
            String $i$a$-requireNotNull-Transform$8$22 = "ScheduleType cannot be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-Transform$8$22.toString());
        }
        Schedule schedule = switch (WhenMappings.$EnumSwitchMapping$0[((Companion.ScheduleType)enum_).ordinal()]) {
            case 1 -> (Schedule)new CronSchedule(sin);
            case 2 -> (Schedule)new IntervalSchedule(sin);
            default -> throw new NoWhenBranchMatchedException();
        };
        Transform transform3 = transform2;
        String string3 = string2;
        long l4 = l3;
        long l5 = l2;
        long l6 = l;
        Schedule schedule2 = schedule;
        String string4 = sin.readOptionalString();
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        boolean bl2 = sin.readBoolean();
        Instant instant2 = sin.readOptionalInstant();
        String string5 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"readString(...)");
        String string6 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"readString(...)");
        NamedWriteable namedWriteable = sin.readOptionalNamedWriteable(QueryBuilder.class);
        if (namedWriteable == null) {
            String string7 = string6;
            String string8 = string5;
            Instant instant3 = instant2;
            boolean bl3 = bl2;
            Instant instant4 = instant;
            String string9 = string4;
            schedule = schedule2;
            l = l6;
            l2 = l5;
            l3 = l4;
            string2 = string3;
            transform2 = transform3;
            boolean $i$a$-requireNotNull-Transform$102 = false;
            String string10 = "Query cannot be null";
            Transform transform4 = transform2;
            String string11 = string2;
            long l7 = l3;
            long l8 = l2;
            long l9 = l;
            Schedule schedule3 = schedule;
            String string12 = string9;
            Instant instant5 = instant4;
            boolean bl4 = bl3;
            Instant instant6 = instant3;
            String string13 = string8;
            String string14 = string7;
            String $i$a$-requireNotNull-Transform$102 = string10;
            throw new IllegalArgumentException($i$a$-requireNotNull-Transform$102.toString());
        }
        QueryBuilder queryBuilder = (QueryBuilder)namedWriteable;
        String string15 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"readString(...)");
        String[] stringArray = sin.readStringArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"readStringArray(...)");
        StreamInput $i$a$-requireNotNull-Transform$102 = sin;
        int n = sin.readInt();
        List list = ArraysKt.toList((Object[])stringArray);
        String string16 = string15;
        QueryBuilder queryBuilder2 = queryBuilder;
        String string17 = string6;
        String string18 = string5;
        Instant instant7 = instant2;
        boolean bl5 = bl2;
        Instant instant8 = instant;
        String string19 = string4;
        schedule = schedule2;
        l = l6;
        l2 = l5;
        l3 = l4;
        string2 = string3;
        transform2 = transform3;
        boolean bl6 = false;
        List dimensionList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            boolean bl7 = false;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list2 = dimensionList;
            Dimension.Type type2 = type;
            if (type2 == null) {
                List list3 = list2;
                boolean bl8 = false;
                List list4 = list3;
                String string20 = "Dimension type cannot be null";
                throw new IllegalArgumentException(string20.toString());
            }
            list2.add(switch (WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1 -> new DateHistogram(sin);
                case 2 -> new Terms(sin);
                case 3 -> new Histogram(sin);
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        List list5 = CollectionsKt.toList((Iterable)dimensionList);
        Transform transform5 = transform2;
        String string21 = string2;
        long l10 = l3;
        long l11 = l2;
        long l12 = l;
        Schedule schedule4 = schedule;
        String string22 = string19;
        Instant instant9 = instant8;
        boolean bl9 = bl5;
        Instant instant10 = instant7;
        String string23 = string18;
        String string24 = string17;
        QueryBuilder queryBuilder3 = queryBuilder2;
        String string25 = string16;
        List list6 = list;
        int n2 = n;
        List list7 = list5;
        Writeable writeable = sin.readOptionalWriteable(Transform::_init_$lambda$17);
        if (writeable == null) {
            list5 = list7;
            n = n2;
            list = list6;
            string16 = string25;
            queryBuilder2 = queryBuilder3;
            string17 = string24;
            string18 = string23;
            instant7 = instant10;
            bl5 = bl9;
            instant8 = instant9;
            string19 = string22;
            schedule = schedule4;
            l = l12;
            l2 = l11;
            l3 = l10;
            string2 = string21;
            transform2 = transform5;
            boolean bl10 = false;
            String string26 = "Aggregations cannot be null";
            Transform transform6 = transform2;
            String string27 = string2;
            long l13 = l3;
            long l14 = l2;
            long l15 = l;
            Schedule schedule5 = schedule;
            String string28 = string19;
            Instant instant11 = instant8;
            boolean bl11 = bl5;
            Instant instant12 = instant7;
            String string29 = string18;
            String string30 = string17;
            QueryBuilder queryBuilder4 = queryBuilder2;
            String string31 = string16;
            List list8 = list;
            int n3 = n;
            List list9 = list5;
            String string32 = string26;
            throw new IllegalArgumentException(string32.toString());
        }
        transform5(string21, l10, l11, l12, schedule4, string22, instant9, bl9, instant10, string23, string24, queryBuilder3, string25, list6, n2, list7, (AggregatorFactories.Builder)writeable, sin.readBoolean(), sin.readBoolean() ? new User(sin) : null);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    public final long component4() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule component5() {
        return this.jobSchedule;
    }

    @Nullable
    public final String component6() {
        return this.metadataId;
    }

    @NotNull
    public final Instant component7() {
        return this.updatedAt;
    }

    public final boolean component8() {
        return this.enabled;
    }

    @Nullable
    public final Instant component9() {
        return this.enabledAt;
    }

    @NotNull
    public final String component10() {
        return this.description;
    }

    @NotNull
    public final String component11() {
        return this.sourceIndex;
    }

    @NotNull
    public final QueryBuilder component12() {
        return this.dataSelectionQuery;
    }

    @NotNull
    public final String component13() {
        return this.targetIndex;
    }

    @NotNull
    public final List<String> component14() {
        return this.roles;
    }

    public final int component15() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> component16() {
        return this.groups;
    }

    @NotNull
    public final AggregatorFactories.Builder component17() {
        return this.aggregations;
    }

    public final boolean component18() {
        return this.continuous;
    }

    @Nullable
    public final User component19() {
        return this.user;
    }

    @NotNull
    public final Transform copy(@NotNull String id, long seqNo, long primaryTerm, long schemaVersion, @NotNull Schedule jobSchedule, @Nullable String metadataId, @NotNull Instant updatedAt, boolean enabled, @Nullable Instant enabledAt, @NotNull String description, @NotNull String sourceIndex, @NotNull QueryBuilder dataSelectionQuery, @NotNull String targetIndex, @NotNull List<String> roles, int pageSize, @NotNull List<? extends Dimension> groups, @NotNull AggregatorFactories.Builder aggregations, boolean continuous, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)dataSelectionQuery, (String)"dataSelectionQuery");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(roles, (String)ROLES_FIELD);
        Intrinsics.checkNotNullParameter(groups, (String)GROUPS_FIELD);
        Intrinsics.checkNotNullParameter((Object)aggregations, (String)AGGREGATIONS_FIELD);
        return new Transform(id, seqNo, primaryTerm, schemaVersion, jobSchedule, metadataId, updatedAt, enabled, enabledAt, description, sourceIndex, dataSelectionQuery, targetIndex, roles, pageSize, groups, aggregations, continuous, user);
    }

    public static /* synthetic */ Transform copy$default(Transform transform2, String string, long l, long l2, long l3, Schedule schedule, String string2, Instant instant, boolean bl, Instant instant2, String string3, String string4, QueryBuilder queryBuilder, String string5, List list, int n, List list2, AggregatorFactories.Builder builder, boolean bl2, User user, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = transform2.id;
        }
        if ((n2 & 2) != 0) {
            l = transform2.seqNo;
        }
        if ((n2 & 4) != 0) {
            l2 = transform2.primaryTerm;
        }
        if ((n2 & 8) != 0) {
            l3 = transform2.schemaVersion;
        }
        if ((n2 & 0x10) != 0) {
            schedule = transform2.jobSchedule;
        }
        if ((n2 & 0x20) != 0) {
            string2 = transform2.metadataId;
        }
        if ((n2 & 0x40) != 0) {
            instant = transform2.updatedAt;
        }
        if ((n2 & 0x80) != 0) {
            bl = transform2.enabled;
        }
        if ((n2 & 0x100) != 0) {
            instant2 = transform2.enabledAt;
        }
        if ((n2 & 0x200) != 0) {
            string3 = transform2.description;
        }
        if ((n2 & 0x400) != 0) {
            string4 = transform2.sourceIndex;
        }
        if ((n2 & 0x800) != 0) {
            queryBuilder = transform2.dataSelectionQuery;
        }
        if ((n2 & 0x1000) != 0) {
            string5 = transform2.targetIndex;
        }
        if ((n2 & 0x2000) != 0) {
            list = transform2.roles;
        }
        if ((n2 & 0x4000) != 0) {
            n = transform2.pageSize;
        }
        if ((n2 & 0x8000) != 0) {
            list2 = transform2.groups;
        }
        if ((n2 & 0x10000) != 0) {
            builder = transform2.aggregations;
        }
        if ((n2 & 0x20000) != 0) {
            bl2 = transform2.continuous;
        }
        if ((n2 & 0x40000) != 0) {
            user = transform2.user;
        }
        return transform2.copy(string, l, l2, l3, schedule, string2, instant, bl, instant2, string3, string4, queryBuilder, string5, list, n, list2, builder, bl2, user);
    }

    @NotNull
    public String toString() {
        return "Transform(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", schemaVersion=" + this.schemaVersion + ", jobSchedule=" + this.jobSchedule + ", metadataId=" + this.metadataId + ", updatedAt=" + this.updatedAt + ", enabled=" + this.enabled + ", enabledAt=" + this.enabledAt + ", description=" + this.description + ", sourceIndex=" + this.sourceIndex + ", dataSelectionQuery=" + this.dataSelectionQuery + ", targetIndex=" + this.targetIndex + ", roles=" + this.roles + ", pageSize=" + this.pageSize + ", groups=" + this.groups + ", aggregations=" + this.aggregations + ", continuous=" + this.continuous + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + Long.hashCode(this.schemaVersion);
        result2 = result2 * 31 + this.jobSchedule.hashCode();
        result2 = result2 * 31 + (this.metadataId == null ? 0 : this.metadataId.hashCode());
        result2 = result2 * 31 + this.updatedAt.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        result2 = result2 * 31 + (this.enabledAt == null ? 0 : this.enabledAt.hashCode());
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + this.sourceIndex.hashCode();
        result2 = result2 * 31 + this.dataSelectionQuery.hashCode();
        result2 = result2 * 31 + this.targetIndex.hashCode();
        result2 = result2 * 31 + ((Object)this.roles).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + ((Object)this.groups).hashCode();
        result2 = result2 * 31 + this.aggregations.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.continuous);
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Transform)) {
            return false;
        }
        Transform transform2 = (Transform)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)transform2.id)) {
            return false;
        }
        if (this.seqNo != transform2.seqNo) {
            return false;
        }
        if (this.primaryTerm != transform2.primaryTerm) {
            return false;
        }
        if (this.schemaVersion != transform2.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobSchedule, (Object)transform2.jobSchedule)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadataId, (Object)transform2.metadataId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.updatedAt, (Object)transform2.updatedAt)) {
            return false;
        }
        if (this.enabled != transform2.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enabledAt, (Object)transform2.enabledAt)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)transform2.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceIndex, (Object)transform2.sourceIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dataSelectionQuery, (Object)transform2.dataSelectionQuery)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndex, (Object)transform2.targetIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.roles, transform2.roles)) {
            return false;
        }
        if (this.pageSize != transform2.pageSize) {
            return false;
        }
        if (!Intrinsics.areEqual(this.groups, transform2.groups)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.aggregations, (Object)transform2.aggregations)) {
            return false;
        }
        if (this.continuous != transform2.continuous) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)transform2.user);
    }

    private static final Unit getContinuousStats$lambda$9(IndicesStatsRequest $indicesStatsRequest, Client $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.execute((ActionType)IndicesStatsAction.INSTANCE, (ActionRequest)$indicesStatsRequest, it);
        return Unit.INSTANCE;
    }

    private static final AggregatorFactories.Builder _init_$lambda$17(StreamInput it) {
        return new AggregatorFactories.Builder(it);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Transform parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) {
        return Companion.parse(xcp, id, seqNo, primaryTerm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Transform parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) {
        return Companion.parse(xcp, id, seqNo);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Transform parse(@NotNull XContentParser xcp, @NotNull String id) {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Transform parse(@NotNull XContentParser xcp) {
        return Companion.parse(xcp);
    }

    static {
        Object[] objectArray = new String[]{"sum", "max", "min", "value_count", "avg", "scripted_metric", "percentiles"};
        supportedAggregations = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001,B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020\u00062\b\b\u0002\u0010*\u001a\u00020\n2\b\b\u0002\u0010+\u001a\u00020\nH\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001cX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/opensearch/indexmanagement/transform/model/Transform$Companion;", "", "<init>", "()V", "supportedAggregations", "", "", "getSupportedAggregations", "()Ljava/util/List;", "LOCK_DURATION_SECONDS", "", "TRANSFORM_TYPE", "TRANSFORM_ID_FIELD", "ENABLED_FIELD", "UPDATED_AT_FIELD", "ENABLED_AT_FIELD", "SOURCE_INDEX_FIELD", "TARGET_INDEX_FIELD", "DESCRIPTION_FIELD", "DATA_SELECTION_QUERY_FIELD", "METADATA_ID_FIELD", "PAGE_SIZE_FIELD", "ROLES_FIELD", "JOB_SCHEDULE_FIELD", "GROUPS_FIELD", "AGGREGATIONS_FIELD", "SCHEMA_VERSION_FIELD", "MINIMUM_PAGE_SIZE", "", "MAXIMUM_PAGE_SIZE", "MAXIMUM_PAGE_SIZE_CONTINUOUS", "MINIMUM_JOB_INTERVAL", "TRANSFORM_DOC_ID_FIELD", "DOC_COUNT", "TRANSFORM_DOC_COUNT_FIELD", "CONTINUOUS_FIELD", "USER_FIELD", "parse", "Lorg/opensearch/indexmanagement/transform/model/Transform;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "primaryTerm", "ScheduleType", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Transform.kt\norg/opensearch/indexmanagement/transform/model/Transform$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,447:1\n1#2:448\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getSupportedAggregations() {
            return supportedAggregations;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Transform parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Schedule schedule = null;
            long schemaVersion = 1L;
            Instant updatedAt = null;
            Instant enabledAt = null;
            boolean enabled = true;
            String description = null;
            String sourceIndex = null;
            QueryBuilder dataSelectionQuery = (QueryBuilder)new MatchAllQueryBuilder();
            String targetIndex = null;
            String metadataId = null;
            Integer pageSize = null;
            List groups = new ArrayList();
            AggregatorFactories.Builder aggregations = null;
            AggregatorFactories.Builder builder = AggregatorFactories.builder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
            aggregations = builder;
            boolean continuous = false;
            User user = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Transforms.");
                int n = -1;
                switch (string.hashCode()) {
                    case -207303516: {
                        if (string.equals(Transform.TARGET_INDEX_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 108695229: {
                        if (string.equals(Transform.ROLES_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (string.equals(Transform.DESCRIPTION_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case -1237460524: {
                        if (string.equals(Transform.GROUPS_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 1661088686: {
                        if (string.equals(Transform.SOURCE_INDEX_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 1893700081: {
                        if (string.equals(Transform.ENABLED_AT_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case -1609594047: {
                        if (string.equals(Transform.ENABLED_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case 1684719674: {
                        if (string.equals(Transform.SCHEMA_VERSION_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                    case -697920873: {
                        if (string.equals(Transform.JOB_SCHEDULE_FIELD)) {
                            n = 9;
                        }
                        break;
                    }
                    case 1723024832: {
                        if (string.equals(Transform.DATA_SELECTION_QUERY_FIELD)) {
                            n = 10;
                        }
                        break;
                    }
                    case -295464393: {
                        if (string.equals(Transform.UPDATED_AT_FIELD)) {
                            n = 11;
                        }
                        break;
                    }
                    case -1856487730: {
                        if (string.equals(Transform.TRANSFORM_ID_FIELD)) {
                            n = 12;
                        }
                        break;
                    }
                    case 379114255: {
                        if (string.equals(Transform.CONTINUOUS_FIELD)) {
                            n = 13;
                        }
                        break;
                    }
                    case -1481411541: {
                        if (string.equals(Transform.METADATA_ID_FIELD)) {
                            n = 14;
                        }
                        break;
                    }
                    case 317470161: {
                        if (string.equals(Transform.AGGREGATIONS_FIELD)) {
                            n = 15;
                        }
                        break;
                    }
                    case 3599307: {
                        if (string.equals(Transform.USER_FIELD)) {
                            n = 16;
                        }
                        break;
                    }
                    case 883849137: {
                        if (string.equals(Transform.PAGE_SIZE_FIELD)) {
                            n = 17;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 12: {
                        String string2 = xcp.text();
                        if (string2 != null) break;
                        boolean $i$a$-requireNotNull-Transform$Companion$parse$22 = false;
                        String $i$a$-requireNotNull-Transform$Companion$parse$22 = "The transform_id field is null";
                        throw new IllegalArgumentException($i$a$-requireNotNull-Transform$Companion$parse$22.toString());
                    }
                    case 9: {
                        schedule = ScheduleParser.parse((XContentParser)xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 8: {
                        schemaVersion = xcp.longValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 11: {
                        updatedAt = OpenSearchExtensionsKt.instant(xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 6: {
                        enabledAt = OpenSearchExtensionsKt.instant(xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 7: {
                        enabled = xcp.booleanValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 3: {
                        description = xcp.text();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 5: {
                        sourceIndex = xcp.text();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 10: {
                        NamedXContentRegistry registry = xcp.getXContentRegistry();
                        Map source = xcp.mapOrdered();
                        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
                        XContentParser sourceParser = XContentType.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)BytesReference.bytes((XContentBuilder)xContentBuilder).streamInput());
                        Intrinsics.checkNotNullExpressionValue((Object)AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)sourceParser), (String)"parseInnerQueryBuilder(...)");
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 1: {
                        targetIndex = xcp.text();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 14: {
                        metadataId = xcp.textOrNull();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 2: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            xcp.text();
                        }
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 17: {
                        pageSize = xcp.intValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 4: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            groups.add(Dimension.Companion.parse(xcp));
                        }
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 15: {
                        String string2;
                        if (AggregatorFactories.parseAggregators((XContentParser)xcp) != null) {
                            AggregatorFactories.Builder it;
                            boolean bl = false;
                            aggregations = it;
                            string2 = Unit.INSTANCE;
                            break;
                        }
                        string2 = null;
                        break;
                    }
                    case 13: {
                        continuous = xcp.booleanValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 16: {
                        user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Transforms.");
                    }
                }
            }
            if (enabled && enabledAt == null) {
                enabledAt = Instant.now();
            } else if (!enabled) {
                enabledAt = null;
            }
            if (seqNo == -2L || primaryTerm == 0L) {
                if (schedule instanceof IntervalSchedule) {
                    Instant instant = ((IntervalSchedule)schedule).getStartTime();
                    if (instant == null) {
                        instant = Instant.now();
                    }
                    schedule = (Schedule)new IntervalSchedule(instant, ((IntervalSchedule)schedule).getInterval(), ((IntervalSchedule)schedule).getUnit());
                }
                metadataId = null;
            }
            String string = id;
            long l = seqNo;
            long l2 = primaryTerm;
            long l3 = schemaVersion;
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                long l4 = l3;
                long l5 = l2;
                long l6 = l;
                String string3 = string;
                boolean $i$a$-requireNotNull-Transform$Companion$parse$82 = false;
                String string4 = "Transform schedule is null";
                String string5 = string3;
                long l7 = l6;
                long l8 = l5;
                long l9 = l4;
                String $i$a$-requireNotNull-Transform$Companion$parse$82 = string4;
                throw new IllegalArgumentException($i$a$-requireNotNull-Transform$Companion$parse$82.toString());
            }
            String string6 = metadataId;
            Instant instant = updatedAt;
            if (instant == null) {
                instant = Instant.now();
            }
            Instant $i$a$-requireNotNull-Transform$Companion$parse$82 = instant;
            Intrinsics.checkNotNull((Object)$i$a$-requireNotNull-Transform$Companion$parse$82);
            Instant instant2 = $i$a$-requireNotNull-Transform$Companion$parse$82;
            boolean bl = enabled;
            Instant instant3 = enabledAt;
            String string7 = description;
            if (string7 == null) {
                Instant instant4 = instant3;
                boolean bl2 = bl;
                Instant instant5 = instant2;
                String string8 = string6;
                Schedule schedule3 = schedule2;
                long l10 = l3;
                long l11 = l2;
                long l12 = l;
                String string9 = string;
                boolean $i$a$-requireNotNull-Transform$Companion$parse$92 = false;
                String string10 = "Transform description is null";
                String string11 = string9;
                long l13 = l12;
                long l14 = l11;
                long l15 = l10;
                Schedule schedule4 = schedule3;
                String string12 = string8;
                Instant instant6 = instant5;
                boolean bl3 = bl2;
                Instant instant7 = instant4;
                String $i$a$-requireNotNull-Transform$Companion$parse$92 = string10;
                throw new IllegalArgumentException($i$a$-requireNotNull-Transform$Companion$parse$92.toString());
            }
            String string13 = sourceIndex;
            if (string13 == null) {
                String string14 = string7;
                Instant instant8 = instant3;
                boolean bl4 = bl;
                Instant instant9 = instant2;
                String string15 = string6;
                Schedule schedule5 = schedule2;
                long l16 = l3;
                long l17 = l2;
                long l18 = l;
                String string16 = string;
                boolean $i$a$-requireNotNull-Transform$Companion$parse$102 = false;
                String string17 = "Transform source index is null";
                String string18 = string16;
                long l19 = l18;
                long l20 = l17;
                long l21 = l16;
                Schedule schedule6 = schedule5;
                String string19 = string15;
                Instant instant10 = instant9;
                boolean bl5 = bl4;
                Instant instant11 = instant8;
                String string20 = string14;
                String $i$a$-requireNotNull-Transform$Companion$parse$102 = string17;
                throw new IllegalArgumentException($i$a$-requireNotNull-Transform$Companion$parse$102.toString());
            }
            QueryBuilder queryBuilder = dataSelectionQuery;
            String string21 = targetIndex;
            if (string21 == null) {
                QueryBuilder queryBuilder2 = queryBuilder;
                String string22 = string13;
                String string23 = string7;
                Instant instant12 = instant3;
                boolean bl6 = bl;
                Instant instant13 = instant2;
                String string24 = string6;
                Schedule schedule7 = schedule2;
                long l22 = l3;
                long l23 = l2;
                long l24 = l;
                String string25 = string;
                boolean $i$a$-requireNotNull-Transform$Companion$parse$112 = false;
                String string26 = "Transform target index is null";
                String string27 = string25;
                long l25 = l24;
                long l26 = l23;
                long l27 = l22;
                Schedule schedule8 = schedule7;
                String string28 = string24;
                Instant instant14 = instant13;
                boolean bl7 = bl6;
                Instant instant15 = instant12;
                String string29 = string23;
                String string30 = string22;
                QueryBuilder queryBuilder3 = queryBuilder2;
                String $i$a$-requireNotNull-Transform$Companion$parse$112 = string26;
                throw new IllegalArgumentException($i$a$-requireNotNull-Transform$Companion$parse$112.toString());
            }
            Integer n = pageSize;
            if (n == null) {
                List list = null;
                String string31 = string21;
                QueryBuilder queryBuilder4 = queryBuilder;
                String string32 = string13;
                String string33 = string7;
                Instant instant16 = instant3;
                boolean bl8 = bl;
                Instant instant17 = instant2;
                String string34 = string6;
                Schedule schedule9 = schedule2;
                long l28 = l3;
                long l29 = l2;
                long l30 = l;
                String string35 = string;
                boolean bl9 = false;
                String string36 = "Transform page size is null";
                String string37 = string35;
                long l31 = l30;
                long l32 = l29;
                long l33 = l28;
                Schedule schedule10 = schedule9;
                String string38 = string34;
                Instant instant18 = instant17;
                boolean bl10 = bl8;
                Instant instant19 = instant16;
                String string39 = string33;
                String string40 = string32;
                QueryBuilder queryBuilder5 = queryBuilder4;
                String string41 = string31;
                List list2 = list;
                String string42 = string36;
                throw new IllegalArgumentException(string42.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 8192;
            User user2 = user;
            boolean bl11 = continuous;
            AggregatorFactories.Builder builder2 = aggregations;
            List list = groups;
            int n3 = ((Number)n).intValue();
            List list3 = null;
            String string43 = string21;
            QueryBuilder queryBuilder6 = queryBuilder;
            String string44 = string13;
            String string45 = string7;
            Instant instant20 = instant3;
            boolean bl12 = bl;
            Instant instant21 = instant2;
            String string46 = string6;
            Schedule schedule11 = schedule2;
            long l34 = l3;
            long l35 = l2;
            long l36 = l;
            String string47 = string;
            return new Transform(string47, l36, l35, l34, schedule11, string46, instant21, bl12, instant20, string45, string44, queryBuilder6, string43, list3, n3, list, builder2, bl11, user2, n2, defaultConstructorMarker);
        }

        public static /* synthetic */ Transform parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Transform parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.indexmanagement.transform.model.Transform$Companion.parse$default(this, xcp, id, seqNo, 0L, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Transform parse(@NotNull XContentParser xcp, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.indexmanagement.transform.model.Transform$Companion.parse$default(this, xcp, id, 0L, 0L, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Transform parse(@NotNull XContentParser xcp) {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.indexmanagement.transform.model.Transform$Companion.parse$default(this, xcp, null, 0L, 0L, 14, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/transform/model/Transform$Companion$ScheduleType;", "", "<init>", "(Ljava/lang/String;I)V", "CRON", "INTERVAL", "opensearch-index-management"})
        public static final class ScheduleType
        extends Enum<ScheduleType> {
            public static final /* enum */ ScheduleType CRON = new ScheduleType();
            public static final /* enum */ ScheduleType INTERVAL = new ScheduleType();
            private static final /* synthetic */ ScheduleType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ScheduleType[] values() {
                return (ScheduleType[])$VALUES.clone();
            }

            public static ScheduleType valueOf(String value) {
                return Enum.valueOf(ScheduleType.class, value);
            }

            @NotNull
            public static EnumEntries<ScheduleType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = scheduleTypeArray = new ScheduleType[]{ScheduleType.CRON, ScheduleType.INTERVAL};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Companion.ScheduleType.values().length];
            try {
                nArray[Companion.ScheduleType.CRON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.ScheduleType.INTERVAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Dimension.Type.values().length];
            try {
                nArray[Dimension.Type.DATE_HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.TERMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.HISTOGRAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

