/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.repackage.com.cronutils.model.time.generator;

import java.util.ArrayList;
import java.util.List;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.CronField;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.FieldExpression;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.field.expression.On;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.time.generator.FieldValueGenerator;
import org.opensearch.jobscheduler.repackage.com.cronutils.model.time.generator.NoSuchValueException;

class OnFieldValueGenerator
extends FieldValueGenerator {
    public OnFieldValueGenerator(CronField cronField) {
        super(cronField);
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int time = ((On)this.cronField.getExpression()).getTime().getValue();
        if (time <= reference) {
            throw new NoSuchValueException();
        }
        return time;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        int time = ((On)this.cronField.getExpression()).getTime().getValue();
        if (time >= reference) {
            throw new NoSuchValueException();
        }
        return time;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        int time = ((On)this.cronField.getExpression()).getTime().getValue();
        if (time > start && time < end) {
            values.add(time);
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        return ((On)this.cronField.getExpression()).getTime().getValue() == value;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof On;
    }
}

