/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableStatus;
import software.amazon.awssdk.services.dynamodb.model.ReplicaDescription;
import software.amazon.awssdk.services.dynamodb.model.ReplicaDescriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalTableDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalTableDescription> {
    private static final SdkField<List<ReplicaDescription>> REPLICATION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicationGroup").getter(GlobalTableDescription.getter(GlobalTableDescription::replicationGroup)).setter(GlobalTableDescription.setter(Builder::replicationGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationGroup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GLOBAL_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableArn").getter(GlobalTableDescription.getter(GlobalTableDescription::globalTableArn)).setter(GlobalTableDescription.setter(Builder::globalTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDateTime").getter(GlobalTableDescription.getter(GlobalTableDescription::creationDateTime)).setter(GlobalTableDescription.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()}).build();
    private static final SdkField<String> GLOBAL_TABLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableStatus").getter(GlobalTableDescription.getter(GlobalTableDescription::globalTableStatusAsString)).setter(GlobalTableDescription.setter(Builder::globalTableStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableStatus").build()}).build();
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableName").getter(GlobalTableDescription.getter(GlobalTableDescription::globalTableName)).setter(GlobalTableDescription.setter(Builder::globalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_GROUP_FIELD, GLOBAL_TABLE_ARN_FIELD, CREATION_DATE_TIME_FIELD, GLOBAL_TABLE_STATUS_FIELD, GLOBAL_TABLE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlobalTableDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ReplicaDescription> replicationGroup;
    private final String globalTableArn;
    private final Instant creationDateTime;
    private final String globalTableStatus;
    private final String globalTableName;

    private GlobalTableDescription(BuilderImpl builder) {
        this.replicationGroup = builder.replicationGroup;
        this.globalTableArn = builder.globalTableArn;
        this.creationDateTime = builder.creationDateTime;
        this.globalTableStatus = builder.globalTableStatus;
        this.globalTableName = builder.globalTableName;
    }

    public final boolean hasReplicationGroup() {
        return this.replicationGroup != null && !(this.replicationGroup instanceof SdkAutoConstructList);
    }

    public final List<ReplicaDescription> replicationGroup() {
        return this.replicationGroup;
    }

    public final String globalTableArn() {
        return this.globalTableArn;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final GlobalTableStatus globalTableStatus() {
        return GlobalTableStatus.fromValue(this.globalTableStatus);
    }

    public final String globalTableStatusAsString() {
        return this.globalTableStatus;
    }

    public final String globalTableName() {
        return this.globalTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationGroup() ? this.replicationGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalTableDescription)) {
            return false;
        }
        GlobalTableDescription other = (GlobalTableDescription)obj;
        return this.hasReplicationGroup() == other.hasReplicationGroup() && Objects.equals(this.replicationGroup(), other.replicationGroup()) && Objects.equals(this.globalTableArn(), other.globalTableArn()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.globalTableStatusAsString(), other.globalTableStatusAsString()) && Objects.equals(this.globalTableName(), other.globalTableName());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalTableDescription").add("ReplicationGroup", this.hasReplicationGroup() ? this.replicationGroup() : null).add("GlobalTableArn", (Object)this.globalTableArn()).add("CreationDateTime", (Object)this.creationDateTime()).add("GlobalTableStatus", (Object)this.globalTableStatusAsString()).add("GlobalTableName", (Object)this.globalTableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationGroup": {
                return Optional.ofNullable(clazz.cast(this.replicationGroup()));
            }
            case "GlobalTableArn": {
                return Optional.ofNullable(clazz.cast(this.globalTableArn()));
            }
            case "CreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "GlobalTableStatus": {
                return Optional.ofNullable(clazz.cast(this.globalTableStatusAsString()));
            }
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplicationGroup", REPLICATION_GROUP_FIELD);
        map.put("GlobalTableArn", GLOBAL_TABLE_ARN_FIELD);
        map.put("CreationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("GlobalTableStatus", GLOBAL_TABLE_STATUS_FIELD);
        map.put("GlobalTableName", GLOBAL_TABLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlobalTableDescription, T> g) {
        return obj -> g.apply((GlobalTableDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ReplicaDescription> replicationGroup = DefaultSdkAutoConstructList.getInstance();
        private String globalTableArn;
        private Instant creationDateTime;
        private String globalTableStatus;
        private String globalTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalTableDescription model) {
            this.replicationGroup(model.replicationGroup);
            this.globalTableArn(model.globalTableArn);
            this.creationDateTime(model.creationDateTime);
            this.globalTableStatus(model.globalTableStatus);
            this.globalTableName(model.globalTableName);
        }

        public final List<ReplicaDescription.Builder> getReplicationGroup() {
            List<ReplicaDescription.Builder> result = ReplicaDescriptionListCopier.copyToBuilder(this.replicationGroup);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationGroup(Collection<ReplicaDescription.BuilderImpl> replicationGroup) {
            this.replicationGroup = ReplicaDescriptionListCopier.copyFromBuilder(replicationGroup);
        }

        @Override
        public final Builder replicationGroup(Collection<ReplicaDescription> replicationGroup) {
            this.replicationGroup = ReplicaDescriptionListCopier.copy(replicationGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(ReplicaDescription ... replicationGroup) {
            this.replicationGroup(Arrays.asList(replicationGroup));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationGroup(Consumer<ReplicaDescription.Builder> ... replicationGroup) {
            this.replicationGroup(Stream.of(replicationGroup).map(c -> (ReplicaDescription)((ReplicaDescription.Builder)ReplicaDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGlobalTableArn() {
            return this.globalTableArn;
        }

        public final void setGlobalTableArn(String globalTableArn) {
            this.globalTableArn = globalTableArn;
        }

        @Override
        public final Builder globalTableArn(String globalTableArn) {
            this.globalTableArn = globalTableArn;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getGlobalTableStatus() {
            return this.globalTableStatus;
        }

        public final void setGlobalTableStatus(String globalTableStatus) {
            this.globalTableStatus = globalTableStatus;
        }

        @Override
        public final Builder globalTableStatus(String globalTableStatus) {
            this.globalTableStatus = globalTableStatus;
            return this;
        }

        @Override
        public final Builder globalTableStatus(GlobalTableStatus globalTableStatus) {
            this.globalTableStatus(globalTableStatus == null ? null : globalTableStatus.toString());
            return this;
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public GlobalTableDescription build() {
            return new GlobalTableDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalTableDescription> {
        public Builder replicationGroup(Collection<ReplicaDescription> var1);

        public Builder replicationGroup(ReplicaDescription ... var1);

        public Builder replicationGroup(Consumer<ReplicaDescription.Builder> ... var1);

        public Builder globalTableArn(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder globalTableStatus(String var1);

        public Builder globalTableStatus(GlobalTableStatus var1);

        public Builder globalTableName(String var1);
    }
}

