/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.hwnet;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.metrics_generator.linux.LinuxTCPMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.os.OSGlobals;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;

public class NetworkE2E {
    private static final Logger LOG = LogManager.getLogger(NetworkE2E.class);
    private static String pid = OSGlobals.getPid();
    private static Set<String> inodeSocketList = new HashSet<String>();
    private static Map<String, TCPFlowMetrics> inodeFlowMetricsMap = new HashMap<String, TCPFlowMetrics>();
    private static Map<String, destTCPFlowMetrics> destnodeFlowMetricsMap = new HashMap<String, destTCPFlowMetrics>();
    private static LinuxTCPMetricsGenerator linuxTCPMetricsHandler = new LinuxTCPMetricsGenerator();
    private static StringBuilder value = new StringBuilder();

    static void listSockets() {
        File self = new File("/proc/" + pid + "/fd");
        File[] filesList = self.listFiles();
        if (filesList == null) {
            return;
        }
        for (File f : filesList) {
            String target = null;
            try {
                Path targetp = Files.readSymbolicLink(Paths.get(f.getCanonicalPath(), new String[0]));
                target = targetp.toString();
            }
            catch (Exception e) {
                continue;
            }
            if (!target.contains("socket:")) continue;
            target = target.split("socket:\\[")[1];
            target = target.split("\\]")[0];
            inodeSocketList.add(target);
        }
    }

    private static void generateMap(String line, String ver) {
        String[] toks = line.trim().split("\\s+");
        if (!inodeSocketList.contains(toks[9])) {
            return;
        }
        TCPFlowMetrics m = new TCPFlowMetrics();
        m.destIP = toks[2].split(":")[0];
        m.txQueue = Long.decode("0x" + toks[4].split(":")[0]);
        m.rxQueue = Long.decode("0x" + toks[4].split(":")[1]);
        m.currentLost = Long.decode("0x" + toks[6]);
        if (toks.length > 16) {
            m.sendCWND = Long.parseLong(toks[15]);
            m.SSThresh = Long.parseLong(toks[16]);
        } else {
            m.sendCWND = -1L;
            m.SSThresh = -1L;
        }
        inodeFlowMetricsMap.put(toks[9], m);
    }

    private static void mapTCPMetrics(String ver) {
        int ln = 0;
        try (FileReader fileReader = new FileReader(new File(ver));
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (ln != 0) {
                    NetworkE2E.generateMap(line, ver);
                }
                ++ln;
            }
        }
        catch (Exception e) {
            LOG.debug("Error in mapTCPMetrics: {} with ExceptionCode: {}", new Supplier[]{() -> e, () -> StatExceptionCode.NETWORK_COLLECTION_ERROR.toString()});
            StatsCollector.instance().logException(StatExceptionCode.NETWORK_COLLECTION_ERROR);
        }
    }

    private static void mapTCPMetrics() {
        NetworkE2E.mapTCPMetrics("/proc/net/tcp");
        NetworkE2E.mapTCPMetrics("/proc/net/tcp6");
    }

    private static void clearAll() {
        inodeSocketList.clear();
        inodeFlowMetricsMap.clear();
        destnodeFlowMetricsMap.clear();
    }

    private static void computeSummary() {
        for (Map.Entry<String, TCPFlowMetrics> entry : inodeFlowMetricsMap.entrySet()) {
            TCPFlowMetrics m = entry.getValue();
            destTCPFlowMetrics exist = destnodeFlowMetricsMap.get(m.destIP);
            if (exist == null) {
                destnodeFlowMetricsMap.put(m.destIP, new destTCPFlowMetrics(m));
                continue;
            }
            ++exist.numFlows;
            exist.txQueueTot = exist.txQueueTot + (m.txQueue != -1L ? m.txQueue : 0L);
            exist.rxQueueTot = exist.rxQueueTot + (m.rxQueue != -1L ? m.rxQueue : 0L);
            exist.currentLostTot = exist.currentLostTot + (m.currentLost != -1L ? m.currentLost : 0L);
            exist.sendCWNDTot = exist.sendCWNDTot + (m.sendCWND != -1L ? m.sendCWND : 0L);
            exist.SSThreshTot = exist.SSThreshTot + (m.SSThresh != -1L ? m.SSThresh : 0L);
        }
        NetworkE2E.calculateTCPMetrics();
    }

    protected static void calculateTCPMetrics() {
        HashMap<String, double[]> localMap = new HashMap<String, double[]>();
        for (Map.Entry<String, destTCPFlowMetrics> entry : destnodeFlowMetricsMap.entrySet()) {
            destTCPFlowMetrics m = entry.getValue();
            double[] metrics = new double[]{m.numFlows, (double)m.txQueueTot * 1.0 / (double)m.numFlows, (double)m.rxQueueTot * 1.0 / (double)m.numFlows, (double)m.currentLostTot * 1.0 / (double)m.numFlows, (double)m.sendCWNDTot * 1.0 / (double)m.numFlows, (double)m.SSThreshTot * 1.0 / (double)m.numFlows};
            localMap.put(entry.getKey(), metrics);
        }
        linuxTCPMetricsHandler.setTCPMetrics(localMap);
    }

    public static LinuxTCPMetricsGenerator getTCPMetricsHandler() {
        return linuxTCPMetricsHandler;
    }

    public static void addSample() {
        NetworkE2E.clearAll();
        NetworkE2E.listSockets();
        NetworkE2E.mapTCPMetrics();
        NetworkE2E.computeSummary();
    }

    public static void runOnce() {
        NetworkE2E.clearAll();
        NetworkE2E.listSockets();
        NetworkE2E.mapTCPMetrics();
        NetworkE2E.computeSummary();
    }

    @VisibleForTesting
    protected static void setDestnodeFlowMetricsMap(Map<String, destTCPFlowMetrics> destnodeFlowMetricsMap) {
        NetworkE2E.destnodeFlowMetricsMap = destnodeFlowMetricsMap;
    }

    static class TCPFlowMetrics {
        String destIP;
        long txQueue;
        long rxQueue;
        long currentLost;
        long sendCWND;
        long SSThresh;

        TCPFlowMetrics() {
        }
    }

    static class destTCPFlowMetrics {
        long txQueueTot;
        long rxQueueTot;
        long currentLostTot;
        long sendCWNDTot;
        long SSThreshTot;
        int numFlows;

        destTCPFlowMetrics(TCPFlowMetrics m) {
            this.txQueueTot = m.txQueue;
            this.rxQueueTot = m.rxQueue;
            this.currentLostTot = m.currentLost;
            this.sendCWNDTot = m.sendCWND;
            this.SSThreshTot = m.SSThresh;
            this.numFlows = 1;
        }
    }
}

