/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Parser;
import org.jooq.impl.DSL;
import org.jooq.impl.ParsingStatement;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.jdbc.DefaultConnection;

final class ParsingConnection
extends DefaultConnection {
    private static final JooqLogger log = JooqLogger.getLogger(ParsingConnection.class);
    private final Configuration configuration;
    private final DSLContext ctx;
    private final Parser parser;

    ParsingConnection(Configuration configuration) {
        super(configuration.connectionProvider().acquire());
        this.configuration = configuration;
        this.ctx = DSL.using(configuration);
        this.parser = this.ctx.parser();
    }

    final String translate(String sql) {
        log.debug((Object)"Translating from", sql);
        String result = this.ctx.render(this.parser.parseQuery(sql));
        log.debug((Object)"Translating to", result);
        return result;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        return new ParsingStatement(this, this.getDelegate().createStatement());
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareStatement(this.translate(sql)));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareStatement(this.translate(sql), resultSetType, resultSetConcurrency));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareStatement(this.translate(sql), resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareStatement(this.translate(sql), autoGeneratedKeys));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareStatement(this.translate(sql), columnIndexes));
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareStatement(this.translate(sql), columnNames));
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareCall(this.translate(sql)));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ParsingStatement(this, this.getDelegate().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public final void close() throws SQLException {
        this.configuration.connectionProvider().release(this.getDelegate());
    }
}

