/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.lib.aggregate.DoubleValueSum;
import org.apache.hadoop.mapreduce.lib.aggregate.LongValueMax;
import org.apache.hadoop.mapreduce.lib.aggregate.LongValueMin;
import org.apache.hadoop.mapreduce.lib.aggregate.LongValueSum;
import org.apache.hadoop.mapreduce.lib.aggregate.StringValueMax;
import org.apache.hadoop.mapreduce.lib.aggregate.StringValueMin;
import org.apache.hadoop.mapreduce.lib.aggregate.UniqValueCount;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueHistogram;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorBaseDescriptor
implements ValueAggregatorDescriptor {
    public static final String UNIQ_VALUE_COUNT = "UniqValueCount";
    public static final String LONG_VALUE_SUM = "LongValueSum";
    public static final String DOUBLE_VALUE_SUM = "DoubleValueSum";
    public static final String VALUE_HISTOGRAM = "ValueHistogram";
    public static final String LONG_VALUE_MAX = "LongValueMax";
    public static final String LONG_VALUE_MIN = "LongValueMin";
    public static final String STRING_VALUE_MAX = "StringValueMax";
    public static final String STRING_VALUE_MIN = "StringValueMin";
    public String inputFile = null;

    public static Map.Entry<Text, Text> generateEntry(String type, String id, Text val) {
        Text key = new Text(type + ":" + id);
        return new MyEntry(key, val);
    }

    public static ValueAggregator generateValueAggregator(String type, long uniqCount) {
        if (type.compareToIgnoreCase(LONG_VALUE_SUM) == 0) {
            return new LongValueSum();
        }
        if (type.compareToIgnoreCase(LONG_VALUE_MAX) == 0) {
            return new LongValueMax();
        }
        if (type.compareToIgnoreCase(LONG_VALUE_MIN) == 0) {
            return new LongValueMin();
        }
        if (type.compareToIgnoreCase(STRING_VALUE_MAX) == 0) {
            return new StringValueMax();
        }
        if (type.compareToIgnoreCase(STRING_VALUE_MIN) == 0) {
            return new StringValueMin();
        }
        if (type.compareToIgnoreCase(DOUBLE_VALUE_SUM) == 0) {
            return new DoubleValueSum();
        }
        if (type.compareToIgnoreCase(UNIQ_VALUE_COUNT) == 0) {
            return new UniqValueCount(uniqCount);
        }
        if (type.compareToIgnoreCase(VALUE_HISTOGRAM) == 0) {
            return new ValueHistogram();
        }
        return null;
    }

    @Override
    public ArrayList<Map.Entry<Text, Text>> generateKeyValPairs(Object key, Object val) {
        ArrayList<Map.Entry<Text, Text>> retv = new ArrayList<Map.Entry<Text, Text>>();
        String countType = LONG_VALUE_SUM;
        String id = "record_count";
        Map.Entry<Text, Text> e = ValueAggregatorBaseDescriptor.generateEntry(countType, id, ONE);
        if (e != null) {
            retv.add(e);
        }
        if (this.inputFile != null && (e = ValueAggregatorBaseDescriptor.generateEntry(countType, this.inputFile, ONE)) != null) {
            retv.add(e);
        }
        return retv;
    }

    @Override
    public void configure(Configuration conf) {
        this.inputFile = conf.get("mapreduce.map.input.file");
    }

    private static class MyEntry
    implements Map.Entry<Text, Text> {
        Text key;
        Text val;

        @Override
        public Text getKey() {
            return this.key;
        }

        @Override
        public Text getValue() {
            return this.val;
        }

        @Override
        public Text setValue(Text val) {
            this.val = val;
            return val;
        }

        public MyEntry(Text key, Text val) {
            this.key = key;
            this.val = val;
        }
    }
}

