/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.audit.CommonAuditContext;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConfig;

@InterfaceAudience.Private
public final class AuditingIntegration {
    private AuditingIntegration() {
    }

    public static void updateCommonContextOnCommitterEntry(ManifestCommitterConfig committerConfig) {
        CommonAuditContext context = CommonAuditContext.currentAuditContext();
        context.put("ji", committerConfig.getJobUniqueId());
        if (!committerConfig.getTaskAttemptId().isEmpty()) {
            context.put("ta", committerConfig.getTaskAttemptId());
        }
    }

    public static void enterStage(String stage) {
        CommonAuditContext.currentAuditContext().put("st", stage);
    }

    public static void exitStage() {
        CommonAuditContext.currentAuditContext().remove("st");
    }

    public static void updateCommonContextOnCommitterExit() {
        CommonAuditContext.currentAuditContext().remove("ji");
        CommonAuditContext.currentAuditContext().remove("ta");
    }

    public static void enterStageWorker(String jobId, String stage) {
        CommonAuditContext context = CommonAuditContext.currentAuditContext();
        context.put("ji", jobId);
        context.put("st", stage);
    }
}

