/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.factory.providers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RpcClientFactory;
import org.apache.hadoop.yarn.factories.RpcServerFactory;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "YARN"})
public class RpcFactoryProvider {
    private RpcFactoryProvider() {
    }

    public static RpcServerFactory getServerFactory(Configuration conf) {
        if (conf == null) {
            conf = new Configuration();
        }
        String serverFactoryClassName = conf.get("yarn.ipc.server.factory.class", "org.apache.hadoop.yarn.factories.impl.pb.RpcServerFactoryPBImpl");
        return (RpcServerFactory)RpcFactoryProvider.getFactoryClassInstance(serverFactoryClassName);
    }

    public static RpcClientFactory getClientFactory(Configuration conf) {
        String clientFactoryClassName = conf.get("yarn.ipc.client.factory.class", "org.apache.hadoop.yarn.factories.impl.pb.RpcClientFactoryPBImpl");
        return (RpcClientFactory)RpcFactoryProvider.getFactoryClassInstance(clientFactoryClassName);
    }

    private static Object getFactoryClassInstance(String factoryClassName) {
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            Method method = clazz.getMethod("get", new Class[0]);
            method.setAccessible(true);
            return method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new YarnRuntimeException(e);
        }
    }
}

