/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class PubAckPacket {
    private PubAckReasonCode reasonCode;
    private String reasonString;
    private List<UserProperty> userProperties;

    public PubAckReasonCode getReasonCode() {
        return this.reasonCode;
    }

    public String getReasonString() {
        return this.reasonString;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    private PubAckPacket() {
    }

    private void nativeAddReasonCode(int reasonCode) {
        this.reasonCode = PubAckReasonCode.getEnumValueFromInteger(reasonCode);
    }

    public static enum PubAckReasonCode {
        SUCCESS(0),
        NO_MATCHING_SUBSCRIBERS(16),
        UNSPECIFIED_ERROR(128),
        IMPLEMENTATION_SPECIFIC_ERROR(131),
        NOT_AUTHORIZED(135),
        TOPIC_NAME_INVALID(144),
        PACKET_IDENTIFIER_IN_USE(145),
        QUOTA_EXCEEDED(151),
        PAYLOAD_FORMAT_INVALID(153);

        private int reasonCode;
        private static Map<Integer, PubAckReasonCode> enumMapping;

        private PubAckReasonCode(int code) {
            this.reasonCode = code;
        }

        public int getValue() {
            return this.reasonCode;
        }

        public static PubAckReasonCode getEnumValueFromInteger(int value) {
            PubAckReasonCode enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal PubAckReasonCode");
        }

        private static Map<Integer, PubAckReasonCode> buildEnumMapping() {
            return Stream.of(PubAckReasonCode.values()).collect(Collectors.toMap(PubAckReasonCode::getValue, Function.identity()));
        }

        static {
            enumMapping = PubAckReasonCode.buildEnumMapping();
        }
    }
}

