/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.signer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidityType {
    DAYS("DAYS"),
    MONTHS("MONTHS"),
    YEARS("YEARS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidityType> VALUE_MAP;
    private final String value;

    private ValidityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidityType> knownValues() {
        EnumSet<ValidityType> knownValues = EnumSet.allOf(ValidityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidityType.class, ValidityType::toString);
    }
}

