/*
 * Decompiled with CFR 0.152.
 */
package scala.compat.java8;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import scala.Int$;
import scala.MatchError;
import scala.compat.java8.DurationConverters$DurationOps$;
import scala.compat.java8.DurationConverters$FiniteDurationops$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.ModuleSerializationProxy;

public final class DurationConverters$
implements Serializable {
    public static final DurationConverters$DurationOps$ DurationOps;
    public static final DurationConverters$FiniteDurationops$ FiniteDurationops;
    public static final DurationConverters$ MODULE$;

    private DurationConverters$() {
    }

    static {
        MODULE$ = new DurationConverters$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DurationConverters$.class);
    }

    public final FiniteDuration toScala(Duration duration) {
        FiniteDuration finiteDuration;
        long originalSeconds = duration.getSeconds();
        int originalNanos = duration.getNano();
        if (originalNanos == 0) {
            finiteDuration = originalSeconds == 0L ? Duration$.MODULE$.Zero() : FiniteDuration$.MODULE$.apply(originalSeconds, TimeUnit.SECONDS);
        } else if (originalSeconds == 0L) {
            finiteDuration = FiniteDuration$.MODULE$.apply(Int$.MODULE$.int2long(originalNanos), TimeUnit.NANOSECONDS);
        } else {
            try {
                long secondsAsNanos = Math.multiplyExact(originalSeconds, 1000000000L);
                long totalNanos = secondsAsNanos + (long)originalNanos;
                if (!(totalNanos < 0L && secondsAsNanos < 0L || totalNanos > 0L && secondsAsNanos > 0L)) {
                    throw new ArithmeticException();
                }
                finiteDuration = FiniteDuration$.MODULE$.apply(totalNanos, TimeUnit.NANOSECONDS);
            }
            catch (ArithmeticException arithmeticException) {
                throw new IllegalArgumentException("Java duration " + duration + " cannot be expressed as a Scala duration");
            }
        }
        return finiteDuration;
    }

    public final Duration toJava(FiniteDuration duration) {
        Duration duration2;
        if (duration.length() == 0L) {
            duration2 = Duration.ZERO;
        } else {
            TimeUnit timeUnit = duration.unit();
            TimeUnit timeUnit2 = TimeUnit.NANOSECONDS;
            TimeUnit timeUnit3 = timeUnit;
            if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)timeUnit3) : timeUnit3 != null)) {
                duration2 = Duration.ofNanos(duration.length());
            } else {
                TimeUnit timeUnit4 = TimeUnit.MICROSECONDS;
                TimeUnit timeUnit5 = timeUnit;
                if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)timeUnit5) : timeUnit5 != null)) {
                    duration2 = Duration.of(duration.length(), ChronoUnit.MICROS);
                } else {
                    TimeUnit timeUnit6 = TimeUnit.MILLISECONDS;
                    TimeUnit timeUnit7 = timeUnit;
                    if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)timeUnit7) : timeUnit7 != null)) {
                        duration2 = Duration.ofMillis(duration.length());
                    } else {
                        TimeUnit timeUnit8 = TimeUnit.SECONDS;
                        TimeUnit timeUnit9 = timeUnit;
                        if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)timeUnit9) : timeUnit9 != null)) {
                            duration2 = Duration.ofSeconds(duration.length());
                        } else {
                            TimeUnit timeUnit10 = TimeUnit.MINUTES;
                            TimeUnit timeUnit11 = timeUnit;
                            if (!(timeUnit10 != null ? !((Object)((Object)timeUnit10)).equals((Object)timeUnit11) : timeUnit11 != null)) {
                                duration2 = Duration.ofMinutes(duration.length());
                            } else {
                                TimeUnit timeUnit12 = TimeUnit.HOURS;
                                TimeUnit timeUnit13 = timeUnit;
                                if (!(timeUnit12 != null ? !((Object)((Object)timeUnit12)).equals((Object)timeUnit13) : timeUnit13 != null)) {
                                    duration2 = Duration.ofHours(duration.length());
                                } else {
                                    TimeUnit timeUnit14 = TimeUnit.DAYS;
                                    TimeUnit timeUnit15 = timeUnit;
                                    if (!(timeUnit14 != null ? !((Object)((Object)timeUnit14)).equals((Object)timeUnit15) : timeUnit15 != null)) {
                                        duration2 = Duration.ofDays(duration.length());
                                    } else {
                                        throw new MatchError((Object)timeUnit);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return duration2;
    }

    public final Duration DurationOps(Duration duration) {
        return duration;
    }

    public final FiniteDuration FiniteDurationops(FiniteDuration duration) {
        return duration;
    }
}

