/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;

public final class FunctionSupport {
    private FunctionSupport() {
    }

    @Nonnull
    public static <T1, T2> Function<T1, T2> constant(@Nullable @ParameterName(name="target") T2 target) {
        return f -> target;
    }

    @Nonnull
    public static <A, B, C> Function<A, C> compose(@Nonnull @ParameterName(name="g") Function<? super B, ? extends C> g, @Nonnull @ParameterName(name="f") Function<A, ? extends B> f) {
        Function<A, ? extends C> result = f.andThen(g);
        assert (result != null);
        return result;
    }

    @Nonnull
    public static <T> Function<T, Boolean> forPredicate(@Nonnull @ParameterName(name="predicate") Predicate<T> predicate) {
        return predicate::test;
    }
}

