/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.MemoryRecords;

public class FetchResponseDataJsonConverter {
    public static FetchResponseData read(JsonNode _node, short _version) {
        FetchResponseData _object = new FetchResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            throw new RuntimeException("FetchResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
        }
        _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "FetchResponseData");
        JsonNode _errorCodeNode = _node.get("errorCode");
        if (_errorCodeNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("FetchResponseData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = 0;
        } else {
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "FetchResponseData");
        }
        JsonNode _sessionIdNode = _node.get("sessionId");
        if (_sessionIdNode == null) {
            if (_version >= 7) {
                throw new RuntimeException("FetchResponseData: unable to locate field 'sessionId', which is mandatory in version " + _version);
            }
            _object.sessionId = 0;
        } else {
            _object.sessionId = MessageUtil.jsonNodeToInt(_sessionIdNode, "FetchResponseData");
        }
        JsonNode _responsesNode = _node.get("responses");
        if (_responsesNode == null) {
            throw new RuntimeException("FetchResponseData: unable to locate field 'responses', which is mandatory in version " + _version);
        }
        if (!_responsesNode.isArray()) {
            throw new RuntimeException("FetchResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<FetchResponseData.FetchableTopicResponse> _collection = new ArrayList<FetchResponseData.FetchableTopicResponse>(_responsesNode.size());
        _object.responses = _collection;
        for (JsonNode _element : _responsesNode) {
            _collection.add(FetchableTopicResponseJsonConverter.read(_element, _version));
        }
        JsonNode _nodeEndpointsNode = _node.get("nodeEndpoints");
        if (_nodeEndpointsNode == null) {
            _object.nodeEndpoints = new FetchResponseData.NodeEndpointCollection(0);
        } else {
            FetchResponseData.NodeEndpointCollection _collection2;
            if (!_nodeEndpointsNode.isArray()) {
                throw new RuntimeException("FetchResponseData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.nodeEndpoints = _collection2 = new FetchResponseData.NodeEndpointCollection(_nodeEndpointsNode.size());
            for (JsonNode _element : _nodeEndpointsNode) {
                _collection2.add(NodeEndpointJsonConverter.read(_element, _version));
            }
        }
        return _object;
    }

    public static JsonNode write(FetchResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        if (_version >= 7) {
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
        }
        if (_version >= 7) {
            _node.set("sessionId", (JsonNode)new IntNode(_object.sessionId));
        } else if (_object.sessionId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionId at version " + _version);
        }
        ArrayNode _responsesArray = new ArrayNode(JsonNodeFactory.instance);
        for (FetchResponseData.FetchableTopicResponse _element : _object.responses) {
            _responsesArray.add(FetchableTopicResponseJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("responses", (JsonNode)_responsesArray);
        if (_version >= 16) {
            if (!_object.nodeEndpoints.isEmpty()) {
                ArrayNode _nodeEndpointsArray = new ArrayNode(JsonNodeFactory.instance);
                for (FetchResponseData.NodeEndpoint _element : _object.nodeEndpoints) {
                    _nodeEndpointsArray.add(NodeEndpointJsonConverter.write(_element, _version, _serializeRecords));
                }
                _node.set("nodeEndpoints", (JsonNode)_nodeEndpointsArray);
            }
        } else if (!_object.nodeEndpoints.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default nodeEndpoints at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(FetchResponseData _object, short _version) {
        return FetchResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class FetchableTopicResponseJsonConverter {
        public static FetchResponseData.FetchableTopicResponse read(JsonNode _node, short _version) {
            FetchResponseData.FetchableTopicResponse _object = new FetchResponseData.FetchableTopicResponse();
            JsonNode _topicNode = _node.get("topic");
            if (_topicNode == null) {
                if (_version <= 12) {
                    throw new RuntimeException("FetchableTopicResponse: unable to locate field 'topic', which is mandatory in version " + _version);
                }
                _object.topic = "";
            } else {
                if (!_topicNode.isTextual()) {
                    throw new RuntimeException("FetchableTopicResponse expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.topic = _topicNode.asText();
            }
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                if (_version >= 13) {
                    throw new RuntimeException("FetchableTopicResponse: unable to locate field 'topicId', which is mandatory in version " + _version);
                }
                _object.topicId = Uuid.ZERO_UUID;
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("FetchableTopicResponse expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("FetchableTopicResponse: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("FetchableTopicResponse expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<FetchResponseData.PartitionData> _collection = new ArrayList<FetchResponseData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(FetchResponseData.FetchableTopicResponse _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            if (_version <= 12) {
                _node.set("topic", (JsonNode)new TextNode(_object.topic));
            }
            if (_version >= 13) {
                _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            }
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (FetchResponseData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(FetchResponseData.FetchableTopicResponse _object, short _version) {
            return FetchableTopicResponseJsonConverter.write(_object, _version, true);
        }
    }

    public static class NodeEndpointJsonConverter {
        public static FetchResponseData.NodeEndpoint read(JsonNode _node, short _version) {
            FetchResponseData.NodeEndpoint _object = new FetchResponseData.NodeEndpoint();
            if (_version < 16) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of NodeEndpoint");
            }
            JsonNode _nodeIdNode = _node.get("nodeId");
            if (_nodeIdNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'nodeId', which is mandatory in version " + _version);
            }
            _object.nodeId = MessageUtil.jsonNodeToInt(_nodeIdNode, "NodeEndpoint");
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("NodeEndpoint expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.host = _hostNode.asText();
            JsonNode _portNode = _node.get("port");
            if (_portNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'port', which is mandatory in version " + _version);
            }
            _object.port = MessageUtil.jsonNodeToInt(_portNode, "NodeEndpoint");
            JsonNode _rackNode = _node.get("rack");
            if (_rackNode == null) {
                throw new RuntimeException("NodeEndpoint: unable to locate field 'rack', which is mandatory in version " + _version);
            }
            if (_rackNode.isNull()) {
                _object.rack = null;
            } else {
                if (!_rackNode.isTextual()) {
                    throw new RuntimeException("NodeEndpoint expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.rack = _rackNode.asText();
            }
            return _object;
        }

        public static JsonNode write(FetchResponseData.NodeEndpoint _object, short _version, boolean _serializeRecords) {
            if (_version < 16) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of NodeEndpoint");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("nodeId", (JsonNode)new IntNode(_object.nodeId));
            _node.set("host", (JsonNode)new TextNode(_object.host));
            _node.set("port", (JsonNode)new IntNode(_object.port));
            if (_object.rack == null) {
                _node.set("rack", (JsonNode)NullNode.instance);
            } else {
                _node.set("rack", (JsonNode)new TextNode(_object.rack));
            }
            return _node;
        }

        public static JsonNode write(FetchResponseData.NodeEndpoint _object, short _version) {
            return NodeEndpointJsonConverter.write(_object, _version, true);
        }
    }

    public static class SnapshotIdJsonConverter {
        public static FetchResponseData.SnapshotId read(JsonNode _node, short _version) {
            FetchResponseData.SnapshotId _object = new FetchResponseData.SnapshotId();
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SnapshotId");
            }
            JsonNode _endOffsetNode = _node.get("endOffset");
            if (_endOffsetNode == null) {
                throw new RuntimeException("SnapshotId: unable to locate field 'endOffset', which is mandatory in version " + _version);
            }
            _object.endOffset = MessageUtil.jsonNodeToLong(_endOffsetNode, "SnapshotId");
            JsonNode _epochNode = _node.get("epoch");
            if (_epochNode == null) {
                throw new RuntimeException("SnapshotId: unable to locate field 'epoch', which is mandatory in version " + _version);
            }
            _object.epoch = MessageUtil.jsonNodeToInt(_epochNode, "SnapshotId");
            return _object;
        }

        public static JsonNode write(FetchResponseData.SnapshotId _object, short _version, boolean _serializeRecords) {
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of SnapshotId");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("endOffset", (JsonNode)new LongNode(_object.endOffset));
            _node.set("epoch", (JsonNode)new IntNode(_object.epoch));
            return _node;
        }

        public static JsonNode write(FetchResponseData.SnapshotId _object, short _version) {
            return SnapshotIdJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static FetchResponseData.PartitionData read(JsonNode _node, short _version) {
            FetchResponseData.PartitionData _object = new FetchResponseData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "PartitionData");
            JsonNode _highWatermarkNode = _node.get("highWatermark");
            if (_highWatermarkNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'highWatermark', which is mandatory in version " + _version);
            }
            _object.highWatermark = MessageUtil.jsonNodeToLong(_highWatermarkNode, "PartitionData");
            JsonNode _lastStableOffsetNode = _node.get("lastStableOffset");
            if (_lastStableOffsetNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'lastStableOffset', which is mandatory in version " + _version);
            }
            _object.lastStableOffset = MessageUtil.jsonNodeToLong(_lastStableOffsetNode, "PartitionData");
            JsonNode _logStartOffsetNode = _node.get("logStartOffset");
            if (_logStartOffsetNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("PartitionData: unable to locate field 'logStartOffset', which is mandatory in version " + _version);
                }
                _object.logStartOffset = -1L;
            } else {
                _object.logStartOffset = MessageUtil.jsonNodeToLong(_logStartOffsetNode, "PartitionData");
            }
            JsonNode _divergingEpochNode = _node.get("divergingEpoch");
            _object.divergingEpoch = _divergingEpochNode == null ? new FetchResponseData.EpochEndOffset() : EpochEndOffsetJsonConverter.read(_divergingEpochNode, _version);
            JsonNode _currentLeaderNode = _node.get("currentLeader");
            _object.currentLeader = _currentLeaderNode == null ? new FetchResponseData.LeaderIdAndEpoch() : LeaderIdAndEpochJsonConverter.read(_currentLeaderNode, _version);
            JsonNode _snapshotIdNode = _node.get("snapshotId");
            _object.snapshotId = _snapshotIdNode == null ? new FetchResponseData.SnapshotId() : SnapshotIdJsonConverter.read(_snapshotIdNode, _version);
            JsonNode _abortedTransactionsNode = _node.get("abortedTransactions");
            if (_abortedTransactionsNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'abortedTransactions', which is mandatory in version " + _version);
            }
            if (_abortedTransactionsNode.isNull()) {
                _object.abortedTransactions = null;
            } else {
                if (!_abortedTransactionsNode.isArray()) {
                    throw new RuntimeException("PartitionData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<FetchResponseData.AbortedTransaction> _collection = new ArrayList<FetchResponseData.AbortedTransaction>(_abortedTransactionsNode.size());
                _object.abortedTransactions = _collection;
                for (JsonNode _element : _abortedTransactionsNode) {
                    _collection.add(AbortedTransactionJsonConverter.read(_element, _version));
                }
            }
            JsonNode _preferredReadReplicaNode = _node.get("preferredReadReplica");
            if (_preferredReadReplicaNode == null) {
                if (_version >= 11) {
                    throw new RuntimeException("PartitionData: unable to locate field 'preferredReadReplica', which is mandatory in version " + _version);
                }
                _object.preferredReadReplica = -1;
            } else {
                _object.preferredReadReplica = MessageUtil.jsonNodeToInt(_preferredReadReplicaNode, "PartitionData");
            }
            JsonNode _recordsNode = _node.get("records");
            if (_recordsNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'records', which is mandatory in version " + _version);
            }
            _object.records = _recordsNode.isNull() ? null : MemoryRecords.readableRecords(ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(_recordsNode, "PartitionData")));
            return _object;
        }

        public static JsonNode write(FetchResponseData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            _node.set("highWatermark", (JsonNode)new LongNode(_object.highWatermark));
            _node.set("lastStableOffset", (JsonNode)new LongNode(_object.lastStableOffset));
            if (_version >= 5) {
                _node.set("logStartOffset", (JsonNode)new LongNode(_object.logStartOffset));
            }
            if (_version >= 12) {
                if (!_object.divergingEpoch.equals(new FetchResponseData.EpochEndOffset())) {
                    _node.set("divergingEpoch", EpochEndOffsetJsonConverter.write(_object.divergingEpoch, _version, _serializeRecords));
                }
            } else if (!_object.divergingEpoch.equals(new FetchResponseData.EpochEndOffset())) {
                throw new UnsupportedVersionException("Attempted to write a non-default divergingEpoch at version " + _version);
            }
            if (_version >= 12) {
                if (!_object.currentLeader.equals(new FetchResponseData.LeaderIdAndEpoch())) {
                    _node.set("currentLeader", LeaderIdAndEpochJsonConverter.write(_object.currentLeader, _version, _serializeRecords));
                }
            } else if (!_object.currentLeader.equals(new FetchResponseData.LeaderIdAndEpoch())) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeader at version " + _version);
            }
            if (_version >= 12) {
                if (!_object.snapshotId.equals(new FetchResponseData.SnapshotId())) {
                    _node.set("snapshotId", SnapshotIdJsonConverter.write(_object.snapshotId, _version, _serializeRecords));
                }
            } else if (!_object.snapshotId.equals(new FetchResponseData.SnapshotId())) {
                throw new UnsupportedVersionException("Attempted to write a non-default snapshotId at version " + _version);
            }
            if (_object.abortedTransactions == null) {
                _node.set("abortedTransactions", (JsonNode)NullNode.instance);
            } else {
                ArrayNode _abortedTransactionsArray = new ArrayNode(JsonNodeFactory.instance);
                for (FetchResponseData.AbortedTransaction _element : _object.abortedTransactions) {
                    _abortedTransactionsArray.add(AbortedTransactionJsonConverter.write(_element, _version, _serializeRecords));
                }
                _node.set("abortedTransactions", (JsonNode)_abortedTransactionsArray);
            }
            if (_version >= 11) {
                _node.set("preferredReadReplica", (JsonNode)new IntNode(_object.preferredReadReplica));
            } else if (_object.preferredReadReplica != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default preferredReadReplica at version " + _version);
            }
            if (_object.records == null) {
                _node.set("records", (JsonNode)NullNode.instance);
            } else if (_serializeRecords) {
                _node.set("records", (JsonNode)new BinaryNode(new byte[0]));
            } else {
                _node.set("recordsSizeInBytes", (JsonNode)new IntNode(_object.records.sizeInBytes()));
            }
            return _node;
        }

        public static JsonNode write(FetchResponseData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class LeaderIdAndEpochJsonConverter {
        public static FetchResponseData.LeaderIdAndEpoch read(JsonNode _node, short _version) {
            FetchResponseData.LeaderIdAndEpoch _object = new FetchResponseData.LeaderIdAndEpoch();
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderIdAndEpoch");
            }
            JsonNode _leaderIdNode = _node.get("leaderId");
            if (_leaderIdNode == null) {
                throw new RuntimeException("LeaderIdAndEpoch: unable to locate field 'leaderId', which is mandatory in version " + _version);
            }
            _object.leaderId = MessageUtil.jsonNodeToInt(_leaderIdNode, "LeaderIdAndEpoch");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("LeaderIdAndEpoch: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "LeaderIdAndEpoch");
            return _object;
        }

        public static JsonNode write(FetchResponseData.LeaderIdAndEpoch _object, short _version, boolean _serializeRecords) {
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderIdAndEpoch");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("leaderId", (JsonNode)new IntNode(_object.leaderId));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            return _node;
        }

        public static JsonNode write(FetchResponseData.LeaderIdAndEpoch _object, short _version) {
            return LeaderIdAndEpochJsonConverter.write(_object, _version, true);
        }
    }

    public static class EpochEndOffsetJsonConverter {
        public static FetchResponseData.EpochEndOffset read(JsonNode _node, short _version) {
            FetchResponseData.EpochEndOffset _object = new FetchResponseData.EpochEndOffset();
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EpochEndOffset");
            }
            JsonNode _epochNode = _node.get("epoch");
            if (_epochNode == null) {
                throw new RuntimeException("EpochEndOffset: unable to locate field 'epoch', which is mandatory in version " + _version);
            }
            _object.epoch = MessageUtil.jsonNodeToInt(_epochNode, "EpochEndOffset");
            JsonNode _endOffsetNode = _node.get("endOffset");
            if (_endOffsetNode == null) {
                throw new RuntimeException("EpochEndOffset: unable to locate field 'endOffset', which is mandatory in version " + _version);
            }
            _object.endOffset = MessageUtil.jsonNodeToLong(_endOffsetNode, "EpochEndOffset");
            return _object;
        }

        public static JsonNode write(FetchResponseData.EpochEndOffset _object, short _version, boolean _serializeRecords) {
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EpochEndOffset");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("epoch", (JsonNode)new IntNode(_object.epoch));
            _node.set("endOffset", (JsonNode)new LongNode(_object.endOffset));
            return _node;
        }

        public static JsonNode write(FetchResponseData.EpochEndOffset _object, short _version) {
            return EpochEndOffsetJsonConverter.write(_object, _version, true);
        }
    }

    public static class AbortedTransactionJsonConverter {
        public static FetchResponseData.AbortedTransaction read(JsonNode _node, short _version) {
            FetchResponseData.AbortedTransaction _object = new FetchResponseData.AbortedTransaction();
            JsonNode _producerIdNode = _node.get("producerId");
            if (_producerIdNode == null) {
                throw new RuntimeException("AbortedTransaction: unable to locate field 'producerId', which is mandatory in version " + _version);
            }
            _object.producerId = MessageUtil.jsonNodeToLong(_producerIdNode, "AbortedTransaction");
            JsonNode _firstOffsetNode = _node.get("firstOffset");
            if (_firstOffsetNode == null) {
                throw new RuntimeException("AbortedTransaction: unable to locate field 'firstOffset', which is mandatory in version " + _version);
            }
            _object.firstOffset = MessageUtil.jsonNodeToLong(_firstOffsetNode, "AbortedTransaction");
            return _object;
        }

        public static JsonNode write(FetchResponseData.AbortedTransaction _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("producerId", (JsonNode)new LongNode(_object.producerId));
            _node.set("firstOffset", (JsonNode)new LongNode(_object.firstOffset));
            return _node;
        }

        public static JsonNode write(FetchResponseData.AbortedTransaction _object, short _version) {
            return AbortedTransactionJsonConverter.write(_object, _version, true);
        }
    }
}

