/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;

public class HistoryRule
implements Rule {
    public static final String ERROR_CODE = "HISTORY_VIOLATION";
    protected boolean reportAllFailures;

    public HistoryRule() {
        this(true);
    }

    public HistoryRule(boolean reportAll) {
        this.reportAllFailures = reportAll;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        List<PasswordData.HistoricalReference> references = passwordData.getPasswordReferences(PasswordData.HistoricalReference.class);
        int size = references.size();
        if (size == 0) {
            return result;
        }
        String cleartext = passwordData.getPassword();
        if (this.reportAllFailures) {
            references.stream().filter(reference -> this.matches(cleartext, (PasswordData.Reference)reference)).forEach(reference -> result.addError(ERROR_CODE, this.createRuleResultDetailParameters(size)));
        } else {
            references.stream().filter(reference -> this.matches(cleartext, (PasswordData.Reference)reference)).findFirst().ifPresent(reference -> result.addError(ERROR_CODE, this.createRuleResultDetailParameters(size)));
        }
        return result;
    }

    protected boolean matches(String password, PasswordData.Reference reference) {
        return password.equals(reference.getPassword());
    }

    protected Map<String, Object> createRuleResultDetailParameters(int size) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("historySize", size);
        return m;
    }
}

