/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.actionlevel;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.selectivem.collections.CheckTable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.security.privileges.ActionPrivileges;
import org.opensearch.security.privileges.IndexPattern;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.PrivilegesEvaluatorResponse;
import org.opensearch.security.privileges.actionlevel.WellKnownActions;
import org.opensearch.security.resolver.IndexResolverReplacer;
import org.opensearch.security.support.WildcardMatcher;

public abstract class RuntimeOptimizedActionPrivileges
implements ActionPrivileges {
    private static final Logger log = LogManager.getLogger(RuntimeOptimizedActionPrivileges.class);
    protected final ClusterPrivileges cluster;
    protected final StaticIndexPrivileges index;

    RuntimeOptimizedActionPrivileges(ClusterPrivileges cluster, StaticIndexPrivileges index) {
        this.cluster = cluster;
        this.index = index;
    }

    @Override
    public PrivilegesEvaluatorResponse hasClusterPrivilege(PrivilegesEvaluationContext context, String action) {
        return this.cluster.providesPrivilege(context, action);
    }

    @Override
    public PrivilegesEvaluatorResponse hasAnyClusterPrivilege(PrivilegesEvaluationContext context, Set<String> actions) {
        return this.cluster.providesAnyPrivilege(context, actions);
    }

    @Override
    public PrivilegesEvaluatorResponse hasExplicitClusterPrivilege(PrivilegesEvaluationContext context, String action) {
        return this.cluster.providesExplicitPrivilege(context, action);
    }

    @Override
    public PrivilegesEvaluatorResponse hasIndexPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices) {
        PrivilegesEvaluatorResponse response = this.index.checkWildcardIndexPrivilegesOnWellKnownActions(context, actions);
        if (response != null) {
            return response;
        }
        if (!resolvedIndices.isLocalAll() && resolvedIndices.getAllIndices().isEmpty()) {
            log.debug("No local indices; grant the request");
            return PrivilegesEvaluatorResponse.ok();
        }
        Set<String> allIndicesResolved = resolvedIndices.getAllIndicesResolved(context.getClusterStateSupplier(), context.getIndexNameExpressionResolver());
        if (allIndicesResolved.isEmpty()) {
            log.debug("No resolved indices; grant the request (user has index privileges for the action)");
            return PrivilegesEvaluatorResponse.ok();
        }
        CheckTable checkTable = CheckTable.create(allIndicesResolved, actions);
        StatefulIndexPrivileges statefulIndex = this.currentStatefulIndexPrivileges();
        PrivilegesEvaluatorResponse resultFromStatefulIndex = null;
        if (statefulIndex != null && (resultFromStatefulIndex = statefulIndex.providesPrivilege(actions, resolvedIndices, context, (CheckTable<String, String>)checkTable)) != null) {
            return resultFromStatefulIndex;
        }
        return this.index.providesPrivilege(context, actions, resolvedIndices, (CheckTable<String, String>)checkTable);
    }

    @Override
    public PrivilegesEvaluatorResponse hasExplicitIndexPrivilege(PrivilegesEvaluationContext context, Set<String> actions, IndexResolverReplacer.Resolved resolvedIndices) {
        if (!CollectionUtils.containsAny(actions, WellKnownActions.EXPLICITLY_REQUIRED_INDEX_ACTIONS)) {
            return PrivilegesEvaluatorResponse.insufficient((CheckTable<String, String>)CheckTable.create((Set)ImmutableSet.of((Object)"_"), actions));
        }
        CheckTable checkTable = CheckTable.create(resolvedIndices.getAllIndices(), actions);
        return this.index.providesExplicitPrivilege(context, actions, (CheckTable<String, String>)checkTable);
    }

    protected abstract StatefulIndexPrivileges currentStatefulIndexPrivileges();

    protected static abstract class ClusterPrivileges {
        protected ClusterPrivileges() {
        }

        PrivilegesEvaluatorResponse providesPrivilege(PrivilegesEvaluationContext context, String action) {
            if (this.checkWildcardPrivilege(context)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            if (this.checkPrivilegeForWellKnownAction(context, action)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            if (!WellKnownActions.isWellKnownClusterAction(action) && this.checkPrivilegeViaActionMatcher(context, action)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            return PrivilegesEvaluatorResponse.insufficient(action);
        }

        PrivilegesEvaluatorResponse providesExplicitPrivilege(PrivilegesEvaluationContext context, String action) {
            if (this.checkPrivilegeForWellKnownAction(context, action)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            if (!WellKnownActions.isWellKnownClusterAction(action) && this.checkPrivilegeViaActionMatcher(context, action)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            return PrivilegesEvaluatorResponse.insufficient(action);
        }

        PrivilegesEvaluatorResponse providesAnyPrivilege(PrivilegesEvaluationContext context, Set<String> actions) {
            if (this.checkWildcardPrivilege(context)) {
                return PrivilegesEvaluatorResponse.ok();
            }
            for (String action : actions) {
                if (!this.checkPrivilegeForWellKnownAction(context, action)) continue;
                return PrivilegesEvaluatorResponse.ok();
            }
            for (String action : actions) {
                if (WellKnownActions.isWellKnownClusterAction(action) || !this.checkPrivilegeViaActionMatcher(context, action)) continue;
                return PrivilegesEvaluatorResponse.ok();
            }
            if (actions.size() == 1) {
                return PrivilegesEvaluatorResponse.insufficient(actions.iterator().next());
            }
            return PrivilegesEvaluatorResponse.insufficient("any of " + String.valueOf(actions));
        }

        protected abstract boolean checkWildcardPrivilege(PrivilegesEvaluationContext var1);

        protected abstract boolean checkPrivilegeForWellKnownAction(PrivilegesEvaluationContext var1, String var2);

        protected abstract boolean checkPrivilegeViaActionMatcher(PrivilegesEvaluationContext var1, String var2);
    }

    protected static abstract class StaticIndexPrivileges {
        protected StaticIndexPrivileges() {
        }

        protected abstract PrivilegesEvaluatorResponse providesPrivilege(PrivilegesEvaluationContext var1, Set<String> var2, IndexResolverReplacer.Resolved var3, CheckTable<String, String> var4);

        protected abstract PrivilegesEvaluatorResponse providesExplicitPrivilege(PrivilegesEvaluationContext var1, Set<String> var2, CheckTable<String, String> var3);

        protected abstract PrivilegesEvaluatorResponse checkWildcardIndexPrivilegesOnWellKnownActions(PrivilegesEvaluationContext var1, Set<String> var2);

        protected void checkPrivilegeWithIndexPatternOnWellKnownActions(PrivilegesEvaluationContext context, Set<String> actions, CheckTable<String, String> checkTable, ImmutableMap<String, IndexPattern> actionToIndexPattern, List<PrivilegesEvaluationException> exceptions) {
            Map<String, IndexAbstraction> indexMetadata = context.getIndicesLookup();
            for (String action : actions) {
                IndexPattern indexPattern = (IndexPattern)actionToIndexPattern.get((Object)action);
                if (indexPattern == null) continue;
                for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                    try {
                        if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                        return;
                    }
                    catch (PrivilegesEvaluationException e) {
                        log.error("Error while evaluating index pattern of {}. Ignoring entry", (Object)this, (Object)e);
                        exceptions.add(new PrivilegesEvaluationException("Error while evaluating " + String.valueOf(this), e));
                    }
                }
            }
        }

        protected void checkPrivilegesForNonWellKnownActions(PrivilegesEvaluationContext context, Set<String> actions, CheckTable<String, String> checkTable, ImmutableMap<WildcardMatcher, IndexPattern> actionPatternToIndexPattern, List<PrivilegesEvaluationException> exceptions) {
            Map<String, IndexAbstraction> indexMetadata = context.getIndicesLookup();
            for (String action : actions) {
                if (WellKnownActions.isWellKnownIndexAction(action)) continue;
                for (Map.Entry entry : actionPatternToIndexPattern.entrySet()) {
                    WildcardMatcher actionMatcher = (WildcardMatcher)entry.getKey();
                    IndexPattern indexPattern = (IndexPattern)entry.getValue();
                    if (!actionMatcher.test(action)) continue;
                    for (String index : checkTable.iterateUncheckedRows((Object)action)) {
                        try {
                            if (!indexPattern.matches(index, context, indexMetadata) || !checkTable.check((Object)index, (Object)action)) continue;
                            return;
                        }
                        catch (PrivilegesEvaluationException e) {
                            log.error("Error while evaluating index pattern {}. Ignoring entry", (Object)indexPattern, (Object)e);
                            exceptions.add(new PrivilegesEvaluationException("Error while evaluating index pattern " + String.valueOf(indexPattern), e));
                        }
                    }
                }
            }
        }

        protected PrivilegesEvaluatorResponse responseForIncompletePrivileges(PrivilegesEvaluationContext context, IndexResolverReplacer.Resolved resolvedIndices, CheckTable<String, String> checkTable, List<PrivilegesEvaluationException> exceptions) {
            Set availableIndices = checkTable.getCompleteRows();
            if (!availableIndices.isEmpty()) {
                return PrivilegesEvaluatorResponse.partiallyOk(availableIndices, checkTable).evaluationExceptions(exceptions);
            }
            return PrivilegesEvaluatorResponse.insufficient(checkTable).reason((String)(resolvedIndices.getAllIndices().size() == 1 ? "Insufficient permissions for the referenced index" : "None of " + resolvedIndices.getAllIndices().size() + " referenced indices has sufficient permissions")).evaluationExceptions(exceptions);
        }
    }

    protected static abstract class StatefulIndexPrivileges {
        protected StatefulIndexPrivileges() {
        }

        protected abstract PrivilegesEvaluatorResponse providesPrivilege(Set<String> var1, IndexResolverReplacer.Resolved var2, PrivilegesEvaluationContext var3, CheckTable<String, String> var4);
    }
}

