/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.ldaptive.CompareOperation;
import org.ldaptive.CompareRequest;
import org.ldaptive.Connection;
import org.ldaptive.Credential;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.Response;
import org.ldaptive.auth.AbstractAuthenticationHandler;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;

public abstract class AbstractCompareAuthenticationHandler
extends AbstractAuthenticationHandler {
    protected static final String DEFAULT_SCHEME = "SHA:SHA";
    protected static final String DEFAULT_ATTRIBUTE = "userPassword";
    private Scheme passwordScheme = new Scheme("SHA:SHA");
    private String passwordAttribute = "userPassword";

    public String getPasswordScheme() {
        return this.passwordScheme.toString();
    }

    public void setPasswordScheme(String s) {
        this.passwordScheme = new Scheme(s);
    }

    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String s) {
        this.passwordAttribute = s;
    }

    @Override
    protected AuthenticationHandlerResponse authenticateInternal(Connection c, AuthenticationCriteria criteria) throws LdapException {
        byte[] hash = this.digestCredential(criteria.getCredential(), this.passwordScheme.getAlgorithm());
        LdapAttribute la = new LdapAttribute(this.passwordAttribute, new byte[][]{String.format("{%s}%s", this.passwordScheme.getLabel(), LdapUtils.base64Encode(hash)).getBytes()});
        CompareOperation compare = new CompareOperation(c);
        CompareRequest request = new CompareRequest(criteria.getDn(), la);
        request.setControls(this.processRequestControls(criteria));
        Response compareResponse = compare.execute(request);
        return new AuthenticationHandlerResponse((Boolean)compareResponse.getResult(), compareResponse.getResultCode(), c, compareResponse.getMessage(), compareResponse.getControls(), compareResponse.getMessageId());
    }

    protected byte[] digestCredential(Credential credential, String algorithm) throws LdapException {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(credential.getBytes());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new LdapException(e);
        }
    }

    @Override
    protected abstract Connection getConnection() throws LdapException;

    public static class Scheme {
        private final String label;
        private final String algorithm;

        public Scheme(String labelAndAlgorithm) {
            String[] s = labelAndAlgorithm.split(":", 2);
            this.label = s[0];
            this.algorithm = s.length == 2 ? s[1] : s[0];
        }

        public Scheme(String l, String a) {
            this.label = l;
            this.algorithm = a;
        }

        public String getLabel() {
            return this.label;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String toString() {
            return String.format("%s:%s", this.label, this.algorithm);
        }
    }
}

