/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.codec.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.batik.ext.awt.image.codec.util.PropertyUtil;
import org.apache.batik.ext.awt.image.codec.util.SeekableStream;

public final class FileCacheSeekableStream
extends SeekableStream {
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 1024;
    private byte[] buf = new byte[this.bufLen];
    private long length = 0L;
    private long pointer = 0L;
    private boolean foundEOF = false;

    public FileCacheSeekableStream(InputStream inputStream) throws IOException {
        this.stream = inputStream;
        this.cacheFile = File.createTempFile("jai-FCSS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    private long readUntil(long l) throws IOException {
        if (l < this.length) {
            return l;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l2 = l - this.length;
        this.cache.seek(this.length);
        while (l2 > 0L) {
            int n = this.stream.read(this.buf, 0, (int)Math.min(l2, (long)this.bufLen));
            if (n == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n);
            this.cache.write(this.buf, 0, n);
            l2 -= (long)n;
            this.length += (long)n;
        }
        return l;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public long getFilePointer() {
        return this.pointer;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException(PropertyUtil.getString("FileCacheSeekableStream0"));
        }
        this.pointer = l;
    }

    public int read() throws IOException {
        long l = this.pointer + 1L;
        long l2 = this.readUntil(l);
        if (l2 >= l) {
            this.cache.seek(this.pointer++);
            return this.cache.read();
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l = this.readUntil(this.pointer + (long)n2);
        if ((n2 = (int)Math.min((long)n2, l - this.pointer)) > 0) {
            this.cache.seek(this.pointer);
            this.cache.readFully(byArray, n, n2);
            this.pointer += (long)n2;
            return n2;
        }
        return -1;
    }

    public void close() throws IOException {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
    }
}

