/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.filter;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.util.Map;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.AbstractRable;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.GraphicsNodeRable;
import org.apache.batik.gvt.filter.GraphicsNodeRed8Bit;

public class GraphicsNodeRable8Bit
extends AbstractRable
implements GraphicsNodeRable,
PaintRable {
    private AffineTransform cachedGn2dev = null;
    private AffineTransform cachedUsr2dev = null;
    private CachableRed cachedRed = null;
    private Rectangle2D cachedBounds = null;
    private boolean usePrimitivePaint = true;
    private GraphicsNode node;

    public boolean getUsePrimitivePaint() {
        return this.usePrimitivePaint;
    }

    public void setUsePrimitivePaint(boolean bl) {
        this.usePrimitivePaint = bl;
    }

    public GraphicsNode getGraphicsNode() {
        return this.node;
    }

    public void setGraphicsNode(GraphicsNode graphicsNode) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
    }

    public void clearCache() {
        this.cachedRed = null;
        this.cachedUsr2dev = null;
        this.cachedGn2dev = null;
        this.cachedBounds = null;
    }

    public GraphicsNodeRable8Bit(GraphicsNode graphicsNode) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.usePrimitivePaint = true;
    }

    public GraphicsNodeRable8Bit(GraphicsNode graphicsNode, Map map) {
        super((Filter)null, map);
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.usePrimitivePaint = true;
    }

    public GraphicsNodeRable8Bit(GraphicsNode graphicsNode, boolean bl) {
        if (graphicsNode == null) {
            throw new IllegalArgumentException();
        }
        this.node = graphicsNode;
        this.usePrimitivePaint = bl;
    }

    public Rectangle2D getBounds2D() {
        if (this.usePrimitivePaint) {
            Rectangle2D rectangle2D = this.node.getPrimitiveBounds();
            if (rectangle2D == null) {
                return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
            return (Rectangle2D)rectangle2D.clone();
        }
        Rectangle2D rectangle2D = this.node.getBounds();
        if (rectangle2D == null) {
            return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        }
        AffineTransform affineTransform = this.node.getTransform();
        if (affineTransform != null) {
            rectangle2D = affineTransform.createTransformedShape(rectangle2D).getBounds2D();
        }
        return rectangle2D;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean paintRable(Graphics2D graphics2D) {
        Composite composite = graphics2D.getComposite();
        if (!SVGComposite.OVER.equals(composite)) {
            return false;
        }
        ColorSpace colorSpace = GraphicsUtil.getDestinationColorSpace(graphics2D);
        if (colorSpace == null || colorSpace != ColorSpace.getInstance(1000)) {
            return false;
        }
        GraphicsNode graphicsNode = this.getGraphicsNode();
        if (this.getUsePrimitivePaint()) {
            graphicsNode.primitivePaint(graphics2D);
        } else {
            graphicsNode.paint(graphics2D);
        }
        return true;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        AffineTransform affineTransform = renderContext.getTransform();
        AffineTransform affineTransform2 = affineTransform == null ? (affineTransform = new AffineTransform()) : (AffineTransform)affineTransform.clone();
        AffineTransform affineTransform3 = this.node.getTransform();
        if (affineTransform3 != null) {
            affineTransform2.concatenate(affineTransform3);
        }
        Rectangle2D rectangle2D = this.getBounds2D();
        if (this.cachedBounds != null && this.cachedGn2dev != null && this.cachedBounds.equals(rectangle2D) && affineTransform2.getScaleX() == this.cachedGn2dev.getScaleX() && affineTransform2.getScaleY() == this.cachedGn2dev.getScaleY() && affineTransform2.getShearX() == this.cachedGn2dev.getShearX() && affineTransform2.getShearY() == this.cachedGn2dev.getShearY()) {
            double d = affineTransform.getTranslateX() - this.cachedUsr2dev.getTranslateX();
            double d2 = affineTransform.getTranslateY() - this.cachedUsr2dev.getTranslateY();
            if (d == 0.0 && d2 == 0.0) {
                return this.cachedRed;
            }
            if (d == (double)((int)d) && d2 == (double)((int)d2)) {
                return new TranslateRed(this.cachedRed, (int)Math.round((double)this.cachedRed.getMinX() + d), (int)Math.round((double)this.cachedRed.getMinY() + d2));
            }
        }
        if (rectangle2D.getWidth() > 0.0 && rectangle2D.getHeight() > 0.0) {
            this.cachedUsr2dev = (AffineTransform)affineTransform.clone();
            this.cachedGn2dev = affineTransform2;
            this.cachedBounds = rectangle2D;
            this.cachedRed = new GraphicsNodeRed8Bit(this.node, affineTransform, this.usePrimitivePaint, renderContext.getRenderingHints());
            return this.cachedRed;
        }
        this.cachedUsr2dev = null;
        this.cachedGn2dev = null;
        this.cachedBounds = null;
        this.cachedRed = null;
        return null;
    }
}

