/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.wls.shaded.org.apache.bcel.classfile;

import com.oracle.wls.shaded.org.apache.bcel.classfile.Attribute;
import com.oracle.wls.shaded.org.apache.bcel.classfile.ConstantPool;
import com.oracle.wls.shaded.org.apache.bcel.classfile.Utility;
import com.oracle.wls.shaded.org.apache.bcel.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionTable
extends Attribute {
    private int number_of_exceptions;
    private int[] exception_index_table;

    public ExceptionTable(ExceptionTable c) {
        this(c.getNameIndex(), c.getLength(), c.getExceptionIndexTable(), c.getConstantPool());
    }

    public ExceptionTable(int name_index, int length, int[] exception_index_table, ConstantPool constant_pool) {
        super((byte)3, name_index, length, constant_pool);
        this.setExceptionIndexTable(exception_index_table);
    }

    ExceptionTable(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (int[])null, constant_pool);
        this.number_of_exceptions = file.readUnsignedShort();
        this.exception_index_table = new int[this.number_of_exceptions];
        int i = 0;
        while (i < this.number_of_exceptions) {
            this.exception_index_table[i] = file.readUnsignedShort();
            ++i;
        }
    }

    public void accept(Visitor v) {
        v.visitExceptionTable(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.number_of_exceptions);
        int i = 0;
        while (i < this.number_of_exceptions) {
            file.writeShort(this.exception_index_table[i]);
            ++i;
        }
    }

    public final int[] getExceptionIndexTable() {
        return this.exception_index_table;
    }

    public final int getNumberOfExceptions() {
        return this.number_of_exceptions;
    }

    public final String[] getExceptionNames() {
        String[] names = new String[this.number_of_exceptions];
        int i = 0;
        while (i < this.number_of_exceptions) {
            names[i] = this.constant_pool.getConstantString(this.exception_index_table[i], (byte)7).replace('/', '.');
            ++i;
        }
        return names;
    }

    public final void setExceptionIndexTable(int[] exception_index_table) {
        this.exception_index_table = exception_index_table;
        this.number_of_exceptions = exception_index_table == null ? 0 : exception_index_table.length;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer("");
        int i = 0;
        while (i < this.number_of_exceptions) {
            String str = this.constant_pool.getConstantString(this.exception_index_table[i], (byte)7);
            buf.append(Utility.compactClassName(str, false));
            if (i < this.number_of_exceptions - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    public Attribute copy(ConstantPool constant_pool) {
        ExceptionTable c = (ExceptionTable)this.clone();
        c.exception_index_table = (int[])this.exception_index_table.clone();
        c.constant_pool = constant_pool;
        return c;
    }
}

