/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.idrange;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.entity.EntityCreationPreferences;
import org.protege.editor.owl.model.idrange.IdRange;
import org.protege.editor.owl.model.idrange.IdRangesPolicy;
import org.protege.editor.owl.model.idrange.NoRangeForUserNameHandler;
import org.protege.editor.owl.model.idrange.UserIdRange;
import org.protege.editor.owl.model.user.UserNameProvider;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdPolicyEntityCreationPreferencesUpdater {
    private static final Pattern ID_PREFIX_PATTERN = Pattern.compile("(.+)([/#:])([A-Za-z0-9]+)_$");
    private static final Logger logger = LoggerFactory.getLogger(IdPolicyEntityCreationPreferencesUpdater.class);
    @Nonnull
    private final IdRangesPolicy policy;
    @Nonnull
    private final NoRangeForUserNameHandler noRangeForUserNameHandler;
    @Nonnull
    private final UserNameProvider userNameProvider;

    public IdPolicyEntityCreationPreferencesUpdater(@Nonnull IdRangesPolicy policy, @Nonnull NoRangeForUserNameHandler noRangeForUserNameHandler, @Nonnull UserNameProvider userNameProvider) {
        this.policy = (IdRangesPolicy)Preconditions.checkNotNull((Object)policy);
        this.noRangeForUserNameHandler = (NoRangeForUserNameHandler)Preconditions.checkNotNull((Object)noRangeForUserNameHandler);
        this.userNameProvider = (UserNameProvider)Preconditions.checkNotNull((Object)userNameProvider);
    }

    public void updatePreferences() {
        Matcher matcher = ID_PREFIX_PATTERN.matcher(this.policy.getIdPrefix());
        if (!matcher.matches()) {
            logger.warn("[IdRanges] Cannot process prefix {}", (Object)this.policy.getIdPrefix());
            return;
        }
        logger.info("[IdRanges] Setting id digit count to {}", (Object)this.policy.getIdDigitCount());
        EntityCreationPreferences.setAutoIDDigitCount(this.policy.getIdDigitCount());
        String baseIri = matcher.group(1);
        logger.info("[IdRanges] Setting prefix to {}", (Object)baseIri);
        EntityCreationPreferences.setDefaultBaseIRI(IRI.create((String)baseIri));
        EntityCreationPreferences.setUseDefaultBaseIRI(true);
        String separator = matcher.group(2);
        logger.info("[IdRanges] Setting separator to {}", (Object)separator);
        EntityCreationPreferences.setDefaultSeparator(separator);
        String protegePrefix = matcher.group(3) + "_";
        logger.info("[IdRanges] Setting entity prefix to {}", (Object)protegePrefix);
        EntityCreationPreferences.setPrefix(protegePrefix);
        EntityCreationPreferences.setSuffix("");
        logger.info("[IdRanges] Setting entity local name to auto-generated");
        EntityCreationPreferences.setFragmentAutoGenerated(true);
        logger.info("[IdRanges] Setting labelling property to rdfs:label");
        EntityCreationPreferences.setGenerateIDLabel(false);
        EntityCreationPreferences.setGenerateNameLabel(true);
        EntityCreationPreferences.setNameLabelIRI(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.updateRangeForCurrentUserName();
    }

    private void updateRangeForCurrentUserName() {
        this.userNameProvider.getUserName().ifPresent(this::updateRangeForUser);
    }

    private void updateRangeForUser(@Nonnull String userName) {
        logger.info("[IdRanges] Current user name is {}", (Object)userName);
        Optional<UserIdRange> userIdRange = this.policy.getUserIdRanges().stream().filter(rng -> rng.getUserId().equalsIgnoreCase(userName)).findFirst();
        userIdRange.ifPresent(this::updateNumericRange);
        if (!userIdRange.isPresent()) {
            logger.info("[IdRanges] Could not find a matching user name");
            this.noRangeForUserNameHandler.handleNoRangeForUserName(userName, this.policy, this::updateNumericRange);
        }
    }

    private void updateNumericRange(UserIdRange idRange) {
        logger.info("[IdRanges] Updating id range for {}", (Object)idRange.getUserId());
        IdRange rng = idRange.getIdRange();
        this.updateNumericRange(rng);
    }

    private void updateNumericRange(IdRange rng) {
        int start = rng.getLowerBound();
        logger.info("[IdRanges] Setting id start to {}", (Object)start);
        EntityCreationPreferences.setAutoIDStart(start);
        int end = rng.getUpperBound();
        logger.info("[IdRanges] Setting id end to {}", (Object)end);
        EntityCreationPreferences.setAutoIDEnd(end);
        String name = String.format("%s_%d", this.policy.getIdPolicyFor(), start);
        logger.info("[IdRanges] Setting policy name to {}", (Object)name);
        EntityCreationPreferences.setPolicyRangeName(name);
    }
}

