from faker.providers.person.bn_BD import translate_to_bengali_digits

from .. import Provider as CurrencyProvider


class Provider(CurrencyProvider):
    """
    Implement currency provider for ``bn_BD`` locale.
    """

    currencies = (
        ("AED", "সংযুক্ত আরব আমিরাত দিরহাম"),
        ("AFN", "আফগান আফগানি"),
        ("সমস্ত", "আলবেনিয়ান লেক"),
        ("AMD", "আর্মেনিয়ান ড্রাম"),
        ("ANG", "নেদারল্যান্ডস অ্যান্টিলিয়ান গিল্ডার"),
        ("AOA", "অ্যাঙ্গোলান কোয়ানজা"),
        ("ARS", "আর্জেন্টিনা পেসো"),
        ("AUD", "অস্ট্রেলিয়ান ডলার"),
        ("AWG", "আরুবান ফ্লোরিন"),
        ("AZN", "আজারবাইজানীয় মানাত"),
        ("BAM", "বসনিয়া ও হার্জেগোভিনা পরিবর্তনযোগ্য চিহ্ন"),
        ("BBD", "বার্বাডিয়ান ডলার"),
        ("বিডিটি", "বাংলাদেশি টাকা"),
        ("BGN", "বুলগেরিয়ান লেভ"),
        ("BHD", "বাহরাইন দিনার"),
        ("BIF", "বুরুন্ডিয়ান ফ্রাঙ্ক"),
        ("BMD", "বারমুডিয়ান ডলার"),
        ("BND", "ব্রুনাই ডলার"),
        ("BOB", "বলিভিয়ান বলিভিয়ানো"),
        ("BRL", "ব্রাজিলিয়ান রিয়াল"),
        ("BSD", "বাহামিয়ান ডলার"),
        ("BTN", "ভুটানি নগুলট্রাম"),
        ("BWP", "বতসোয়ানা পুলা"),
        ("BYR", "বেলারুশিয়ান রুবেল"),
        ("BZD", "বেলিজ ডলার"),
        ("CAD", "কানাডিয়ান ডলার"),
        ("CDF", "কঙ্গোলিজ ফ্রাঙ্ক"),
        ("CHF", "সুইস ফ্রাঙ্ক"),
        ("CLP", "চিলিয়ান পেসো"),
        ("CNY", "রেনমিনবি"),
        ("COP", "কলম্বিয়ান পেসো"),
        ("CRC", "কোস্টারিকান কোলন"),
        ("CUC", "কিউবান কনভার্টেবল পেসো"),
        ("CUP", "কিউবান পেসো"),
        ("CVE", "কেপ ভার্ডিয়ান এসকুডো"),
        ("CZK", "চেক কোরুনা"),
        ("DJF", "জিবুতিয়ান ফ্রাঙ্ক"),
        ("DKK", "ড্যানিশ ক্রোন"),
        ("DOP", "ডোমিনিকান পেসো"),
        ("DZD", "আলজেরিয়ান দিনার"),
        ("EGP", "মিশরীয় পাউন্ড"),
        ("ERN", "ইরিত্রিয়ান নাকফা"),
        ("ETB", "ইথিওপিয়ান বির"),
        ("EUR", "ইউরো"),
        ("FJD", "ফিজিয়ান ডলার"),
        ("FKP", "ফকল্যান্ড দ্বীপপুঞ্জ পাউন্ড"),
        ("GBP", "পাউন্ড স্টার্লিং"),
        ("GEL", "জর্জিয়ান লারি"),
        ("GGP", "গার্নসি পাউন্ড"),
        ("GHS", "ঘানার সিডি"),
        ("GIP", "জিব্রাল্টার পাউন্ড"),
        ("GMD", "গাম্বিয়ান ডালাসি"),
        ("GNF", "গিনি ফ্রাঙ্ক"),
        ("GTQ", "গুয়াতেমালান কুয়েটজাল"),
        ("GYD", "গায়ানিজ ডলার"),
        ("HKD", "হংকং ডলার"),
        ("HNL", "হন্ডুরান লেম্পিরা"),
        ("HRK", "ক্রোয়েশিয়ান কুনা"),
        ("HTG", "হাইতিয়ান গার্ড"),
        ("HUF", "হাঙ্গেরিয়ান ফরিন্ট"),
        ("IDR", "ইন্দোনেশিয়ান রুপিয়া"),
        ("ILS", "ইসরায়েলি নতুন শেকেল"),
        ("NIS", "ইসরায়েলি নতুন শেকেল"),
        ("IMP", "ম্যাঙ্কস পাউন্ড"),
        ("INR", "ভারতীয় রুপি"),
        ("IQD", "ইরাকি দিনার"),
        ("IRR", "ইরানি রিয়াল"),
        ("ISK", "আইসল্যান্ডিক ক্রোনা"),
        ("JEP", "জার্সি পাউন্ড"),
        ("JMD", "জ্যামাইকান ডলার"),
        ("JOD", "জর্ডানিয়ান দিনার"),
        ("JPY", "জাপানি ইয়েন"),
        ("KES", "কেনিয়ান শিলিং"),
        ("KGS", "কিরগিজস্তানি সোম"),
        ("KHR", "কম্বোডিয়ান রিয়েল"),
        ("KMF", "কমোরিয়ান ফ্রাঙ্ক"),
        ("KPW", "উত্তর কোরিয়ান জয়ী"),
        ("KRW", "দক্ষিণ কোরিয়ান জয়ী"),
        ("KWD", "কুয়েতি দিনার"),
        ("KYD", "কেম্যান দ্বীপপুঞ্জ ডলার"),
        ("KZT", "কাজাখস্তানি টেঙ্গে"),
        ("LAK", "লাও কিপ"),
        ("LBP", "লেবানিজ পাউন্ড"),
        ("LKR", "শ্রীলঙ্কা রুপি"),
        ("LRD", "লাইবেরিয়ান ডলার"),
        ("LSL", "লেসোথো লোটি"),
        ("LTL", "লিথুয়ানিয়ান লিটাস"),
        ("LYD", "লিবিয়ান দিনার"),
        ("MAD", "মরক্কান দিরহাম"),
        ("MDL", "Moldovan leu"),
        ("MGA", "মালাগাসি আরিয়ার"),
        ("MKD", "ম্যাসেডোনিয়ান ডেনার"),
        ("MMK", "বর্মী কিয়াত"),
        ("MNT", "মঙ্গোলিয়ান তুগ্রিক"),
        ("MOP", "ম্যাকানিজ পটাকা"),
        ("MRO", "মৌরিতানীয় ওগুইয়া"),
        ("MUR", "মরিশিয়ান রুপি"),
        ("MVR", "মালদ্বীপের রুফিয়া"),
        ("MWK", "মালাউইয়ান কোয়াচা"),
        ("MXN", "মেক্সিকান পেসো"),
        ("MYR", "মালয়েশিয়ান রিঙ্গিত"),
        ("MZN", "মোজাম্বিকন মেটিক্যাল"),
        ("NAD", "নামিবিয়ান ডলার"),
        ("NGN", "নাইজেরিয়ান নায়রা"),
        ("NIO", "নিকারাগুয়ান কর্ডোবা"),
        ("NOK", "নরওয়েজিয়ান ক্রোন"),
        ("NPR", "নেপালি রুপি"),
        ("NZD", "নিউজিল্যান্ড ডলার"),
        ("OMR", "ওমানি রিয়াল"),
        ("PAB", "পানামানিয়ান বালবোয়া"),
        ("পেন", "পেরুভিয়ান সল"),
        ("PGK", "পাপুয়া নিউ গিনি কিনা"),
        ("PHP", "ফিলিপাইন পেসো"),
        ("PKR", "পাকিস্তানি রুপি"),
        ("PLN", "পোলিশ জ্লটি"),
        ("PYG", "প্যারাগুয়ের গুয়ারানি"),
        ("QAR", "কাতারি রিয়াল"),
        ("RON", "রোমানিয়ান লিউ"),
        ("RSD", "সার্বিয়ান দিনার"),
        ("RUB", "রাশিয়ান রুবেল"),
        ("RWF", "রুয়ান্ডার ফ্রাঙ্ক"),
        ("SAR", "সৌদি রিয়াল"),
        ("SBD", "সলোমন দ্বীপপুঞ্জ ডলার"),
        ("SCR", "সেচেলো রুপি"),
        ("SDG", "সুদানিজ পাউন্ড"),
        ("SEK", "সুইডিশ ক্রোনা"),
        ("SGD", "সিঙ্গাপুর ডলার"),
        ("SHP", "সেন্ট হেলেনা পাউন্ড"),
        ("SLL", "সিয়েরা লিওনিয়ান লিওন"),
        ("SOS", "সোমালি শিলিং"),
        ("SPL", "সেবোরগা লুইগিনো"),
        ("SRD", "সুরিনামী ডলার"),
        ("STD", "সাও টোমে এবং প্রিন্সিপে ডোবরা"),
        ("SVC", "সালভাডোরান কোলন"),
        ("SYP", "সিরিয়ান পাউন্ড"),
        ("SZL", "সোয়াজি লিলাঞ্জেনি"),
        ("THB", "থাই বাত"),
        ("TJS", "তাজিকিস্তানি সোমনি"),
        ("TMT", "তুর্কমেনিস্তান মানাত"),
        ("TND", "তিউনিসিয়ান দিনার"),
        ("TOP", "টোঙ্গান পা'আঙ্গা"),
        ("TRY", "তুর্কি লিরা"),
        ("TTD", "ত্রিনিদাদ ও টোবাগো ডলার"),
        ("TVD", "টুভালুয়ান ডলার"),
        ("TWD", "নতুন তাইওয়ান ডলার"),
        ("TZS", "তানজানিয়ান শিলিং"),
        ("UAH", "ইউক্রেনীয় রিভনিয়া"),
        ("UGX", "উগান্ডার শিলিং"),
        ("USD", "মার্কিন যুক্তরাষ্ট্র ডলার"),
        ("UYU", "উরুগুয়ের পেসো"),
        ("UZS", "উজবেকিস্তানি তাই'"),
        ("VEF", "ভেনিজুয়েলা বলিভার"),
        ("VND", "ভিয়েতনামী তামা"),
        ("VUV", "ভানুয়াতু ভাতু"),
        ("WST", "সামোয়ান তালা"),
        ("XAF", "সেন্ট্রাল আফ্রিকান সিএফএ ফ্রাঙ্ক"),
        ("XCD", "পূর্ব ক্যারিবিয়ান ডলার"),
        ("XDR", "বিশেষ অঙ্কন অধিকার"),
        ("XOF", "ওয়েস্ট আফ্রিকান সিএফএ ফ্রাঙ্ক"),
        ("XPF", "সিএফপি ফ্রাঙ্ক"),
        ("YER", "ইয়েমেনি রিয়াল"),
        ("ZAR", "দক্ষিণ আফ্রিকান র্যান্ড"),
        ("ZMW", "জাম্বিয়ান কোয়াচা"),
        ("ZWD", "জিম্বাবুয়েন ডলার"),
    )

    cryptocurrencies = (
        ("AMP", "এএমপি"),
        ("AUR", "অরোরাকয়েন"),
        ("BC", "ব্ল্যাককয়েন"),
        ("BTC", "বিটকয়েন"),
        ("BURST", "ব্রাস্টকয়েন"),
        ("DASH", "ড্যাশ"),
        ("DOGE", "ডোজকয়েন"),
        ("EMC", "ইমারকয়েন"),
        ("ETH", "ইথেরিয়াম"),
        ("ETC", "ইথেরিয়াম ক্ল্যাসিক"),
        ("GRC", "গ্রিডকয়েন"),
        ("KOI", "কয়েনইয়ে"),
        ("LTC", "লাইট কয়েন"),
        ("MSC", "ওমনি"),
        ("MZC", "মাজাকয়েন"),
        ("NMC", "নেমকয়েন"),
        ("NXT", "এনএক্সটি"),
        ("POT", "পট কয়েন"),
        ("PPC", "পিয়ারকয়েন"),
        ("TIT", "টিটকয়েন"),
        ("VTC", "ভার্টকয়েন"),
        ("XDN", "ডিজিটাল নোট"),
        ("XMR", "মনেরো"),
        ("XPM", "প্রাইম কয়েন"),
        ("XRP", "রিপল"),
        ("ZEC", "জেক্যাশ"),
        ("STC", "সুইফট কয়েন"),
        ("BCN", "বাইট কয়েন"),
        ("FTH", "ফেদার কয়েন"),
        ("NEO", "নিও"),
        ("NEM", "জেম"),
        ("USDT", "টেথার"),
        ("IOTA", "আই ও টা"),
        ("DRC", "ডিক্রিড"),
        ("WAVES", "ওয়েভস প্লাটফর্ম"),
        ("LSK", "লিস্ক"),
        ("ZCL", "জেক্ল্যাসিক"),
        ("BCH", "বিটকয়েন ক্যাশ"),
        ("UBQ", "ইউবিক"),
        ("EOS", "ই ও এস ডট আইও"),
        ("SRN", "সিরিন ল্যাবস"),
        ("TRX", "ট্রন"),
        ("ADA", "কার্দানো"),
    )

    def pricetag(self) -> str:
        """
        Return price in Bengali digit with Bangladeshi Currency symbol.
        :example: '৳ ৫৫,৫৫০'
        """
        currency_symbol = self.currency_symbol("BDT")
        price = self.numerify(self.random_element(self.price_formats))
        return currency_symbol + " " + translate_to_bengali_digits(price)
