'''OpenGL extension EXT.color_buffer_half_float

This module customises the behaviour of the 
OpenGL.raw.GLES2.EXT.color_buffer_half_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension allows 16-bit floating point formats as defined in
	OES_texture_half_float to be rendered to via framebuffer objects.
	
	When using floating-point formats, certain color clamps are disabled.
	
	This extension also updates the framebuffer object API to allow querying
	attachment component types.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/color_buffer_half_float.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.EXT.color_buffer_half_float import *
from OpenGL.raw.GLES2.EXT.color_buffer_half_float import _EXTENSION_NAME

def glInitColorBufferHalfFloatEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION