// Copyright (c) 2022-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_UNIQUE_BY_KEY_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_UNIQUE_BY_KEY_HPP_

#include "../../../config.hpp"
#include "../../../type_traits_interface.hpp"
#include "../../config_types.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{

template<unsigned int arch, class key_type, class value_type, class enable = void>
struct default_select_unique_by_key_config : default_partition_config_base<key_type, false>::type
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 4>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 8>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<512, 6>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 4>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 8>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 8>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<512, 8>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<256, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<512, 8>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 8>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<384, 10>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<384, 14>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<256, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 4>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 8>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<512, 6>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 4>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 8>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 8>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<512, 8>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 6>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 8>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 10>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<384, 14>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<256, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<512, 6>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 8>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<384, 14>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<384, 12>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<512, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 8>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 8>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<128, 7>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<512, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 8>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<128, 10>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<128, 12>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<512, 8>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 16>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<512, 16>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<192, 16>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<512, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<512, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<512, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 8>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<128, 8>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<128, 7>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<512, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 8>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<128, 12>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<128, 12>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 8>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<128, 11>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<128, 12>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<512, 20>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<384, 8>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<128, 13>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<128, 22>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<384, 20>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<384, 8>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 6>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 6>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<384, 6>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<384, 4>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 7>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 9>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<384, 12>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<384, 8>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 16>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<512, 14>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<512, 14>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<384, 8>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 6>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 6>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<384, 8>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<384, 4>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 7>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 9>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<384, 12>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<384, 6>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 16>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 24>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<512, 14>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<256, 8>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 16>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<512, 32>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<384, 16>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 5>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 6>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 7>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<192, 8>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 6>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 13>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 14>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<192, 16>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<256, 6>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<256, 12>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<192, 14>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<256, 16>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 3>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 8>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 6>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 7>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<192, 8>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 6>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 13>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 14>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<192, 16>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 6>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 12>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<192, 16>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<192, 7>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<192, 14>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 14>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<192, 17>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 5>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<128, 6>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<128, 6>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<192, 8>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 6>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 13>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<256, 16>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<256, 6>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<256, 12>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 14>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<256, 16>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 3>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 5>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<128, 6>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 7>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<192, 8>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 6>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 13>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<192, 16>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 6>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 12>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<256, 14>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<192, 7>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<256, 13>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 14>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<192, 17>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 4>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 4>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 4>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<256, 5>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 5>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 7>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 10>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<192, 9>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<192, 5>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<192, 10>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 24>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<256, 24>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 3>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 4>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 4>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<256, 5>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 5>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 7>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 10>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<192, 9>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 5>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 10>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 24>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<256, 24>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<256, 6>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<192, 10>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 28>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<192, 28>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 5>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<128, 6>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<128, 6>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<192, 8>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 6>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 13>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<256, 16>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<256, 6>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<256, 12>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 14>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<256, 16>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<256, 3>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 5>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<128, 6>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<192, 7>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<192, 8>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<128, 6>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 13>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<192, 16>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<192, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<256, 6>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<256, 12>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<256, 14>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<256, 14>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<192, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<192, 7>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<256, 13>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<256, 14>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<192, 17>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<384, 4>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 7>
{};

// Based on key_type = double, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 7>
{};

// Based on key_type = double, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 7>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<512, 7>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<384, 4>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 7>
{};

// Based on key_type = float, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 15>
{};

// Based on key_type = float, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 14>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<512, 15>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<384, 4>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<512, 7>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 14>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<512, 22>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1))>> : select_config<512, 24>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<384, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<384, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<384, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<384, 4>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1))>>
    : select_config<384, 4>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<384, 4>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 7>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 7>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 7>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1))>>
    : select_config<512, 7>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<384, 4>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 7>
{};

// Based on key_type = int, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 15>
{};

// Based on key_type = int, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 14>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1))>>
    : select_config<512, 15>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>> : select_config<384, 4>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>> : select_config<512, 7>
{};

// Based on key_type = short, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>> : select_config<512, 14>
{};

// Based on key_type = short, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>> : select_config<512, 22>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1))>>
    : select_config<512, 24>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : select_config<384, 4>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : select_config<512, 7>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : select_config<512, 15>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : select_config<512, 24>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, class value_type>
struct default_select_unique_by_key_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1))>> : select_config<512, 24>
{};

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SELECT_UNIQUE_BY_KEY_HPP_
