/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassProto;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.reference.ImmutableFieldReference;
import org.jf.dexlib2.util.TypeUtils;
import org.jf.util.ExceptionWithContext;

public class ArrayProto
implements TypeProto {
    protected final ClassPath classPath;
    protected final int dimensions;
    protected final String elementType;
    private static final String BRACKETS = Strings.repeat("[", 256);

    public ArrayProto(@Nonnull ClassPath classPath, @Nonnull String type) {
        this.classPath = classPath;
        int i = 0;
        while (type.charAt(i) == '[') {
            if (++i != type.length()) continue;
            throw new ExceptionWithContext("Invalid array type: %s", type);
        }
        if (i == 0) {
            throw new ExceptionWithContext("Invalid array type: %s", type);
        }
        this.dimensions = i;
        this.elementType = type.substring(i);
    }

    public String toString() {
        return this.getType();
    }

    @Override
    @Nonnull
    public ClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    @Nonnull
    public String getType() {
        return ArrayProto.makeArrayType(this.elementType, this.dimensions);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Nonnull
    public String getElementType() {
        return this.elementType;
    }

    @Nonnull
    public String getImmediateElementType() {
        if (this.dimensions > 1) {
            return ArrayProto.makeArrayType(this.elementType, this.dimensions - 1);
        }
        return this.elementType;
    }

    @Override
    public boolean implementsInterface(@Nonnull String iface) {
        return iface.equals("Ljava/lang/Cloneable;") || iface.equals("Ljava/io/Serializable;");
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return "Ljava/lang/Object;";
    }

    @Override
    @Nonnull
    public TypeProto getCommonSuperclass(@Nonnull TypeProto other) {
        if (other instanceof ArrayProto) {
            if (TypeUtils.isPrimitiveType(this.getElementType()) || TypeUtils.isPrimitiveType(((ArrayProto)other).getElementType())) {
                if (this.dimensions == ((ArrayProto)other).dimensions && this.getElementType().equals(((ArrayProto)other).getElementType())) {
                    return this;
                }
                return this.classPath.getClass("Ljava/lang/Object;");
            }
            if (this.dimensions == ((ArrayProto)other).dimensions) {
                TypeProto otherClass;
                TypeProto mergedClass;
                TypeProto thisClass = this.classPath.getClass(this.elementType);
                if (thisClass == (mergedClass = thisClass.getCommonSuperclass(otherClass = this.classPath.getClass(((ArrayProto)other).elementType)))) {
                    return this;
                }
                if (otherClass == mergedClass) {
                    return other;
                }
                return this.classPath.getClass(ArrayProto.makeArrayType(mergedClass.getType(), this.dimensions));
            }
            int dimensions = Math.min(this.dimensions, ((ArrayProto)other).dimensions);
            return this.classPath.getClass(ArrayProto.makeArrayType("Ljava/lang/Object;", dimensions));
        }
        if (other instanceof ClassProto) {
            try {
                if (other.isInterface() && this.implementsInterface(other.getType())) {
                    return other;
                }
            }
            catch (UnresolvedClassException unresolvedClassException) {
                // empty catch block
            }
            return this.classPath.getClass("Ljava/lang/Object;");
        }
        return other.getCommonSuperclass(this);
    }

    @Nonnull
    private static String makeArrayType(@Nonnull String elementType, int dimensions) {
        return BRACKETS.substring(0, dimensions) + elementType;
    }

    @Override
    @Nullable
    public FieldReference getFieldByOffset(int fieldOffset) {
        if (fieldOffset == 8) {
            return new ImmutableFieldReference(this.getType(), "length", "int");
        }
        return null;
    }

    @Override
    @Nullable
    public Method getMethodByVtableIndex(int vtableIndex) {
        return this.classPath.getClass("Ljava/lang/Object;").getMethodByVtableIndex(vtableIndex);
    }

    @Override
    public int findMethodIndexInVtable(@Nonnull MethodReference method) {
        return this.classPath.getClass("Ljava/lang/Object;").findMethodIndexInVtable(method);
    }
}

