/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.res.StringManager;

public final class MessageBytes
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final StringManager sm = StringManager.getManager(MessageBytes.class);
    private int type = 0;
    public static final int T_NULL = 0;
    public static final int T_STR = 1;
    public static final int T_BYTES = 2;
    public static final int T_CHARS = 3;
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private int hashCode = 0;
    private boolean hasHashCode = false;
    private final ByteChunk byteC = new ByteChunk();
    private final CharChunk charC = new CharChunk();
    private String strValue;
    private long longValue;
    private boolean hasLongValue = false;
    private static final MessageBytesFactory factory = new MessageBytesFactory();

    private MessageBytes() {
    }

    public static MessageBytes newInstance() {
        return factory.newInstance();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isNull() {
        return this.type == 0;
    }

    public void recycle() {
        this.type = 0;
        this.byteC.recycle();
        this.charC.recycle();
        this.strValue = null;
        this.hasHashCode = false;
        this.hasLongValue = false;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        this.byteC.setBytes(byArray, n, n2);
        this.type = 2;
        this.hasHashCode = false;
        this.hasLongValue = false;
    }

    public void setChars(char[] cArray, int n, int n2) {
        this.charC.setChars(cArray, n, n2);
        this.type = 3;
        this.hasHashCode = false;
        this.hasLongValue = false;
    }

    public void setString(String string) {
        this.strValue = string;
        this.hasHashCode = false;
        this.hasLongValue = false;
        this.type = string == null ? 0 : 1;
    }

    public String toString() {
        switch (this.type) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.strValue = this.byteC.toString();
                break;
            }
            case 3: {
                this.strValue = this.charC.toString();
            }
        }
        return this.strValue;
    }

    public String toStringType() {
        switch (this.type) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                this.setString(this.byteC.toString());
                break;
            }
            case 3: {
                this.setString(this.charC.toString());
            }
        }
        return this.strValue;
    }

    public int getType() {
        return this.type;
    }

    public ByteChunk getByteChunk() {
        return this.byteC;
    }

    public CharChunk getCharChunk() {
        return this.charC;
    }

    public String getString() {
        return this.strValue;
    }

    public Charset getCharset() {
        return this.byteC.getCharset();
    }

    public void setCharset(Charset charset) {
        this.byteC.setCharset(charset);
    }

    public void toBytes() {
        if (this.type == 0) {
            this.byteC.recycle();
            return;
        }
        if (this.type == 2) {
            return;
        }
        if (this.getCharset() == ByteChunk.DEFAULT_CHARSET) {
            if (this.type == 3) {
                this.toBytesSimple(this.charC.getChars(), this.charC.getStart(), this.charC.getLength());
            } else {
                char[] cArray = this.strValue.toCharArray();
                this.toBytesSimple(cArray, 0, cArray.length);
            }
            return;
        }
        ByteBuffer byteBuffer = this.type == 3 ? this.getCharset().encode(CharBuffer.wrap(this.charC)) : this.getCharset().encode(this.strValue);
        this.byteC.setBytes(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit());
    }

    private void toBytesSimple(char[] cArray, int n, int n2) {
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            if (cArray[i + n] > '\u00ff') {
                throw new IllegalArgumentException(sm.getString("messageBytes.illegalCharacter", Character.toString(cArray[i + n]), cArray[i + n]));
            }
            byArray[i] = (byte)cArray[i + n];
        }
        this.byteC.setBytes(byArray, 0, n2);
        this.type = 2;
    }

    public void toChars() {
        switch (this.type) {
            case 0: {
                this.charC.recycle();
            }
            case 3: {
                return;
            }
            case 2: {
                this.toString();
            }
            case 1: {
                char[] cArray = this.strValue.toCharArray();
                this.charC.setChars(cArray, 0, cArray.length);
            }
        }
    }

    public int getLength() {
        if (this.type == 2) {
            return this.byteC.getLength();
        }
        if (this.type == 3) {
            return this.charC.getLength();
        }
        if (this.type == 1) {
            return this.strValue.length();
        }
        this.toString();
        if (this.strValue == null) {
            return 0;
        }
        return this.strValue.length();
    }

    public boolean equals(String string) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return string == null;
                }
                return this.strValue.equals(string);
            }
            case 3: {
                return this.charC.equals(string);
            }
            case 2: {
                return this.byteC.equals(string);
            }
        }
        return false;
    }

    public boolean equalsIgnoreCase(String string) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return string == null;
                }
                return this.strValue.equalsIgnoreCase(string);
            }
            case 3: {
                return this.charC.equalsIgnoreCase(string);
            }
            case 2: {
                return this.byteC.equalsIgnoreCase(string);
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof MessageBytes) {
            return this.equals((MessageBytes)object);
        }
        return false;
    }

    public boolean equals(MessageBytes messageBytes) {
        if (this.type == 1) {
            return messageBytes.equals(this.strValue);
        }
        if (messageBytes.type != 3 && messageBytes.type != 2) {
            return this.equals(messageBytes.toString());
        }
        if (messageBytes.type == 3 && this.type == 3) {
            return this.charC.equals(messageBytes.charC);
        }
        if (messageBytes.type == 2 && this.type == 2) {
            return this.byteC.equals(messageBytes.byteC);
        }
        if (messageBytes.type == 3 && this.type == 2) {
            return this.byteC.equals(messageBytes.charC);
        }
        if (messageBytes.type == 2 && this.type == 3) {
            return messageBytes.byteC.equals(this.charC);
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String string, int n) {
        switch (this.type) {
            case 1: {
                if (this.strValue == null) {
                    return false;
                }
                if (this.strValue.length() < n + string.length()) {
                    return false;
                }
                for (int i = 0; i < string.length(); ++i) {
                    if (Ascii.toLower(string.charAt(i)) == Ascii.toLower(this.strValue.charAt(n + i))) continue;
                    return false;
                }
                return true;
            }
            case 3: {
                return this.charC.startsWithIgnoreCase(string, n);
            }
            case 2: {
                return this.byteC.startsWithIgnoreCase(string, n);
            }
        }
        return false;
    }

    public int hashCode() {
        int n;
        if (this.hasHashCode) {
            return this.hashCode;
        }
        this.hashCode = n = this.hash();
        this.hasHashCode = true;
        return n;
    }

    private int hash() {
        int n = 0;
        switch (this.type) {
            case 1: {
                for (int i = 0; i < this.strValue.length(); ++i) {
                    n = n * 37 + this.strValue.charAt(i);
                }
                return n;
            }
            case 3: {
                return this.charC.hash();
            }
            case 2: {
                return this.byteC.hash();
            }
        }
        return 0;
    }

    public int indexOf(String string, int n) {
        this.toString();
        return this.strValue.indexOf(string, n);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOfIgnoreCase(String string, int n) {
        this.toString();
        String string2 = this.strValue.toUpperCase(Locale.ENGLISH);
        String string3 = string.toUpperCase(Locale.ENGLISH);
        return string2.indexOf(string3, n);
    }

    public void duplicate(MessageBytes messageBytes) throws IOException {
        switch (messageBytes.getType()) {
            case 2: {
                this.type = 2;
                ByteChunk byteChunk = messageBytes.getByteChunk();
                this.byteC.allocate(2 * byteChunk.getLength(), -1);
                this.byteC.append(byteChunk);
                break;
            }
            case 3: {
                this.type = 3;
                CharChunk charChunk = messageBytes.getCharChunk();
                this.charC.allocate(2 * charChunk.getLength(), -1);
                this.charC.append(charChunk);
                break;
            }
            case 1: {
                this.type = 1;
                String string = messageBytes.getString();
                this.setString(string);
            }
        }
        this.setCharset(messageBytes.getCharset());
    }

    public void setLong(long l) {
        int n;
        this.byteC.allocate(32, 64);
        long l2 = l;
        byte[] byArray = this.byteC.getBuffer();
        int n2 = 0;
        int n3 = 0;
        if (l == 0L) {
            byArray[n3++] = 48;
        }
        if (l < 0L) {
            l2 = -l;
            byArray[n3++] = 45;
        }
        while (l2 > 0L) {
            n = (int)(l2 % 10L);
            l2 /= 10L;
            byArray[n3++] = HexUtils.getHex(n);
        }
        this.byteC.setStart(0);
        this.byteC.setEnd(n3);
        --n3;
        if (l < 0L) {
            ++n2;
        }
        while (n3 > n2) {
            n = byArray[n2];
            byArray[n2] = byArray[n3];
            byArray[n3] = n;
            ++n2;
            --n3;
        }
        this.longValue = l;
        this.hasHashCode = false;
        this.hasLongValue = true;
        this.type = 2;
    }

    public long getLong() {
        if (this.hasLongValue) {
            return this.longValue;
        }
        this.longValue = this.type == 2 ? this.byteC.getLong() : Long.parseLong(this.toString());
        this.hasLongValue = true;
        return this.longValue;
    }

    private static class MessageBytesFactory {
        protected MessageBytesFactory() {
        }

        public MessageBytes newInstance() {
            return new MessageBytes();
        }
    }
}

