/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.RequestProcessor;

public class ModuleInstallerSupport {
    private static RequestProcessor RP = new RequestProcessor(ModuleInstallerSupport.class.getName(), 1);
    private static final Logger LOG = Logger.getLogger(ModuleInstallerSupport.class.getName());
    private final Object[] closingOptions;
    private Object[] fullClosingOptions;
    private JButton tryAgain;
    private JButton proxySettings;

    public ModuleInstallerSupport(Object ... objectArray) {
        this.closingOptions = (Object[])objectArray.clone();
    }

    public Object installPlugins(String string, Set<String> set) throws OperationException {
        Object object;
        Object object2;
        ProgressHandle progressHandle;
        String string2;
        Object object3;
        Collection<UpdateUnit> collection = this.findModules(set);
        if (collection == null) {
            object3 = string != null ? Bundle.searching_handle_single(string) : Bundle.searching_handle();
            string2 = string != null ? Bundle.resolve_title_single(string) : Bundle.resolve_title();
            progressHandle = ProgressHandle.createHandle((String)object3);
            this.initButtons();
            object2 = new DialogDescriptor((Object)ModuleInstallerSupport.searchingPanel(new JLabel((String)object3), ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle)), string2, true, null);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            object2.setOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
            object2.setMessageType(-1);
            object = DialogDisplayer.getDefault().createDialog((DialogDescriptor)object2);
            RP.post(new Runnable((Dialog)object, string2, (DialogDescriptor)object2){
                final /* synthetic */ Dialog val$dlg;
                final /* synthetic */ String val$resolveTitle;
                final /* synthetic */ DialogDescriptor val$searching;
                {
                    this.val$dlg = dialog;
                    this.val$resolveTitle = string;
                    this.val$searching = dialogDescriptor;
                }

                @Override
                public void run() {
                    block6: {
                        try {
                            for (UpdateUnitProvider updateUnitProvider : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                                updateUnitProvider.refresh(progressHandle, true);
                            }
                            this.val$dlg.dispose();
                        }
                        catch (IOException iOException) {
                            LOG.log(Level.FINE, iOException.getMessage(), iOException);
                            if (!this.val$dlg.isVisible()) {
                                LOG.fine("dialog not visible => do nothing");
                                return;
                            }
                            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(this.val$resolveTitle, Bundle.networkproblem_message()), Bundle.networkproblem_header(), true, null);
                            dialogDescriptor.setOptions(new Object[]{ModuleInstallerSupport.this.tryAgain, ModuleInstallerSupport.this.proxySettings, NotifyDescriptor.CANCEL_OPTION});
                            dialogDescriptor.setAdditionalOptions(ModuleInstallerSupport.this.closingOptions);
                            dialogDescriptor.setClosingOptions(ModuleInstallerSupport.this.fullClosingOptions);
                            dialogDescriptor.setMessageType(2);
                            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                            dialog.setVisible(true);
                            Object object = dialogDescriptor.getValue();
                            if (NotifyDescriptor.CANCEL_OPTION.equals(object) || Arrays.asList(ModuleInstallerSupport.this.closingOptions).contains(object) || object.equals(-1)) {
                                LOG.fine("cancel network problem dialog");
                                this.val$searching.setValue(object);
                                this.val$dlg.dispose();
                            }
                            if (ModuleInstallerSupport.this.tryAgain.equals(object)) {
                                LOG.fine("try again searching");
                                RP.post((Runnable)this);
                            }
                            if ($assertionsDisabled) break block6;
                            throw new AssertionError((Object)("Unknown " + object));
                        }
                    }
                }
            });
            ((Dialog)object).setVisible(true);
            progressHandle.finish();
            if (NotifyDescriptor.CANCEL_OPTION.equals(object2.getValue()) || object2.getValue().equals(-1)) {
                LOG.log(Level.FINE, "user canceled searching for {0}", set);
                return this.showNoDownloadDialog(string, set);
            }
            if (Arrays.asList(this.closingOptions).contains(object2.getValue())) {
                return object2.getValue();
            }
            collection = this.findModules(set);
            if (collection == null) {
                LOG.log(Level.FINE, "could not find {0} on any update site", set);
                return this.showNoDownloadDialog(string, set);
            }
        }
        object3 = new ArrayList<UpdateUnit>(collection);
        string2 = null;
        progressHandle = object3.iterator();
        while (progressHandle.hasNext()) {
            object2 = (UpdateUnit)progressHandle.next();
            if (object2.getInstalled() == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(object2.getInstalled() + " already installed. Is active? " + object2.getInstalled().isEnabled());
            }
            if (object2.getInstalled().isEnabled()) {
                progressHandle.remove();
                continue;
            }
            if (string2 == null) {
                string2 = OperationContainer.createForEnable();
            }
            if (!string2.canBeAdded((UpdateUnit)object2, object2.getInstalled())) {
                throw new OperationException(OperationException.ERROR_TYPE.ENABLE, "could not add " + object2.getInstalled() + " for activation");
            }
            for (List list : string2.add(object2.getInstalled()).getRequiredElements()) {
                string2.add((UpdateElement)list);
            }
            progressHandle.remove();
        }
        if (string2 != null) {
            progressHandle = ProgressHandleFactory.createHandle((String)(string != null ? Bundle.active_handle_single(string) : Bundle.active_handle()));
            object2 = ((OperationSupport)string2.getSupport()).doOperation(progressHandle);
            assert (object2 == null) : "No Restater need to make units active";
        }
        if (object3.isEmpty()) {
            return null;
        }
        progressHandle = OperationContainer.createForInstall();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            List list;
            object = (UpdateUnit)object2.next();
            list = object.getAvailableUpdates();
            if (list.isEmpty()) {
                throw new OperationException(OperationException.ERROR_TYPE.INSTALL, "no updates for " + object);
            }
            UpdateElement updateElement = (UpdateElement)list.get(0);
            if (!progressHandle.canBeAdded((UpdateUnit)object, updateElement)) {
                throw new OperationException(OperationException.ERROR_TYPE.INSTALL, "could not add " + updateElement + " to updates");
            }
            for (UpdateElement updateElement2 : progressHandle.add(updateElement).getRequiredElements()) {
                progressHandle.add(updateElement2);
            }
            object2.remove();
        }
        assert (object3.isEmpty()) : "These unit were not handled " + object3;
        if (!PluginManager.openInstallWizard((OperationContainer<InstallSupport>)progressHandle)) {
            LOG.fine("user canceled PM");
            return this.showNoDownloadDialog(string, set);
        }
        return null;
    }

    private Collection<UpdateUnit> findModules(Set<String> set) {
        ArrayList<UpdateUnit> arrayList = new ArrayList<UpdateUnit>(set.size());
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!set.contains(updateUnit.getCodeName())) continue;
            arrayList.add(updateUnit);
            if (arrayList.size() != set.size()) continue;
            break;
        }
        if (arrayList.size() == set.size()) {
            return arrayList;
        }
        return null;
    }

    private void initButtons() {
        if (this.tryAgain != null) {
            return;
        }
        this.tryAgain = new JButton();
        this.proxySettings = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.tryAgain, (String)Bundle.tryagain_button());
        Mnemonics.setLocalizedText((AbstractButton)this.proxySettings, (String)Bundle.proxy_button());
        this.proxySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOG.fine("show proxy options");
                OptionsDisplayer.getDefault().open("General");
            }
        });
        this.fullClosingOptions = new Object[this.closingOptions.length + 2];
        System.arraycopy(this.closingOptions, 0, this.fullClosingOptions, 0, this.closingOptions.length);
        this.fullClosingOptions[this.fullClosingOptions.length - 2] = this.tryAgain;
        this.fullClosingOptions[this.fullClosingOptions.length - 1] = NotifyDescriptor.CANCEL_OPTION;
    }

    private Object showNoDownloadDialog(String string, Set<String> set) throws OperationException {
        DialogDescriptor dialogDescriptor = string != null ? new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(Bundle.nodownload_header_single(string), Bundle.nodownload_message_single(string)), Bundle.resolve_title_single(string), true, null) : new DialogDescriptor((Object)ModuleInstallerSupport.problemPanel(Bundle.nodownload_header(), Bundle.nodownload_message()), Bundle.resolve_title(), true, null);
        this.initButtons();
        dialogDescriptor.setOptions(new Object[]{this.tryAgain, NotifyDescriptor.CANCEL_OPTION});
        dialogDescriptor.setAdditionalOptions(this.closingOptions);
        dialogDescriptor.setClosingOptions(this.fullClosingOptions);
        dialogDescriptor.setMessageType(2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        Object object = dialogDescriptor.getValue();
        if (NotifyDescriptor.CANCEL_OPTION.equals(object) || Arrays.asList(this.closingOptions).contains(object) || object.equals(-1)) {
            LOG.fine("cancel no download dialog");
            return object;
        }
        if (this.tryAgain.equals(object)) {
            LOG.fine("try again download()");
            return this.installPlugins(string, set);
        }
        assert (false) : "Unknown " + object;
        assert (false) : "Unknown " + object;
        return -1;
    }

    private static JPanel searchingPanel(JLabel jLabel, JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jLabel.setLabelFor(jComponent);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jComponent, GroupLayout.Alignment.LEADING, -1, 399, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(96, 96, 96).addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jComponent, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
        return jPanel;
    }

    private static JPanel problemPanel(String string, String string2) {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        JTextArea jTextArea = new JTextArea();
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() | 1));
        jLabel.setText(string);
        jTextArea.setColumns(20);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setRows(5);
        jTextArea.setText(string2);
        jTextArea.setOpaque(false);
        jScrollPane.setViewportView(jTextArea);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jScrollPane, -1, 478, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel).addGap(107, 107, 107))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jScrollPane, -1, 133, Short.MAX_VALUE).addGap(82, 82, 82)));
        return jPanel;
    }
}

