/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.global.CalibrationDataFileIO;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.api.JavaPlatform;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.spi.JavaPlatformManagerProvider;
import org.graalvm.visualvm.lib.profiler.spi.JavaPlatformProvider;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class RunCalibrationAction
extends AbstractAction {
    private static final HelpCtx HELP_CTX = new HelpCtx("ManageCalibration.HelpCtx");

    public RunCalibrationAction() {
        this.putValue("Name", Bundle.LBL_RunCalibrationAction());
        this.putValue("ShortDescription", Bundle.HINT_RunCalibrationAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List platforms = JavaPlatform.getPlatforms();
        Object[] columnNames = new String[]{Bundle.LBL_JavaPlatform(), Bundle.LBL_LastCalibrated()};
        Object[][] columnData = new Object[platforms.size()][2];
        for (int i = 0; i < platforms.size(); ++i) {
            columnData[i] = new Object[]{platforms.get(i), null};
        }
        final DefaultTableModel model = new DefaultTableModel(columnData, columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.displayUI(model);
            }
        });
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.refreshTimes(model);
            }
        });
    }

    private void displayUI(TableModel model) {
        final ProfilerTable table = new ProfilerTable(model, false, true, null);
        table.getColumnModel().getColumn(1).setCellRenderer(new CalibrationDateCellRenderer());
        table.setDefaultColumnWidth(this.getColumnWidth());
        table.setSortColumn(0);
        table.setPreferredScrollableViewportSize(new Dimension(400, 10));
        table.setVisibleRows(6);
        table.setColumnToolTips(new String[]{Bundle.TTP_PlatformName(), Bundle.TTP_CalibrationDate()});
        ProfilerTableContainer container = new ProfilerTableContainer(table, true, null);
        container.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)Bundle.LBL_JavaPlatformsForProfiling());
        label.setLabelFor((Component)table);
        label.setBorder(BorderFactory.createEmptyBorder(15, 10, 5, 10));
        final JButton calibrate = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                RunCalibrationAction.this.calibrate(table);
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)calibrate, (String)Bundle.LBL_Calibrate());
        JButton platforms = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                JavaPlatform.showCustomizer();
                RunCalibrationAction.this.refreshModel(table);
            }
        };
        Mnemonics.setLocalizedText((AbstractButton)platforms, (String)Bundle.LBL_JavaPlatforms());
        JPanel buttons = new JPanel(new FlowLayout(3, 10, 10));
        buttons.add(calibrate);
        buttons.add(platforms);
        table.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunCalibrationAction.this.calibrate(table);
            }
        });
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (table.getSelectedRow() != -1) {
                    boolean remote = RunCalibrationAction.isRemotePlatform((JavaPlatform)table.getValueAt(table.getSelectedRow(), table.convertColumnIndexToView(0)));
                    if (remote) {
                        calibrate.setToolTipText(Bundle.HINT_CalibrateDisabled());
                    } else {
                        calibrate.setToolTipText("");
                    }
                    calibrate.setEnabled(!remote);
                }
            }
        });
        calibrate.setEnabled(false);
        table.clearSelection();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)container, "Center");
        panel.add((Component)buttons, "South");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.HINT_RunCalibrationAction(), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, HELP_CTX, null);
        DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
    }

    private int getColumnWidth() {
        int width = new JLabel((String)new StringBuilder().append((String)Bundle.LBL_LastCalibrated()).append((String)"XXX").toString()).getPreferredSize().width;
        width = Math.max(width, new JLabel((String)new StringBuilder().append((String)Bundle.LBL_NotCalibrated()).append((String)"XXX").toString()).getPreferredSize().width);
        width = Math.max(width, new JLabel((String)new StringBuilder().append((String)DateFormat.getDateInstance().format((Date)new Date())).append((String)"XXX").toString()).getPreferredSize().width);
        width = Math.max(width, new JLabel((String)new StringBuilder().append((String)DateFormat.getTimeInstance().format((Date)new Date())).append((String)"XXX").toString()).getPreferredSize().width);
        return width;
    }

    private void refreshTimes(final TableModel model) {
        int i = 0;
        while (i < model.getRowCount()) {
            File f3;
            JavaPlatform platform = (JavaPlatform)model.getValueAt(i, 0);
            boolean remote = RunCalibrationAction.isRemotePlatform(platform);
            String version = platform.getPlatformJDKVersion();
            Long modified = null;
            if (remote) {
                try {
                    f3 = new File(CalibrationDataFileIO.getCalibrationDataFileName((String)version) + "." + (String)platform.getProperties().get("platform.host"));
                    if (f3.isFile()) {
                        modified = f3.lastModified();
                    }
                }
                catch (Exception f2) {}
            } else {
                try {
                    f3 = new File(CalibrationDataFileIO.getCalibrationDataFileName((String)version));
                    if (f3.isFile()) {
                        modified = f3.lastModified();
                    }
                }
                catch (Exception f3) {
                    // empty catch block
                }
            }
            final int index = i++;
            final Long _modified = modified;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    model.setValueAt(_modified, index, 1);
                }
            });
        }
    }

    private void refreshModel(ProfilerTable table) {
        Object selected = null;
        HashSet<Object> original = new HashSet<Object>();
        int selrow = table.getSelectedRow();
        int column = table.convertColumnIndexToView(0);
        for (int row = 0; row < table.getRowCount(); ++row) {
            Object value = table.getValueAt(row, column);
            original.add(value);
            if (row != selrow) continue;
            selected = value;
        }
        final DefaultTableModel model = (DefaultTableModel)table.getModel();
        Vector<Vector> data = model.getDataVector();
        data.clear();
        for (JavaPlatform platform : JavaPlatform.getPlatforms()) {
            data.add(new Vector<JavaPlatform>(Arrays.asList(platform, null)));
            if (original.contains(platform)) continue;
            selected = platform;
        }
        table.clearSelection();
        model.fireTableDataChanged();
        if (selected != null) {
            table.selectValue(selected, column, true);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.refreshTimes(model);
            }
        });
    }

    private void calibrate(ProfilerTable table) {
        int row = table.getSelectedRow();
        if (row == -1) {
            return;
        }
        int col = table.convertColumnIndexToView(0);
        final JavaPlatform platform = (JavaPlatform)table.getValueAt(row, col);
        final DefaultTableModel model = (DefaultTableModel)table.getModel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RunCalibrationAction.this.calibrate(platform, model);
            }
        });
    }

    private static boolean isRemotePlatform(JavaPlatform platform) {
        JavaPlatformManagerProvider impl = (JavaPlatformManagerProvider)Lookup.getDefault().lookup(JavaPlatformManagerProvider.class);
        if (impl == null) {
            ProfilerUtils.getProfilerErrorManager().log(Level.WARNING.intValue(), "No instance of JavaPlatformManagerProvider found in Lookup");
            return false;
        }
        for (JavaPlatformProvider jpp : impl.getPlatforms()) {
            if (platform.getPlatformId() == null || !platform.getPlatformId().equals(jpp.getPlatformId()) || !platform.getProperties().containsKey("platform.host")) continue;
            return true;
        }
        return false;
    }

    private void calibrate(final JavaPlatform platform, final TableModel model) {
        int state = Profiler.getDefault().getProfilingState();
        int mode = Profiler.getDefault().getProfilingMode();
        boolean terminate = false;
        boolean detach = false;
        if (state == 8 || state == 4) {
            if (mode == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_CalibrationOnProfile(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                terminate = true;
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.MSG_CalibrationOnAttach(), (String)Bundle.CAPTION_Question())) {
                    return;
                }
                detach = true;
            }
        }
        final boolean doDetach = detach;
        final boolean doStop = terminate;
        ProfilerUtils.getProfilerRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                if (doDetach) {
                    Profiler.getDefault().detachFromApp();
                } else if (doStop) {
                    Profiler.getDefault().stopApp();
                }
                boolean calibrated = Profiler.getDefault().runCalibration(false, platform.getPlatformJavaFile(), platform.getPlatformJDKVersion(), platform.getPlatformArchitecture());
                RunCalibrationAction.this.refreshTimes(model);
                if (!calibrated) {
                    ProfilerDialogs.displayError((String)Bundle.MSG_CalibrationFailed());
                }
            }
        }, 0, 10);
    }

    private static class CalibrationDateCellRenderer
    extends DefaultTableCellRenderer {
        private static Calendar CALENDAR;
        private static int REF_DAY_OF_YEAR;
        private static int DAY_OF_YEAR;
        private static int YEAR;
        private static int ERA;
        private static Date DATE;
        private static DateFormat FORMAT_TIME;
        private static DateFormat FORMAT_DATE;

        CalibrationDateCellRenderer() {
            this.setHorizontalAlignment(11);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                this.setText(Bundle.LBL_NotCalibrated());
            } else {
                long time = (Long)value;
                this.setValue(time, CalibrationDateCellRenderer.isToday(time));
            }
        }

        private void setValue(long time, boolean today) {
            DateFormat format;
            if (today) {
                if (FORMAT_TIME == null) {
                    FORMAT_TIME = DateFormat.getTimeInstance();
                }
                format = FORMAT_TIME;
            } else {
                if (FORMAT_DATE == null) {
                    FORMAT_DATE = DateFormat.getDateInstance();
                }
                format = FORMAT_DATE;
            }
            if (DATE == null) {
                DATE = new Date();
            }
            DATE.setTime(time);
            this.setText(format.format(DATE));
        }

        private static boolean isToday(long time) {
            if (REF_DAY_OF_YEAR != -1 && CALENDAR.get(6) != REF_DAY_OF_YEAR) {
                CALENDAR = null;
            }
            if (CALENDAR == null) {
                CalibrationDateCellRenderer.initializeCalendar();
            }
            CALENDAR.setTimeInMillis(time);
            return DAY_OF_YEAR == CALENDAR.get(6) && YEAR == CALENDAR.get(1) && ERA == CALENDAR.get(0);
        }

        private static void initializeCalendar() {
            CALENDAR = Calendar.getInstance();
            DAY_OF_YEAR = CALENDAR.get(6);
            YEAR = CALENDAR.get(1);
            ERA = CALENDAR.get(0);
            if (REF_DAY_OF_YEAR == -1) {
                REF_DAY_OF_YEAR = DAY_OF_YEAR;
            }
        }

        static {
            REF_DAY_OF_YEAR = -1;
            DAY_OF_YEAR = -1;
            YEAR = -1;
            ERA = -1;
        }
    }
}

