/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.actions;

import javax.swing.SwingUtilities;
import org.graalvm.visualvm.lib.common.Profiler;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.profiler.actions.Bundle;
import org.graalvm.visualvm.lib.profiler.actions.ProfilingAwareAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.utilities.ProfilerUtils;
import org.openide.util.HelpCtx;

public final class RunGCAction
extends ProfilingAwareAction {
    private static final int[] ENABLED_STATES = new int[]{4};

    public static RunGCAction getInstance() {
        return Singleton.INSTANCE;
    }

    protected RunGCAction() {
        this.setIcon(Icons.getIcon((String)"ProfilerIcons.RunGC"));
        this.putValue("iconBase", Icons.getResource((String)"ProfilerIcons.RunGC"));
        this.putProperty("ShortDescription", Bundle.HINT_RunGCAction());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return Bundle.LBL_RunGCAction();
    }

    public void performAction() {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Profiler.getDefault().getTargetAppRunner().runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProfilerDialogs.displayWarning((String)e.getMessage());
                        }
                    });
                    ProfilerLogger.log((String)e.getMessage());
                }
            }
        });
    }

    @Override
    protected int[] enabledStates() {
        return ENABLED_STATES;
    }

    private static final class Singleton {
        private static final RunGCAction INSTANCE = new RunGCAction();

        private Singleton() {
        }
    }
}

