/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.swing.renderer;

import java.text.Format;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.swing.renderer.FormattedLabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.RelativeRenderer;

public class PercentRenderer
extends FormattedLabelRenderer
implements RelativeRenderer {
    private static final String NUL = Formatters.percentFormat().format(0);
    private static final String NAN = NUL.replace('0', '-');
    private long maxValue = 100L;
    protected boolean renderingDiff;

    public PercentRenderer() {
        super(Formatters.percentFormat());
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setDiffMode(boolean diffMode) {
        this.renderingDiff = diffMode;
    }

    @Override
    public boolean isDiffMode() {
        return this.renderingDiff;
    }

    @Override
    protected String getValueString(Object value, int row, Format format) {
        if (value == null) {
            return "-";
        }
        StringBuilder s = new StringBuilder();
        s.append("(");
        if (this.maxValue == 0L) {
            s.append(NAN);
        } else {
            double number = ((Number)value).doubleValue();
            if (number == 0.0) {
                if (this.renderingDiff) {
                    s.append('+');
                }
                s.append(NUL);
            } else {
                number /= (double)this.maxValue;
                if (this.renderingDiff && number > 0.0) {
                    s.append('+');
                }
                s.append(format.format(number));
            }
        }
        s.append(")");
        return s.toString();
    }
}

