/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.api;

import org.graalvm.visualvm.lib.profiler.spi.ProfilerDialogsProvider;
import org.openide.util.Lookup;

public final class ProfilerDialogs {
    public static void displayInfo(String message) {
        ProfilerDialogs.displayInfo(message, null, null);
    }

    public static void displayInfo(String message, String caption, String details) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            p.displayInfo(message, caption, details);
        }
    }

    public static void displayInfoDNSA(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            p.displayInfoDNSA(message, caption, dnsaMessage, key, dnsaDefault);
        }
    }

    public static void displayWarning(String message) {
        ProfilerDialogs.displayWarning(message, null, null);
    }

    public static void displayWarning(String message, String caption, String details) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            p.displayWarning(message, caption, details);
        }
    }

    public static void displayWarningDNSA(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            p.displayWarningDNSA(message, caption, dnsaMessage, key, dnsaDefault);
        }
    }

    public static void displayError(String message) {
        ProfilerDialogs.displayError(message, null, null);
    }

    public static void displayError(String message, String caption, String details) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            p.displayError(message, caption, details);
        }
    }

    public static boolean displayConfirmation(String message) {
        return ProfilerDialogs.displayConfirmation(message, null);
    }

    public static boolean displayConfirmation(String message, String caption) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            return Boolean.TRUE.equals(p.displayConfirmation(message, caption, false));
        }
        return false;
    }

    public static Boolean displayCancellableConfirmation(String message, String caption) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            return p.displayConfirmation(message, caption, true);
        }
        return false;
    }

    public static boolean displayConfirmationDNSA(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            return Boolean.TRUE.equals(p.displayConfirmationDNSA(message, caption, dnsaMessage, false, key, dnsaDefault));
        }
        return false;
    }

    public static Boolean displayCancellableConfirmationDNSA(String message, String caption, String dnsaMessage, String key, boolean dnsaDefault) {
        ProfilerDialogsProvider p = ProfilerDialogs.provider();
        if (p != null) {
            return p.displayConfirmationDNSA(message, caption, dnsaMessage, true, key, dnsaDefault);
        }
        return false;
    }

    private static ProfilerDialogsProvider provider() {
        return (ProfilerDialogsProvider)Lookup.getDefault().lookup(ProfilerDialogsProvider.class);
    }
}

