/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.SocketException;
import com.zeroc.Ice.UDPConnectionInfo;
import com.zeroc.IceInternal.BufSizeWarnInfo;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceInternal.UdpEndpointI;
import com.zeroc.IceUtilInternal.Assert;
import com.zeroc.IceUtilInternal.StringUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;
import java.util.List;

final class UdpMulticastServerTransceiver
implements Transceiver {
    private UdpEndpointI _endpoint = null;
    private ProtocolInstance _instance;
    private int _size;
    private int _newSize;
    private MulticastSocket _socket;
    private InetSocketAddress _addr;
    private String _mcastInterface;
    private static final int _udpOverhead = 28;
    private static final int _threshold = 10;
    private Thread _thread;
    private LinkedList<Buffer> _buffers = new LinkedList();
    private LinkedList<Buffer> _recycle = new LinkedList();
    private LocalException _exception;
    private ReadyCallback _readyCallback;

    @Override
    public SelectableChannel fd() {
        return null;
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
        assert (this._readyCallback == null && callback != null);
        this._readyCallback = callback;
        this._thread.start();
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer) {
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Thread thread;
        UdpMulticastServerTransceiver udpMulticastServerTransceiver = this;
        synchronized (udpMulticastServerTransceiver) {
            if (this._socket != null) {
                this._socket.close();
                this._socket = null;
            }
            thread = this._thread;
            this._thread = null;
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public EndpointI bind() {
        this._endpoint = this._endpoint.endpoint(this);
        return this._endpoint;
    }

    @Override
    public int write(Buffer buf) {
        throw new SocketException();
    }

    @Override
    public synchronized int read(Buffer buf) {
        if (this._exception != null) {
            throw this._exception;
        }
        assert (buf.b.position() == 0);
        if (!this._buffers.isEmpty()) {
            Buffer rb = this._buffers.removeFirst();
            buf.swap(rb);
            buf.position(buf.b.limit());
            buf.resize(buf.b.limit(), true);
            if (rb.b.hasArray()) {
                rb.b.clear();
                this._recycle.add(rb);
            }
            if (this._buffers.size() == 9) {
                this.notifyAll();
            }
            this._readyCallback.ready(1, !this._buffers.isEmpty());
        }
        return 0;
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public synchronized String toString() {
        if (this._socket == null) {
            return "<closed>";
        }
        return "multicast address = " + Network.addrToString(this._addr);
    }

    @Override
    public String toDetailedString() {
        StringBuilder s = new StringBuilder(this.toString());
        List<String> intfs = Network.getInterfacesForMulticast(this._mcastInterface, Network.getProtocolSupport(this._addr));
        if (!intfs.isEmpty()) {
            s.append("\nlocal interfaces = ");
            s.append(StringUtil.joinString(intfs, ", "));
        }
        return s.toString();
    }

    @Override
    public synchronized ConnectionInfo getInfo() {
        UDPConnectionInfo info = new UDPConnectionInfo();
        if (this._socket != null) {
            info.localAddress = this._addr.getAddress().getHostAddress();
            info.localPort = this._addr.getPort();
            info.rcvSize = this._size;
            info.mcastAddress = this._addr.getAddress().getHostAddress();
            info.mcastPort = this._addr.getPort();
        }
        return info;
    }

    @Override
    public void checkSendSize(Buffer buf) {
    }

    @Override
    public synchronized void setBufferSize(int rcvSize, int sndSize) {
        this.setBufSize(rcvSize);
    }

    public final int effectivePort() {
        return this._addr.getPort();
    }

    UdpMulticastServerTransceiver(UdpEndpointI endpoint, ProtocolInstance instance, InetSocketAddress addr, String mcastInterface) {
        this._endpoint = endpoint;
        this._instance = instance;
        this._mcastInterface = mcastInterface;
        this._addr = addr;
        try {
            this._socket = new MulticastSocket(this._addr);
            this._addr = (InetSocketAddress)this._socket.getLocalSocketAddress();
            Network.setMcastGroup(this._socket, this._addr, this._mcastInterface);
            this._size = this._socket.getReceiveBufferSize();
            this._newSize = -1;
            this.setBufSize(-1);
            if (this._newSize != -1) {
                this.updateBufSize();
            }
            this._thread = new Thread(){

                @Override
                public void run() {
                    this.setName("IceUDPMulticast.ReadThread");
                    UdpMulticastServerTransceiver.this.runReadThread();
                }
            };
        }
        catch (Exception ex) {
            if (this._socket != null) {
                this._socket.close();
            }
            this._socket = null;
            if (ex instanceof LocalException) {
                throw (LocalException)ex;
            }
            throw new SocketException(ex);
        }
    }

    private synchronized void exception(LocalException ex) {
        if (this._exception == null) {
            this._exception = ex;
        }
    }

    private void setBufSize(int sz) {
        assert (this._socket != null);
        if (sz == -1) {
            sz = this._instance.properties().getPropertyAsIntWithDefault("Ice.UDP.RcvSize", this._size);
        }
        if (sz < 42) {
            this._instance.logger().warning("Invalid Ice.UDP.RcvSize value of " + sz + " adjusted to " + this._size);
        } else if (sz != this._size) {
            this._newSize = sz;
        }
    }

    private void updateBufSize() {
        try {
            this._socket.setReceiveBufferSize(this._newSize);
            this._size = this._socket.getReceiveBufferSize();
            if (this._size < this._newSize) {
                BufSizeWarnInfo winfo = this._instance.getBufSizeWarn((short)3);
                if (!winfo.rcvWarn || winfo.rcvSize != this._newSize) {
                    this._instance.logger().warning("UDP receive buffer size: requested size of " + this._newSize + " adjusted to " + this._size);
                    this._instance.setRcvBufSizeWarn((short)3, this._newSize);
                }
            }
        }
        catch (IOException ex) {
            if (this._socket != null) {
                this._socket.close();
            }
            this._socket = null;
            throw new SocketException(ex);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._socket == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runReadThread() {
        try {
            DatagramPacket p = null;
            while (true) {
                Buffer buf = null;
                UdpMulticastServerTransceiver udpMulticastServerTransceiver = this;
                // MONITORENTER : udpMulticastServerTransceiver
                while (this._socket != null && this._exception == null && this._buffers.size() >= 10) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this._socket == null || this._exception != null) {
                    // MONITOREXIT : udpMulticastServerTransceiver
                    return;
                }
                if (this._newSize != -1) {
                    this.updateBufSize();
                    this._newSize = -1;
                }
                MulticastSocket socket = this._socket;
                buf = !this._recycle.isEmpty() ? this._recycle.removeFirst() : new Buffer(false);
                buf.resize(this._size, false);
                // MONITOREXIT : udpMulticastServerTransceiver
                assert (buf.b.hasArray());
                if (p == null) {
                    p = new DatagramPacket(buf.b.array(), buf.b.arrayOffset(), buf.b.capacity());
                } else {
                    p.setData(buf.b.array(), buf.b.arrayOffset(), buf.b.capacity());
                }
                socket.receive(p);
                if (p.getLength() <= 0) continue;
                buf.limit(p.getLength());
                udpMulticastServerTransceiver = this;
                // MONITORENTER : udpMulticastServerTransceiver
                this._buffers.add(buf);
                this._readyCallback.ready(1, true);
                // MONITOREXIT : udpMulticastServerTransceiver
            }
        }
        catch (IOException ex) {
            this.exception(new SocketException(ex));
            this._readyCallback.ready(1, true);
            return;
        }
        catch (LocalException ex) {
            this.exception(ex);
            this._readyCallback.ready(1, true);
        }
    }
}

