/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorI;
import com.zeroc.Ice.Properties;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.ProtocolPluginFacade;
import com.zeroc.IceInternal.ProtocolPluginFacadeI;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadFactory;

public final class Util {
    static String createThreadName(Properties properties, String name) {
        String threadName = properties.getProperty("Ice.ProgramName");
        if (threadName.length() > 0) {
            threadName = threadName + "-";
        }
        threadName = threadName + name;
        return threadName;
    }

    static ThreadFactory createThreadFactory(final Properties properties, final String name) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(name);
                if (properties.getProperty("Ice.ThreadPriority").length() > 0) {
                    t.setPriority(Util.getThreadPriorityProperty(properties, "Ice"));
                }
                return t;
            }
        };
    }

    public static Instance getInstance(Communicator communicator) {
        CommunicatorI p = (CommunicatorI)communicator;
        return p.getInstance();
    }

    public static ProtocolPluginFacade getProtocolPluginFacade(Communicator communicator) {
        return new ProtocolPluginFacadeI(communicator);
    }

    public static InputStream openResource(ClassLoader cl, String path) throws IOException {
        InputStream stream = null;
        try {
            stream = cl.getResourceAsStream(path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (stream == null) {
            try {
                File f = new File(path);
                if (f.exists()) {
                    stream = new FileInputStream(f);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return stream;
    }

    public static Class<?> findClass(String className, ClassLoader cl) throws LinkageError {
        Class<?> c = null;
        if (cl != null) {
            c = Util.loadClass(className, cl);
        }
        if (c == null) {
            try {
                cl = Thread.currentThread().getContextClassLoader();
                if (cl != null) {
                    c = Util.loadClass(className, cl);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            if (c == null) {
                c = Class.forName(className);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (c == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
                if (cl != null) {
                    c = Util.loadClass(className, cl);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return c;
    }

    private static Class<?> loadClass(String className, ClassLoader cl) {
        if (cl != null) {
            try {
                return cl.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThreadPriorityProperty(Properties properties, String prefix) {
        String pri = properties.getProperty(prefix + ".ThreadPriority");
        if (pri.equals("MIN_PRIORITY") || pri.equals("java.lang.Thread.MIN_PRIORITY")) {
            return 1;
        }
        if (pri.equals("NORM_PRIORITY") || pri.equals("java.lang.Thread.NORM_PRIORITY")) {
            return 5;
        }
        if (pri.equals("MAX_PRIORITY") || pri.equals("java.lang.Thread.MAX_PRIORITY")) {
            return 10;
        }
        try {
            return Integer.parseInt(pri);
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
    }

    public static boolean isAndroid() {
        return System.getProperty("java.vm.name").startsWith("Dalvik");
    }
}

