/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.AdapterAlreadyActiveException;
import com.zeroc.Ice.AdapterNotFoundException;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.InvalidReplicaGroupIdException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.ProcessPrx;
import com.zeroc.Ice.ServerNotFoundException;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;

public interface LocatorRegistry
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public CompletionStage<Void> setAdapterDirectProxyAsync(String var1, ObjectPrx var2, Current var3) throws AdapterAlreadyActiveException, AdapterNotFoundException;

    public CompletionStage<Void> setReplicatedAdapterDirectProxyAsync(String var1, String var2, ObjectPrx var3, Current var4) throws AdapterAlreadyActiveException, AdapterNotFoundException, InvalidReplicaGroupIdException;

    public CompletionStage<Void> setServerProcessProxyAsync(String var1, ProcessPrx var2, Current var3) throws ServerNotFoundException;

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return LocatorRegistry.ice_staticId();
    }

    public static String ice_staticId() {
        return "::Ice::LocatorRegistry";
    }

    public static CompletionStage<OutputStream> _iceD_setAdapterDirectProxy(LocatorRegistry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        ObjectPrx iceP_proxy = istr.readProxy();
        inS.endReadParams();
        return inS.setResultFuture(obj.setAdapterDirectProxyAsync(iceP_id, iceP_proxy, current));
    }

    public static CompletionStage<OutputStream> _iceD_setReplicatedAdapterDirectProxy(LocatorRegistry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_adapterId = istr.readString();
        String iceP_replicaGroupId = istr.readString();
        ObjectPrx iceP_p = istr.readProxy();
        inS.endReadParams();
        return inS.setResultFuture(obj.setReplicatedAdapterDirectProxyAsync(iceP_adapterId, iceP_replicaGroupId, iceP_p, current));
    }

    public static CompletionStage<OutputStream> _iceD_setServerProcessProxy(LocatorRegistry obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_id = istr.readString();
        ProcessPrx iceP_proxy = ProcessPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        return inS.setResultFuture(obj.setServerProcessProxyAsync(iceP_id, iceP_proxy, current));
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 1: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 2: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 3: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 4: {
                return LocatorRegistry._iceD_setAdapterDirectProxy(this, in, current);
            }
            case 5: {
                return LocatorRegistry._iceD_setReplicatedAdapterDirectProxy(this, in, current);
            }
            case 6: {
                return LocatorRegistry._iceD_setServerProcessProxy(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::LocatorRegistry", "::Ice::Object"};
        _iceOps = new String[]{"ice_id", "ice_ids", "ice_isA", "ice_ping", "setAdapterDirectProxy", "setReplicatedAdapterDirectProxy", "setServerProcessProxy"};
    }
}

