/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.AdapterAlreadyActiveException;
import com.zeroc.Ice.AdapterNotFoundException;
import com.zeroc.Ice.AlreadyRegisteredException;
import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.CommunicatorDestroyedException;
import com.zeroc.Ice.CompressBatch;
import com.zeroc.Ice.ConnectionI;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointParseException;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.IllegalIdentityException;
import com.zeroc.Ice.IllegalServantException;
import com.zeroc.Ice.InitializationException;
import com.zeroc.Ice.InvalidReplicaGroupIdException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LocatorPrx;
import com.zeroc.Ice.LocatorRegistryPrx;
import com.zeroc.Ice.NotRegisteredException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectAdapter;
import com.zeroc.Ice.ObjectAdapterDeactivatedException;
import com.zeroc.Ice.ObjectAdapterIdInUseException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationInterruptedException;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.ProxyParseException;
import com.zeroc.Ice.RouterPrx;
import com.zeroc.Ice.ServantLocator;
import com.zeroc.Ice._ObjectPrxI;
import com.zeroc.IceInternal.ACMConfig;
import com.zeroc.IceInternal.CommunicatorFlushBatch;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.IncomingConnectionFactory;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.LocatorInfo;
import com.zeroc.IceInternal.ObjectAdapterFactory;
import com.zeroc.IceInternal.PropertyNames;
import com.zeroc.IceInternal.Reference;
import com.zeroc.IceInternal.RouterInfo;
import com.zeroc.IceInternal.ServantManager;
import com.zeroc.IceInternal.ThreadPool;
import com.zeroc.IceInternal.TraceLevels;
import com.zeroc.IceUtilInternal.Assert;
import com.zeroc.IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ObjectAdapterI
implements ObjectAdapter {
    private static String[] _suffixes = new String[]{"ACM", "ACM.Timeout", "ACM.Heartbeat", "ACM.Close", "AdapterId", "Endpoints", "Locator", "Locator.EncodingVersion", "Locator.EndpointSelection", "Locator.ConnectionCached", "Locator.PreferSecure", "Locator.CollocationOptimized", "Locator.Router", "MessageSizeMax", "PublishedEndpoints", "ReplicaGroupId", "Router", "Router.EncodingVersion", "Router.EndpointSelection", "Router.ConnectionCached", "Router.PreferSecure", "Router.CollocationOptimized", "Router.Locator", "Router.Locator.EndpointSelection", "Router.Locator.ConnectionCached", "Router.Locator.PreferSecure", "Router.Locator.CollocationOptimized", "Router.Locator.LocatorCacheTimeout", "Router.Locator.InvocationTimeout", "Router.LocatorCacheTimeout", "Router.InvocationTimeout", "ProxyOptions", "ThreadPool.Size", "ThreadPool.SizeMax", "ThreadPool.SizeWarn", "ThreadPool.StackSize", "ThreadPool.Serialize"};
    private int _state = 0;
    private Instance _instance;
    private Communicator _communicator;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ThreadPool _threadPool;
    private ACMConfig _acm;
    private ServantManager _servantManager;
    private final String _name;
    private final String _id;
    private final String _replicaGroupId;
    private Reference _reference;
    private List<IncomingConnectionFactory> _incomingConnectionFactories = new ArrayList<IncomingConnectionFactory>();
    private RouterInfo _routerInfo = null;
    private EndpointI[] _publishedEndpoints = new EndpointI[0];
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _noConfig;
    private final int _messageSizeMax;

    @Override
    public String getName() {
        return this._noConfig ? "" : this._name;
    }

    @Override
    public Communicator getCommunicator() {
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        LocatorInfo locatorInfo = null;
        boolean printAdapterReady = false;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            if (this._state != 0) {
                for (IncomingConnectionFactory factory : this._incomingConnectionFactories) {
                    factory.activate();
                }
                return;
            }
            this._state = 2;
            locatorInfo = this._locatorInfo;
            if (!this._noConfig) {
                Properties properties = this._instance.initializationData().properties;
                printAdapterReady = properties.getPropertyAsInt("Ice.PrintAdapterReady") > 0;
            }
        }
        try {
            Identity dummy = new Identity();
            dummy.name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy(dummy));
        }
        catch (LocalException ex) {
            ObjectAdapterI objectAdapterI2 = this;
            synchronized (objectAdapterI2) {
                this._state = 0;
                this.notifyAll();
            }
            throw ex;
        }
        if (printAdapterReady) {
            System.out.println(this._name + " ready");
        }
        objectAdapterI = this;
        synchronized (objectAdapterI) {
            assert (this._state == 2);
            this._state = 3;
            this.notifyAll();
            for (IncomingConnectionFactory factory : this._incomingConnectionFactories) {
                factory.activate();
            }
        }
    }

    @Override
    public synchronized void hold() {
        this.checkForDeactivation();
        this._state = 1;
        for (IncomingConnectionFactory factory : this._incomingConnectionFactories) {
            factory.hold();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForHold() {
        ArrayList<IncomingConnectionFactory> incomingConnectionFactories;
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            incomingConnectionFactories = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        for (IncomingConnectionFactory factory : incomingConnectionFactories) {
            try {
                factory.waitUntilHolding();
            }
            catch (InterruptedException ex) {
                throw new OperationInterruptedException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        java.lang.Object object = this;
        synchronized (object) {
            while (this._state == 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException(ex);
                }
            }
            if (this._state > 4) {
                return;
            }
            this._state = 4;
        }
        try {
            if (this._routerInfo != null) {
                this._instance.routerManager().erase(this._routerInfo.getRouter());
                this._routerInfo.setAdapter(null);
            }
            this.updateLocatorRegistry(this._locatorInfo, null);
        }
        catch (LocalException localException) {
            // empty catch block
        }
        for (IncomingConnectionFactory factory : this._incomingConnectionFactories) {
            factory.destroy();
        }
        this._instance.outgoingConnectionFactory().removeAdapter(this);
        object = this;
        synchronized (object) {
            this._state = 5;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForDeactivate() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        try {
            ArrayList<IncomingConnectionFactory> incomingConnectionFactories;
            ObjectAdapterI objectAdapterI = this;
            synchronized (objectAdapterI) {
                while (this._state < 5 || this._directCount > 0) {
                    this.wait();
                }
                if (this._state > 5) {
                    return;
                }
                incomingConnectionFactories = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
            }
            for (IncomingConnectionFactory f : incomingConnectionFactories) {
                f.waitUntilFinished();
            }
        }
        catch (InterruptedException e) {
            throw new OperationInterruptedException();
        }
    }

    @Override
    public synchronized boolean isDeactivated() {
        return this._state >= 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        this.deactivate();
        this.waitForDeactivate();
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            assert (this._state >= 5);
            while (this._state == 6) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException(ex);
                }
            }
            if (this._state == 7) {
                return;
            }
            this._state = 6;
        }
        this._servantManager.destroy();
        if (this._threadPool != null) {
            this._threadPool.destroy();
            try {
                this._threadPool.joinWithAllThreads();
            }
            catch (InterruptedException e) {
                throw new OperationInterruptedException();
            }
        }
        this._objectAdapterFactory.removeObjectAdapter(this);
        objectAdapterI = this;
        synchronized (objectAdapterI) {
            this._incomingConnectionFactories.clear();
            this._instance = null;
            this._threadPool = null;
            this._routerInfo = null;
            this._publishedEndpoints = new EndpointI[0];
            this._locatorInfo = null;
            this._reference = null;
            this._objectAdapterFactory = null;
            this._state = 7;
            this.notifyAll();
        }
    }

    @Override
    public ObjectPrx add(Object object, Identity ident) {
        return this.addFacet(object, ident, "");
    }

    @Override
    public synchronized ObjectPrx addFacet(Object object, Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        ObjectAdapterI.checkServant(object);
        Identity id = new Identity();
        id.category = ident.category;
        id.name = ident.name;
        this._servantManager.addServant(object, id, facet);
        return this.newProxy(id, facet);
    }

    @Override
    public ObjectPrx addWithUUID(Object object) {
        return this.addFacetWithUUID(object, "");
    }

    @Override
    public ObjectPrx addFacetWithUUID(Object object, String facet) {
        Identity ident = new Identity();
        ident.category = "";
        ident.name = UUID.randomUUID().toString();
        return this.addFacet(object, ident, facet);
    }

    @Override
    public synchronized void addDefaultServant(Object servant, String category) {
        ObjectAdapterI.checkServant(servant);
        this.checkForDeactivation();
        this._servantManager.addDefaultServant(servant, category);
    }

    @Override
    public Object remove(Identity ident) {
        return this.removeFacet(ident, "");
    }

    @Override
    public synchronized Object removeFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeServant(ident, facet);
    }

    @Override
    public synchronized Map<String, Object> removeAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeAllFacets(ident);
    }

    @Override
    public synchronized Object removeDefaultServant(String category) {
        this.checkForDeactivation();
        return this._servantManager.removeDefaultServant(category);
    }

    @Override
    public Object find(Identity ident) {
        return this.findFacet(ident, "");
    }

    @Override
    public synchronized Object findFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findServant(ident, facet);
    }

    @Override
    public synchronized Map<String, Object> findAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findAllFacets(ident);
    }

    @Override
    public synchronized Object findByProxy(ObjectPrx proxy) {
        this.checkForDeactivation();
        Reference ref = ((_ObjectPrxI)proxy)._getReference();
        return this.findFacet(ref.getIdentity(), ref.getFacet());
    }

    @Override
    public synchronized Object findDefaultServant(String category) {
        this.checkForDeactivation();
        return this._servantManager.findDefaultServant(category);
    }

    @Override
    public synchronized void addServantLocator(ServantLocator locator, String prefix) {
        this.checkForDeactivation();
        this._servantManager.addServantLocator(locator, prefix);
    }

    @Override
    public synchronized ServantLocator removeServantLocator(String prefix) {
        this.checkForDeactivation();
        return this._servantManager.removeServantLocator(prefix);
    }

    @Override
    public synchronized ServantLocator findServantLocator(String prefix) {
        this.checkForDeactivation();
        return this._servantManager.findServantLocator(prefix);
    }

    @Override
    public synchronized ObjectPrx createProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newProxy(ident, "");
    }

    @Override
    public synchronized ObjectPrx createDirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newDirectProxy(ident, "");
    }

    @Override
    public synchronized ObjectPrx createIndirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newIndirectProxy(ident, "", this._id);
    }

    @Override
    public synchronized void setLocator(LocatorPrx locator) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locator);
    }

    @Override
    public synchronized LocatorPrx getLocator() {
        if (this._locatorInfo == null) {
            return null;
        }
        return this._locatorInfo.getLocator();
    }

    @Override
    public synchronized Endpoint[] getEndpoints() {
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (IncomingConnectionFactory factory : this._incomingConnectionFactories) {
            endpoints.add(factory.endpoint());
        }
        return endpoints.toArray(new Endpoint[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshPublishedEndpoints() {
        EndpointI[] oldPublishedEndpoints;
        LocatorInfo locatorInfo = null;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            oldPublishedEndpoints = this._publishedEndpoints;
            this._publishedEndpoints = this.computePublishedEndpoints();
            locatorInfo = this._locatorInfo;
        }
        try {
            Identity dummy = new Identity();
            dummy.name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy(dummy));
        }
        catch (LocalException ex) {
            ObjectAdapterI objectAdapterI2 = this;
            synchronized (objectAdapterI2) {
                this._publishedEndpoints = oldPublishedEndpoints;
                throw ex;
            }
        }
    }

    @Override
    public synchronized Endpoint[] getPublishedEndpoints() {
        return (Endpoint[])Arrays.copyOf(this._publishedEndpoints, this._publishedEndpoints.length, Endpoint[].class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPublishedEndpoints(Endpoint[] newEndpoints) {
        EndpointI[] oldPublishedEndpoints;
        LocatorInfo locatorInfo = null;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            if (this._routerInfo != null) {
                throw new IllegalArgumentException("can't set published endpoints on object adapter associated with a router");
            }
            oldPublishedEndpoints = this._publishedEndpoints;
            this._publishedEndpoints = (EndpointI[])Arrays.copyOf(newEndpoints, newEndpoints.length, EndpointI[].class);
            locatorInfo = this._locatorInfo;
        }
        try {
            Identity dummy = new Identity();
            dummy.name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy(dummy));
        }
        catch (LocalException ex) {
            ObjectAdapterI objectAdapterI2 = this;
            synchronized (objectAdapterI2) {
                this._publishedEndpoints = oldPublishedEndpoints;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(ObjectPrx proxy) {
        Reference ref = ((_ObjectPrxI)proxy)._getReference();
        if (ref.isWellKnown()) {
            return this._servantManager.hasServant(ref.getIdentity());
        }
        if (ref.isIndirect()) {
            return ref.getAdapterId().equals(this._id) || ref.getAdapterId().equals(this._replicaGroupId);
        }
        EndpointI[] endpoints = ref.getEndpoints();
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            for (EndpointI endpoint : endpoints) {
                for (EndpointI p : this._publishedEndpoints) {
                    if (!endpoint.equivalent(p)) continue;
                    return true;
                }
                for (IncomingConnectionFactory p : this._incomingConnectionFactories) {
                    if (!p.isLocal(endpoint)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAsyncBatchRequests(CompressBatch compressBatch, CommunicatorFlushBatch outAsync) {
        ArrayList<IncomingConnectionFactory> f;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            f = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        for (IncomingConnectionFactory p : f) {
            p.flushAsyncBatchRequests(compressBatch, outAsync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionObservers() {
        ArrayList<IncomingConnectionFactory> f;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            f = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        for (IncomingConnectionFactory p : f) {
            p.updateConnectionObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreadObservers() {
        ThreadPool threadPool = null;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            threadPool = this._threadPool;
        }
        if (threadPool != null) {
            threadPool.updateObservers();
        }
    }

    public synchronized void incDirectCount() {
        this.checkForDeactivation();
        assert (this._directCount >= 0);
        ++this._directCount;
    }

    public synchronized void decDirectCount() {
        assert (this._instance != null);
        assert (this._directCount > 0);
        if (--this._directCount == 0) {
            this.notifyAll();
        }
    }

    public ThreadPool getThreadPool() {
        assert (this._instance != null);
        if (this._threadPool != null) {
            return this._threadPool;
        }
        return this._instance.serverThreadPool();
    }

    public ServantManager getServantManager() {
        return this._servantManager;
    }

    public ACMConfig getACM() {
        assert (this._instance != null);
        return this._acm;
    }

    public synchronized void setAdapterOnConnection(ConnectionI connection) {
        this.checkForDeactivation();
        connection.setAdapterAndServantManager(this, this._servantManager);
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public ObjectAdapterI(Instance instance, Communicator communicator, ObjectAdapterFactory objectAdapterFactory, String name, RouterPrx router, boolean noConfig) {
        this._instance = instance;
        this._communicator = communicator;
        this._objectAdapterFactory = objectAdapterFactory;
        this._servantManager = new ServantManager(instance, name);
        this._name = name;
        this._directCount = 0;
        this._noConfig = noConfig;
        if (this._noConfig) {
            this._id = "";
            this._replicaGroupId = "";
            this._reference = this._instance.referenceFactory().create("dummy -t", "");
            this._acm = this._instance.serverACM();
            this._messageSizeMax = this._instance.messageSizeMax();
            return;
        }
        Properties properties = this._instance.initializationData().properties;
        ArrayList<String> unknownProps = new ArrayList<String>();
        boolean noProps = this.filterProperties(unknownProps);
        if (unknownProps.size() != 0 && properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
            StringBuffer message = new StringBuffer("found unknown properties for object adapter `");
            message.append(this._name);
            message.append("':");
            for (String p : unknownProps) {
                message.append("\n    ");
                message.append(p);
            }
            this._instance.initializationData().logger.warning(message.toString());
        }
        if (router == null && noProps) {
            this._state = 7;
            this._instance = null;
            this._incomingConnectionFactories = null;
            InitializationException ex = new InitializationException();
            ex.reason = "object adapter `" + this._name + "' requires configuration";
            throw ex;
        }
        this._id = properties.getProperty(this._name + ".AdapterId");
        this._replicaGroupId = properties.getProperty(this._name + ".ReplicaGroupId");
        String proxyOptions = properties.getPropertyWithDefault(this._name + ".ProxyOptions", "-t");
        try {
            this._reference = this._instance.referenceFactory().create("dummy " + proxyOptions, "");
        }
        catch (ProxyParseException e) {
            InitializationException ex = new InitializationException();
            ex.reason = "invalid proxy options `" + proxyOptions + "' for object adapter `" + this._name + "'";
            throw ex;
        }
        this._acm = new ACMConfig(properties, communicator.getLogger(), this._name + ".ACM", instance.serverACM());
        int defaultMessageSizeMax = instance.messageSizeMax() / 1024;
        int num = properties.getPropertyAsIntWithDefault(this._name + ".MessageSizeMax", defaultMessageSizeMax);
        this._messageSizeMax = num < 1 || num > 0x1FFFFF ? Integer.MAX_VALUE : num * 1024;
        try {
            int threadPoolSize = properties.getPropertyAsInt(this._name + ".ThreadPool.Size");
            int threadPoolSizeMax = properties.getPropertyAsInt(this._name + ".ThreadPool.SizeMax");
            if (threadPoolSize > 0 || threadPoolSizeMax > 0) {
                this._threadPool = new ThreadPool(this._instance, this._name + ".ThreadPool", 0);
            }
            if (router == null) {
                router = RouterPrx.uncheckedCast(this._instance.proxyFactory().propertyToProxy(name + ".Router"));
            }
            if (router != null) {
                this._routerInfo = this._instance.routerManager().get(router);
                assert (this._routerInfo != null);
                if (this._routerInfo.getAdapter() != null) {
                    throw new AlreadyRegisteredException("object adapter with router", this._communicator.identityToString(router.ice_getIdentity()));
                }
                this._routerInfo.setAdapter(this);
                this._instance.outgoingConnectionFactory().setRouterInfo(this._routerInfo);
            } else {
                List<EndpointI> endpoints = this.parseEndpoints(properties.getProperty(this._name + ".Endpoints"), true);
                for (EndpointI endp : endpoints) {
                    EndpointI.ExpandHostResult result = endp.expandHost();
                    for (EndpointI expanded : result.endpoints) {
                        IncomingConnectionFactory factory = new IncomingConnectionFactory(instance, expanded, result.publish, this);
                        this._incomingConnectionFactories.add(factory);
                    }
                }
                if (endpoints.isEmpty()) {
                    TraceLevels tl = this._instance.traceLevels();
                    if (tl.network >= 2) {
                        this._instance.initializationData().logger.trace(tl.networkCat, "created adapter `" + name + "' without endpoints");
                    }
                }
            }
            this._publishedEndpoints = this.computePublishedEndpoints();
            if (properties.getProperty(this._name + ".Locator").length() > 0) {
                this.setLocator(LocatorPrx.uncheckedCast(this._instance.proxyFactory().propertyToProxy(this._name + ".Locator")));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
        }
        catch (LocalException ex) {
            this.destroy();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            if (this._state < 5) {
                this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' has not been deactivated");
            } else if (this._state != 7) {
                this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' has not been destroyed");
            } else {
                Assert.FinalizerAssert(this._threadPool == null);
                Assert.FinalizerAssert(this._directCount == 0);
            }
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private ObjectPrx newProxy(Identity ident, String facet) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(ident, facet);
        }
        if (this._replicaGroupId.length() == 0) {
            return this.newIndirectProxy(ident, facet, this._id);
        }
        return this.newIndirectProxy(ident, facet, this._replicaGroupId);
    }

    private ObjectPrx newDirectProxy(Identity ident, String facet) {
        Reference ref = this._instance.referenceFactory().create(ident, facet, this._reference, this._publishedEndpoints);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    private ObjectPrx newIndirectProxy(Identity ident, String facet, String id) {
        Reference ref = this._instance.referenceFactory().create(ident, facet, this._reference, id);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    private void checkForDeactivation() {
        if (this._state >= 4) {
            ObjectAdapterDeactivatedException ex = new ObjectAdapterDeactivatedException();
            ex.name = this.getName();
            throw ex;
        }
    }

    private static void checkIdentity(Identity ident) {
        if (ident.name == null || ident.name.length() == 0) {
            throw new IllegalIdentityException(ident);
        }
        if (ident.category == null) {
            ident.category = "";
        }
    }

    private static void checkServant(Object servant) {
        if (servant == null) {
            throw new IllegalServantException("cannot add null servant to Object Adapter");
        }
    }

    private List<EndpointI> parseEndpoints(String endpts, boolean oaEndpoints) {
        String delim = " \t\n\r";
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (int end = 0; end < endpts.length(); ++end) {
            int beg = StringUtil.findFirstNotOf(endpts, " \t\n\r", end);
            if (beg == -1) {
                if (endpoints.isEmpty()) break;
                throw new EndpointParseException("invalid empty object adapter endpoint");
            }
            end = beg;
            while (true) {
                if ((end = endpts.indexOf(58, end)) == -1) {
                    end = endpts.length();
                    break;
                }
                boolean quoted = false;
                int quote = beg;
                while ((quote = endpts.indexOf(34, quote)) != -1 && end >= quote) {
                    ++quote;
                    if ((quote = endpts.indexOf(34, quote)) == -1) break;
                    if (end < quote) {
                        quoted = true;
                        break;
                    }
                    ++quote;
                }
                if (!quoted) break;
                ++end;
            }
            if (end == beg) {
                throw new EndpointParseException("invalid empty object adapter endpoint");
            }
            String s = endpts.substring(beg, end);
            EndpointI endp = this._instance.endpointFactoryManager().create(s, oaEndpoints);
            if (endp == null) {
                throw new EndpointParseException("invalid object adapter endpoint `" + s + "'");
            }
            endpoints.add(endp);
        }
        return endpoints;
    }

    private EndpointI[] computePublishedEndpoints() {
        List<java.lang.Object> endpoints;
        if (this._routerInfo != null) {
            endpoints = new ArrayList();
            for (EndpointI endpointI : this._routerInfo.getServerEndpoints()) {
                if (endpoints.contains(endpointI)) continue;
                endpoints.add(endpointI);
            }
        } else {
            String endpts = this._instance.initializationData().properties.getProperty(this._name + ".PublishedEndpoints");
            endpoints = this.parseEndpoints(endpts, false);
            if (endpoints.isEmpty()) {
                for (IncomingConnectionFactory factory : this._incomingConnectionFactories) {
                    for (EndpointI endpt : factory.endpoint().expandIfWildcard()) {
                        if (endpoints.contains(endpt)) continue;
                        endpoints.add(endpt);
                    }
                }
            }
        }
        if (this._instance.traceLevels().network >= 1 && !endpoints.isEmpty()) {
            StringBuffer s = new StringBuffer("published endpoints for object adapter `");
            s.append(this._name);
            s.append("':\n");
            boolean first = true;
            for (EndpointI endpointI : endpoints) {
                if (!first) {
                    s.append(":");
                }
                s.append(endpointI.toString());
                first = false;
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, s.toString());
        }
        return endpoints.toArray(new EndpointI[endpoints.size()]);
    }

    private void updateLocatorRegistry(LocatorInfo locatorInfo, ObjectPrx proxy) {
        if (this._id.length() == 0 || locatorInfo == null) {
            return;
        }
        LocatorRegistryPrx locatorRegistry = locatorInfo.getLocatorRegistry();
        if (locatorRegistry == null) {
            return;
        }
        try {
            if (this._replicaGroupId.length() == 0) {
                locatorRegistry.setAdapterDirectProxy(this._id, proxy);
            } else {
                locatorRegistry.setReplicatedAdapterDirectProxy(this._id, this._replicaGroupId, proxy);
            }
        }
        catch (AdapterNotFoundException ex) {
            if (this._instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("couldn't update object adapter `");
                s.append(this._id);
                s.append("' endpoints with the locator registry:\n");
                s.append("the object adapter is not known to the locator registry");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException ex1 = new NotRegisteredException();
            ex1.kindOfObject = "object adapter";
            ex1.id = this._id;
            throw ex1;
        }
        catch (InvalidReplicaGroupIdException ex) {
            if (this._instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("couldn't update object adapter `");
                s.append(this._id);
                s.append("' endpoints with the locator registry:\n");
                s.append("the replica group `");
                s.append(this._replicaGroupId);
                s.append("' is not known to the locator registry");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s.toString());
            }
            NotRegisteredException ex1 = new NotRegisteredException();
            ex1.kindOfObject = "replica group";
            ex1.id = this._replicaGroupId;
            throw ex1;
        }
        catch (AdapterAlreadyActiveException ex) {
            if (this._instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("couldn't update object adapter `");
                s.append(this._id);
                s.append("' endpoints with the locator registry:\n");
                s.append("the object adapter endpoints are already set");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s.toString());
            }
            ObjectAdapterIdInUseException ex1 = new ObjectAdapterIdInUseException();
            ex1.id = this._id;
            throw ex1;
        }
        catch (ObjectAdapterDeactivatedException ex) {
        }
        catch (CommunicatorDestroyedException ex) {
        }
        catch (LocalException e) {
            if (this._instance.traceLevels().location >= 1) {
                StringBuilder s = new StringBuilder(128);
                s.append("couldn't update object adapter `");
                s.append(this._id);
                s.append("' endpoints with the locator registry:\n");
                s.append(e.toString());
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s.toString());
            }
            throw e;
        }
        if (this._instance.traceLevels().location >= 1) {
            StringBuilder s = new StringBuilder(128);
            s.append("updated object adapter `");
            s.append(this._id);
            s.append("' endpoints with the locator registry\n");
            s.append("endpoints = ");
            if (proxy != null) {
                Endpoint[] endpoints = proxy.ice_getEndpoints();
                for (int i = 0; i < endpoints.length; ++i) {
                    s.append(endpoints[i].toString());
                    if (i + 1 >= endpoints.length) continue;
                    s.append(":");
                }
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, s.toString());
        }
    }

    boolean filterProperties(List<String> unknownProps) {
        boolean addUnknown = true;
        String prefix = this._name + ".";
        int i = 0;
        while (PropertyNames.clPropNames[i] != null) {
            if (prefix.startsWith(PropertyNames.clPropNames[i] + ".")) {
                addUnknown = false;
                break;
            }
            ++i;
        }
        boolean noProps = true;
        Map<String, String> props = this._instance.initializationData().properties.getPropertiesForPrefix(prefix);
        for (String prop : props.keySet()) {
            boolean valid = false;
            for (String suffix : _suffixes) {
                if (!prop.equals(prefix + suffix)) continue;
                noProps = false;
                valid = true;
                break;
            }
            if (valid || !addUnknown) continue;
            unknownProps.add(prop);
        }
        return noProps;
    }
}

