/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGridGUI.ApplicationPane;
import com.zeroc.IceGridGUI.LiveDeployment.CommunicatorEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Root;
import com.zeroc.IceGridGUI.LiveDeployment.TableField;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class RegistryEditor
extends CommunicatorEditor {
    private JTextField _hostname = new JTextField(20);
    private TableField _applications = new TableField("Name", "Last Update");
    private TableField _objects = new TableField("Proxy", "Type");
    private TableField _adapters = new TableField("ID", "Endpoints", "Replica Group");

    RegistryEditor() {
        this._hostname.setEditable(false);
        AbstractAction openDefinition = new AbstractAction("Open definition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._applications.getSelectedRow();
                if (selectedRow != -1) {
                    String appName = (String)RegistryEditor.this._applications.getValueAt(selectedRow, 0);
                    ApplicationPane app = ((Root)RegistryEditor.this._target).getCoordinator().openLiveApplication(appName);
                    if (app != null && app.getRoot().getSelectedNode() == null) {
                        app.getRoot().setSelectedNode(app.getRoot());
                    }
                }
            }
        };
        AbstractAction showDetails = new AbstractAction("Show details"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._applications.getSelectedRow();
                if (selectedRow != -1) {
                    String appName = (String)RegistryEditor.this._applications.getValueAt(selectedRow, 0);
                    ((Root)RegistryEditor.this._target).showApplicationDetails(appName);
                }
            }
        };
        final AbstractAction patch = new AbstractAction("Patch distribution"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._applications.getSelectedRow();
                if (selectedRow != -1) {
                    String appName = (String)RegistryEditor.this._applications.getValueAt(selectedRow, 0);
                    ((Root)RegistryEditor.this._target).patch(appName);
                }
            }
        };
        AbstractAction removeApplication = new AbstractAction("Remove from registry"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._applications.getSelectedRow();
                if (selectedRow != -1) {
                    String appName = (String)RegistryEditor.this._applications.getValueAt(selectedRow, 0);
                    int confirm = JOptionPane.showConfirmDialog(((Root)RegistryEditor.this._target).getCoordinator().getMainFrame(), "You are about to remove application '" + appName + "' from the IceGrid registry. Do you want to proceed?", "Remove Confirmation", 0);
                    if (confirm == 0) {
                        ((Root)RegistryEditor.this._target).getCoordinator().removeApplicationFromRegistry(appName);
                    }
                }
            }
        };
        removeApplication.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this._applications.getActionMap().put("delete", removeApplication);
        this._applications.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        final JPopupMenu appPopup = new JPopupMenu();
        appPopup.add(openDefinition);
        appPopup.add(showDetails);
        appPopup.addSeparator();
        appPopup.add(patch);
        appPopup.addSeparator();
        appPopup.add(removeApplication);
        this._applications.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow;
                if (e.getClickCount() == 2 && (selectedRow = RegistryEditor.this._applications.getSelectedRow()) != -1) {
                    String appName = (String)RegistryEditor.this._applications.getValueAt(selectedRow, 0);
                    ((Root)RegistryEditor.this._target).showApplicationDetails(appName);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                int selectedRow = RegistryEditor.this._applications.getSelectedRow();
                if (e.isPopupTrigger() && selectedRow != -1) {
                    String appName = (String)RegistryEditor.this._applications.getValueAt(selectedRow, 0);
                    ApplicationDescriptor desc = ((Root)RegistryEditor.this._target).getApplicationDescriptor(appName);
                    patch.setEnabled(desc != null && desc.distrib.icepatch.length() > 0);
                    appPopup.show(RegistryEditor.this._applications, e.getX(), e.getY());
                }
            }
        });
        AbstractAction deleteObject = new AbstractAction("Remove selected object"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                if (((Root)RegistryEditor.this._target).getCoordinator().connectedToMaster() && (selectedRow = RegistryEditor.this._objects.getSelectedRow()) != -1) {
                    ((Root)RegistryEditor.this._target).removeObject((String)RegistryEditor.this._objects.getValueAt(selectedRow, 0));
                }
            }
        };
        deleteObject.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this._objects.getActionMap().put("delete", deleteObject);
        this._objects.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        AbstractAction showObject = new AbstractAction("Show details"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._objects.getSelectedRow();
                if (selectedRow != -1) {
                    String proxy = (String)RegistryEditor.this._objects.getValueAt(selectedRow, 0);
                    String type = (String)RegistryEditor.this._objects.getValueAt(selectedRow, 1);
                    ((Root)RegistryEditor.this._target).showObject(proxy, type);
                }
            }
        };
        AbstractAction addObject = new AbstractAction("Add a new well-known object"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Root)RegistryEditor.this._target).getCoordinator().connectedToMaster()) {
                    ((Root)RegistryEditor.this._target).addObject();
                }
            }
        };
        addObject.putValue("AcceleratorKey", KeyStroke.getKeyStroke("INSERT"));
        this._objects.getActionMap().put("insert", addObject);
        this._objects.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "insert");
        this._objects.setToolTipText("<html>Well-known objects registered through the Admin interface.<br>Well-known objects registered using Adapter or Replica Group<br>definitions are not displayed here.</html>");
        final JPopupMenu objectsPopup = new JPopupMenu();
        objectsPopup.add(addObject);
        objectsPopup.addSeparator();
        final JMenuItem deleteObjectMenuItem = objectsPopup.add(deleteObject);
        objectsPopup.addSeparator();
        final JMenuItem showObjectMenuItem = objectsPopup.add(showObject);
        this._objects.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow;
                if (e.getClickCount() == 2 && (selectedRow = RegistryEditor.this._objects.getSelectedRow()) != -1) {
                    String proxy = (String)RegistryEditor.this._objects.getValueAt(selectedRow, 0);
                    String type = (String)RegistryEditor.this._objects.getValueAt(selectedRow, 1);
                    ((Root)RegistryEditor.this._target).showObject(proxy, type);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    showObjectMenuItem.setEnabled(RegistryEditor.this._objects.getSelectedRow() != -1);
                    deleteObjectMenuItem.setEnabled(RegistryEditor.this._objects.getSelectedRow() != -1);
                    objectsPopup.show(RegistryEditor.this._objects, e.getX(), e.getY());
                }
            }
        });
        AbstractAction deleteAdapter = new AbstractAction("Remove selected adapter"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow;
                if (((Root)RegistryEditor.this._target).getCoordinator().connectedToMaster() && (selectedRow = RegistryEditor.this._adapters.getSelectedRow()) != -1) {
                    ((Root)RegistryEditor.this._target).removeAdapter((String)RegistryEditor.this._adapters.getValueAt(selectedRow, 0));
                }
            }
        };
        deleteAdapter.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this._adapters.getActionMap().put("delete", deleteAdapter);
        this._adapters.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this._adapters.setToolTipText("<html>Object adapters registered at run time.</html>");
        final JPopupMenu adaptersPopup = new JPopupMenu();
        adaptersPopup.add(deleteAdapter);
        this._adapters.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger() && RegistryEditor.this._adapters.getSelectedRow() != -1) {
                    adaptersPopup.show(RegistryEditor.this._adapters, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    protected void appendProperties(DefaultFormBuilder builder) {
        CellConstraints cc = new CellConstraints();
        builder.append("Hostname");
        builder.append((Component)this._hostname, 3);
        builder.nextLine();
        this.appendRuntimeProperties(builder);
        builder.appendSeparator("Deployed Applications");
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-14);
        JScrollPane scrollPane = new JScrollPane(this._applications);
        scrollPane.setToolTipText(this._applications.getToolTipText());
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 14));
        builder.nextRow(14);
        builder.nextLine();
        builder.appendSeparator("Dynamic Well-Known Objects");
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-14);
        scrollPane = new JScrollPane(this._objects);
        scrollPane.setToolTipText(this._objects.getToolTipText());
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 14));
        builder.nextRow(14);
        builder.nextLine();
        builder.appendSeparator("Dynamic Object Adapters");
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-14);
        scrollPane = new JScrollPane(this._adapters);
        scrollPane.setToolTipText(this._adapters.getToolTipText());
        builder.add((Component)scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 14));
        builder.nextRow(14);
        builder.nextLine();
    }

    @Override
    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Registry Properties");
    }

    void show(Root root) {
        Root previous = (Root)this._target;
        this._target = root;
        this._hostname.setText(root.getRegistryInfo().hostname);
        this.showRuntimeProperties(previous);
        this._applications.setSortedMap(root.getApplicationMap());
        this._objects.setObjects(root.getObjects());
        this._adapters.setAdapters(root.getAdapters());
    }
}

