/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceStorm;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import com.zeroc.IceStorm.TopicPrx;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class TopicDictHelper {
    public static void write(OutputStream ostr, Map<String, TopicPrx> v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.size());
            for (Map.Entry<String, TopicPrx> e : v.entrySet()) {
                ostr.writeString(e.getKey());
                ostr.writeProxy(e.getValue());
            }
        }
    }

    public static Map<String, TopicPrx> read(InputStream istr) {
        HashMap<String, TopicPrx> v = new HashMap<String, TopicPrx>();
        int sz0 = istr.readSize();
        for (int i0 = 0; i0 < sz0; ++i0) {
            String key = istr.readString();
            TopicPrx value = TopicPrx.uncheckedCast(istr.readProxy());
            v.put(key, value);
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<Map<String, TopicPrx>> v) {
        if (v != null && v.isPresent()) {
            TopicDictHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, Map<String, TopicPrx> v) {
        if (ostr.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = ostr.startSize();
            TopicDictHelper.write(ostr, v);
            ostr.endSize(pos);
        }
    }

    public static Optional<Map<String, TopicPrx>> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.FSize)) {
            istr.skip(4);
            Map<String, TopicPrx> v = TopicDictHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

