/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.kn;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_kn extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0cbe\u0cb8\u0ccd\u0c95\u0ccb \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Argentina = new String[] {
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Hovd = new String[] {
               "\u0cb9\u0ccb\u0cb5\u0ccd\u0ca6\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "HST",
               "\u0cb9\u0ccb\u0cb5\u0ccd\u0ca1\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "HST",
               "\u0cb9\u0ccb\u0cb5\u0ccd\u0ca6\u0ccd\u200c\u200c \u0cb8\u0cae\u0caf",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u0cae\u0c98\u0ca6\u0cbe\u0ca8\u0ccd\u200c\u0ca8 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0c98\u0ca6\u0cbe\u0ca8\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0c98\u0ca6\u0cbe\u0ca8\u0ccd\u200c\u0ca8 \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ACWST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ACWDT",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb8\u0cae\u0caf",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CEST",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "CEST",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0\u0cc0\u0caf \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cb8\u0cae\u0caf",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0cb8\u0c96\u0cb2\u0cbf\u0ca8\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "SST",
               "\u0cb6\u0cbe\u0c95\u0cb2\u0cbf\u0ca8\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "SST",
               "\u0cb8\u0c96\u0cbe\u0cb2\u0cbf\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "\u0cae\u0c95\u0ccd\u0cb5\u0cbe\u0cb0\u0cbf \u0cb8\u0cae\u0caf",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0ca6 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "EDT",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0cb8\u0cae\u0caf",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc2\u0cb6\u0cbf\u0caf\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "HAST",
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf-\u0c85\u0cb2\u0ccd\u0caf\u0cc2\u0cb6\u0cbf\u0caf\u0ca8\u0ccd \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "HADT",
               "\u0cb9\u0cb5\u0cbe\u0caf\u0cbf \u0c85\u0cb2\u0ccd\u0caf\u0cc2\u0cb7\u0cbf\u0caf\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "ACST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ACDT",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd\u200c \u0cb9\u0cca\u0cb5\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "LHST",
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd\u200c \u0cb9\u0cca\u0cb5\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "LHDT",
               "\u0cb2\u0cbe\u0cb0\u0ccd\u0ca1\u0ccd\u200c \u0cb9\u0cca\u0cb5\u0cc6 \u0cb8\u0cae\u0caf",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "\u0caf\u0c95\u0cc1\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0c95\u0cc1\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0c95\u0cc1\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0cb8\u0cae\u0caf",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "\u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "PST",
               "\u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "PDT",
               "\u0caa\u0cc6\u0cb8\u0cbf\u0cab\u0cbf\u0c95\u0ccd \u0cb8\u0cae\u0caf",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WEST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "WEST",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cb8\u0cae\u0caf",
               "WET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "EEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "EEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caf\u0cc2\u0cb0\u0ccb\u0caa\u0ccd \u0cb8\u0cae\u0caf",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NST",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "NDT",
               "\u0ca8\u0ccd\u0caf\u0cc2\u0cab\u0ccc\u0c82\u0ca1\u0ccd\u200c\u0cb2\u0ccd\u0caf\u0cbe\u0c82\u0ca1\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "WAST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "WAST",
               "\u0c85\u0cb0\u0ccd\u0c9c\u0cc6\u0c82\u0c9f\u0cbf\u0ca8\u0cbe \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb8\u0cae\u0caf",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "ADT",
               "\u0c85\u0c9f\u0ccd\u0cb2\u0cbe\u0c82\u0c9f\u0cbf\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0caf\u0cbf\u0c95\u0c9f\u0cc6\u0cb0\u0cc6\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0cbf\u0c95\u0c9f\u0cc6\u0cb0\u0cc6\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "YST",
               "\u0caf\u0cbf\u0c95\u0c9f\u0cc6\u0cb0\u0cc6\u0ca8\u0ccd\u200c\u0cac\u0cb0\u0ccd\u0c97\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "\u0cb5\u0cca\u0cb2\u0ccd\u0c97\u0cca\u0c97\u0ccd\u0cb0\u0cbe\u0ca6\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0cca\u0cb2\u0ccd\u0c97\u0cca\u0c97\u0ccd\u0cb0\u0cbe\u0ca6\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0cca\u0cb2\u0ccd\u0c97\u0cca\u0c97\u0ccd\u0cb0\u0cbe\u0ca6\u0ccd\u200c\u200c \u0cb8\u0cae\u0caf",
               "VT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0c87\u0c82\u0ca1\u0cca\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb8\u0cae\u0caf",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0c87\u0c82\u0ca1\u0cca\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0cb8\u0cae\u0caf",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Omsk = new String[] {
               "\u0c93\u0cae\u0ccd\u200c\u0cb8\u0ccd\u0c95\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "OST",
               "\u0c93\u0cae\u0ccd\u0cb8\u0ccd\u200c\u0c95\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "OST",
               "\u0c93\u0cae\u0ccd\u200c\u200c\u0cb8\u0ccd\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AWST",
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AWDT",
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c87\u0c82\u0ca1\u0ccb\u0ca8\u0cc7\u0cb7\u0ccd\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "\u0c89\u0cb2\u0ca8\u0ccd\u200c \u0cac\u0cbe\u0c9f\u0cca\u0cb0\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "UBST",
               "\u0c89\u0cb2\u0ca8\u0ccd\u200c \u0cac\u0ca4\u0ccb\u0cb0\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "UBST",
               "\u0c89\u0cb2\u0ca8\u0ccd\u200c \u0cac\u0cbe\u0c9f\u0cca\u0cb0\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "CDT",
               "\u0c95\u0cc7\u0c82\u0ca6\u0ccd\u0cb0 \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AEST",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AEDT",
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c86\u0cb8\u0ccd\u0c9f\u0ccd\u0cb0\u0cc7\u0cb2\u0cbf\u0caf\u0cbe \u0cb8\u0cae\u0caf",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "\u0cae\u0ccc\u0c82\u0c9f\u0cc7\u0ca8\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "MST",
               "\u0cae\u0ccc\u0c82\u0c9f\u0cc7\u0ca8\u0ccd\u200c \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "MDT",
               "\u0cae\u0ccc\u0c82\u0c9f\u0cc7\u0ca8\u0ccd \u0cb8\u0cae\u0caf",
               "MT",
            };
        final String[] Alaska = new String[] {
               "\u0c85\u0cb2\u0cb8\u0ccd\u0c95\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AKST",
               "\u200c\u0c85\u0cb2\u0cbe\u0cb8\u0ccd\u0c95\u0cbe \u0cb9\u0c97\u0cb2\u0cc1 \u0cb8\u0cae\u0caf",
               "AKDT",
               "\u0c85\u0cb2\u0cbe\u0cb8\u0ccd\u0c95\u0cbe \u0cb8\u0cae\u0caf",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0ca8\u0cca\u0cb5\u0cb8\u0ccd\u200c\u200c\u0cac\u0cbf\u0cb8\u0cb0\u0ccd\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "NST",
               "\u0ca8\u0cca\u0cb5\u0cb8\u0ccd\u200c\u200c\u0cac\u0cbf\u0cb8\u0cb0\u0ccd\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0c95\u0cbe\u0cb2",
               "NST",
               "\u0ca8\u0cca\u0cb5\u0cb8\u0ccd\u200c\u200c\u0cac\u0cbf\u0cb8\u0cb0\u0ccd\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "\u0cb5\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0ca6\u0cbf\u0cb5\u0cca\u0cb8\u0ccd\u0ca4\u0cca\u0c95\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0ca6\u0cbf\u0cb5\u0cca\u0cb8\u0ccd\u0ca4\u0cca\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "VST",
               "\u0cb5\u0ccd\u0cb2\u0ccd\u0caf\u0cbe\u0ca6\u0cbf\u0cb5\u0cca\u0cb8\u0ccd\u0ca4\u0cca\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "\u0c87\u0cb0\u0c95\u0cc2\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IST",
               "\u0c87\u0cb0\u0c95\u0cc2\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "IST",
               "\u0c87\u0cb0\u0c95\u0cc2\u0ca4\u0ccd\u0cb8\u0c95\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "IT",
            };
        final String[] Noronha = new String[] {
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "FNST",
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "FNST",
               "\u0cab\u0cb0\u0ccd\u0ca8\u0cbe\u0c82\u0ca1\u0ccb \u0ca6\u0cc6 \u0ca8\u0cca\u0cb0\u0cca\u0ca8\u0ccd\u0cb9\u0cbe \u0cb8\u0cae\u0caf",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd\u200c \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "CST",
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cbe\u0cb2\u0ccd\u0cb8\u0ca8\u0ccd\u200c\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0c95\u0cbe\u0cb2",
               "CST",
               "\u0c9a\u0cca\u0caf\u0ccd\u200c\u200c\u0cac\u0cb2\u0ccd\u0cb8\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "BST",
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "BST",
               "\u0cac\u0ccd\u0cb0\u0cc6\u0cb8\u0cbf\u0cb2\u0cbf\u0caf\u0cbe\u0ca6 \u0cb8\u0cae\u0caf",
               "BT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0c95\u0ccd\u0cb0\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe\u0cb0\u0ccd\u0c95\u0ccd\u0cb8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "KST",
               "\u0c95\u0ccd\u0cb0\u0cbe\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe\u0cb0\u0ccd\u0cb8\u0c95\u0ccd\u200c \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "KST",
               "\u0c95\u0ccd\u0cb0\u0cb8\u0ccd\u0ca8\u0cbf\u0caf\u0cbe\u0cb0\u0ccd\u0c95\u0ccd\u0cb8\u0ccd \u0cb8\u0cae\u0caf",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0caa\u0cb6\u0ccd\u0c9a\u0cbf\u0cae \u0c95\u0c9d\u0c95\u0ccd\u200c\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] India = new String[] {
               "\u0cad\u0cbe\u0cb0\u0ca4\u0cc0\u0caf \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Amazon = new String[] {
               "\u0c85\u0cae\u0cc7\u0c9c\u0cbe\u0ca8\u0ccd \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cae\u0cc7\u0c9c\u0cbe\u0ca8\u0ccd \u0cac\u0cc7\u0cb8\u0cbf\u0c97\u0cc6 \u0cb8\u0cae\u0caf",
               "AST",
               "\u0c85\u0cae\u0cc6\u0c9c\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5 \u0c95\u0c9d\u0c95\u0ccd\u200c\u0cb8\u0ccd\u0ca4\u0cbe\u0ca8\u0ccd\u200c \u0cb8\u0cae\u0caf",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "America/Cuiaba", Amazon },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "America/Manaus", Amazon },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Colombo", India },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Barbados", Atlantic },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "America/Rio_Branco", Amazon },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "America/Nome", Alaska },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Rainy_River", America_Central },
            { "Europe/Belgrade", Europe_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "Asia/Calcutta", India },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
