#!/bin/sh
# Crontab File for the Network Security Analysis Tool by Mixter
# usage: ./cron.sh -install  # create crontab entry
#        ./cron.sh           # try to restart nsat session

# Please edit these path variables before you run the script:
PATH_TO_NSAT_BINARY=/usr/local/bin/nsat
PATH_TO_SCANNING_DIR=/home/user/scanlogs
PATH_TO_THIS_FILE=/home/user/scanlogs/cron.sh

if [ x$1 = "x-install" ]
then
if ! test -x $PATH_TO_NSAT_BINARY
 then echo "* Cannot find $PATH_TO_NSAT_BINARY - STOP" ; exit ; fi
if ! test -d $PATH_TO_SCANNING_DIR
 then echo "* Cannot find " $PATH_TO_SCANNING_DIR " - STOP" ; exit ; fi
if ! test -x $PATH_TO_THIS_FILE
 then echo "* Cannot find " $PATH_TO_THIS_FILE " - STOP" ; exit ; fi

echo "* Creating crontab entry for NSAT"
echo "10,30,50 * * * *   " $PATH_TO_THIS_FILE > .crontab
crontab .crontab && crontab -l && \
echo "* Created entry successfully"

exit 0
fi

cd $PATH_TO_SCANNING_DIR && $PATH_TO_NSAT_BINARY >/dev/null 2>/dev/null

exit 0
