// -*- C++ -*-
#include "Rivet/Analysis.hh"
#include "Rivet/Projections/FinalState.hh"
#include "Rivet/Projections/UnstableParticles.hh"

namespace Rivet {


  /// @brief Add a short analysis description here
  class BELLE_2007_I723333 : public Analysis {
  public:

    /// Constructor
    RIVET_DEFAULT_ANALYSIS_CTOR(BELLE_2007_I723333);


    /// @name Analysis methods
    /// @{

    /// Book histograms and initialise projections before the run
    void init() {

      // Initialise and register projections
      declare(FinalState(), "FS");
      declare(UnstableParticles(), "UFS");
      book(_nDSS, "/TMP/nDSS");
      book(_nDS, "/TMP/nDS");
    }

    void findChildren(const Particle & p,map<long,int> & nRes, int &ncount) {
      for (const Particle &child : p.children()) {
        if (child.children().empty()) {
          nRes[child.pid()]-=1;
          --ncount;
        }
        else {
          findChildren(child,nRes,ncount);
        }
      }
    }

    /// Perform the per-event analysis
    void analyze(const Event& event) {
      const FinalState& fs = apply<FinalState>(event, "FS");

      map<long,int> nCount;
      int ntotal(0);
      for (const Particle& p : fs.particles()) {
        nCount[p.pid()] += 1;
        ++ntotal;
      }
      const FinalState& ufs = apply<FinalState>(event, "UFS");

      for (unsigned int ix=0; ix<ufs.particles().size(); ++ix) {
        const Particle& p1 = ufs.particles()[ix];
        if (abs(p1.pid())!=413) continue;
        map<long,int> nRes = nCount;
        int ncount = ntotal;
        findChildren(p1,nRes,ncount);
        bool matched=false;
        int sign = -p1.pid()/abs(p1.pid());
        for (unsigned int iy=0; iy<ufs.particles().size(); ++iy) {
          if (ix==iy) continue;
          const Particle& p2 = ufs.particles()[iy];
          if (!p2.parents().empty() && p2.parents()[0].pid()==p1.pid()) {
            continue;
          }
          if (p2.pid()!=sign*413 && p2.pid()!=sign*411) continue;
          map<long,int> nRes2 = nRes;
          int ncount2 = ncount;
          findChildren(p2,nRes2,ncount2);
          if (ncount2!=0) continue;
          matched=true;
          for (const auto& val : nRes2) {
            if (val.second!=0) {
              matched = false;
              break;
            }
          }
          if (matched) {
            sign = abs(p2.pid());
            break;
          }
        }
        if (matched) {
          if (sign==411) {
            _nDS->fill();
          }
          else if (sign==413) {
            _nDSS->fill();
          }
        }
      }
    }


    /// Normalise histograms etc., after the run
    void finalize() {
      scale({_nDSS,_nDS}, crossSection()/ sumOfWeights() /nanobarn);
      for (unsigned int ix=1; ix<3; ++ix) {
        Estimate1DPtr mult;
        book(mult, ix, 1, 1);
        for (auto& b : mult->bins()) {
          if (inRange(sqrtS()/GeV, b.xMin(), b.xMax())) {
            b.set( (ix==1? _nDSS : _nDS)->val(),
                   (ix==1? _nDSS : _nDS)->err() );
          }
        }
      }
    }

    /// @}


    /// @name Histograms
    /// @{
    CounterPtr _nDSS,_nDS;
    /// @}


  };


  RIVET_DECLARE_PLUGIN(BELLE_2007_I723333);


}
